/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.common.util.NamedElementComparator;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class ModelConsolidator {
    public static final String SOURCE_CLASS_ANNOTATION = "org.eclipse.mdht.sourceClass";
    private Package sourcePackage;
    private Map<Classifier, List<Classifier>> sourceInheritance = new HashMap<Classifier, List<Classifier>>();
    private Package consolPackage;
    private Map<String, Class> consolMapping = new HashMap<String, Class>();
    private Map<String, String> qnameMapping = new HashMap<String, String>();
    private Map<Classifier, List<Classifier>> consolInheritance = new HashMap<Classifier, List<Classifier>>();
    private List<Classifier> importedClassifiers = new ArrayList<Classifier>();
    private Set<Classifier> processedClassifiers = new HashSet<Classifier>();
    private boolean includeBaseModel = false;

    public void initialize(Package sourcePackage, Package consolPackage) {
        this.sourcePackage = sourcePackage;
        this.consolPackage = consolPackage;
        if (sourcePackage != null) {
            EcoreUtil.resolveAll((Resource)sourcePackage.eResource());
            this.mapClassInheritance(sourcePackage, this.sourceInheritance);
        }
        if (consolPackage != null) {
            EcoreUtil.resolveAll((Resource)consolPackage.eResource());
            this.mapExistingConsolidation();
            this.mapConsolInheritance(consolPackage, this.consolInheritance);
        }
    }

    public boolean isIncludeBaseModel() {
        return this.includeBaseModel;
    }

    public void setIncludeBaseModel(boolean includeBaseModel) {
        this.includeBaseModel = includeBaseModel;
    }

    protected boolean isBaseModel(Element element) {
        return false;
    }

    protected boolean isReferenceModel(Element element) {
        return this.isBaseModel(element);
    }

    protected Class getBaseModelClass(Classifier subClassifier) {
        Class baseModelClass = null;
        if (this.isBaseModel((Element)subClassifier) && subClassifier instanceof Class) {
            return (Class)subClassifier;
        }
        for (Classifier parent : subClassifier.allParents()) {
            if (parent.getNearestPackage() == null || !this.isBaseModel((Element)parent) || !(parent instanceof Class)) continue;
            baseModelClass = (Class)parent;
            break;
        }
        return baseModelClass;
    }

    protected Property getBaseModelProperty(Property property) {
        if (property.getClass_() == null) {
            return null;
        }
        if (this.isBaseModel((Element)property)) {
            return property;
        }
        for (Classifier parent : property.getClass_().allParents()) {
            for (Property inherited : parent.getAttributes()) {
                if (!inherited.getName().equals(property.getName()) || !this.isBaseModel((Element)inherited)) continue;
                return inherited;
            }
        }
        return null;
    }

    protected boolean isXMLAttribute(Property property) {
        Stereotype eAttribute;
        Property baseProperty = this.getBaseModelProperty(property);
        return baseProperty != null && (eAttribute = baseProperty.getAppliedStereotype("Ecore::EAttribute")) != null;
    }

    public List<Classifier> getImportedClassifiers() {
        return this.importedClassifiers;
    }

    public void addImportedClassifier(Classifier classifier) {
        if (!this.importedClassifiers.contains(classifier)) {
            this.importedClassifiers.add(classifier);
        }
    }

    public Set<Classifier> getProcessedClassifiers() {
        return this.processedClassifiers;
    }

    public void addProcessedClassifier(Classifier classifier) {
        if (!this.processedClassifiers.contains(classifier)) {
            this.processedClassifiers.add(classifier);
        }
    }

    public Map<String, Class> getConsolMapping() {
        return this.consolMapping;
    }

    public void removeAllConsolidationAnnotations() {
        for (Type type : this.consolPackage.getOwnedTypes()) {
            EAnnotation annotation = type.getEAnnotation(SOURCE_CLASS_ANNOTATION);
            if (annotation == null) continue;
            type.getEAnnotations().remove((Object)annotation);
        }
    }

    public void renameReferencesInOCL() {
    }

    public Class consolidateClass(Class sourceClass) {
        if (this.isBaseModel((Element)sourceClass)) {
            return sourceClass;
        }
        Class consolidatedClass = this.consolMapping.get(EcoreUtil.getURI((EObject)sourceClass).toString());
        if (consolidatedClass == null && (consolidatedClass = this.findConsolSpecialization(sourceClass)) == null) {
            consolidatedClass = this.copyToConsolPackage(sourceClass);
            this.mergeInheritedProperties(sourceClass, consolidatedClass);
        }
        return consolidatedClass;
    }

    public List<Property> getAllProperties(Classifier umlClass) {
        return this.getAllProperties(umlClass, null);
    }

    public List<Property> getAllProperties(Classifier umlClass, Class consolidationStop) {
        int index;
        ArrayList<Property> allProperties = new ArrayList<Property>();
        ArrayList<Property> allAssociations = new ArrayList<Property>();
        List<Classifier> consolidatedParents = this.getConsolidatedGeneralizations(umlClass, this.getConsolSource(consolidationStop));
        int i = consolidatedParents.size() - 1;
        while (i >= 0) {
            Classifier parent = consolidatedParents.get(i);
            for (Property property : UMLUtil.getOwnedAttributes((Type)parent)) {
                if (property.getAssociation() != null) {
                    allAssociations.add(property);
                    continue;
                }
                index = this.findProperty(allProperties, property.getName());
                if (index >= 0) {
                    allProperties.set(index, property);
                    continue;
                }
                allProperties.add(property);
            }
            --i;
        }
        Iterator propertyIterator = allProperties.iterator();
        while (propertyIterator.hasNext()) {
            Property property = (Property)propertyIterator.next();
            if (this.isIncludeBaseModel() || !this.isBaseModel((Element)property) || property.getLower() != 0) continue;
            propertyIterator.remove();
        }
        Iterator associationIterator = allAssociations.iterator();
        while (associationIterator.hasNext()) {
            Property property;
            property = (Property)associationIterator.next();
            if (this.isIncludeBaseModel() || !this.isBaseModel((Element)property) || property.getLower() != 0) continue;
            associationIterator.remove();
        }
        ArrayList<Classifier> endTypes = new ArrayList<Classifier>();
        ArrayList<Property> redefinedProperties = new ArrayList<Property>();
        for (Property property : allAssociations) {
            Classifier type = (Classifier)property.getType();
            endTypes.add(type);
            int dupIndex = endTypes.indexOf(type);
            if (dupIndex < 0 || property.getClass_() == ((Property)allAssociations.get(dupIndex)).getClass_()) continue;
            redefinedProperties.add((Property)allAssociations.get(dupIndex));
        }
        index = 0;
        while (index < allAssociations.size()) {
            Classifier endType = (Classifier)endTypes.get(index);
            boolean hasSpecialization = false;
            for (Classifier specific : UMLUtil.getAllSpecializations(endType)) {
                if (!endTypes.contains(specific)) continue;
                hasSpecialization = true;
                break;
            }
            Property assocProperty = (Property)allAssociations.get(index);
            if (!hasSpecialization && !redefinedProperties.contains(assocProperty)) {
                allProperties.add(assocProperty);
            }
            ++index;
        }
        return allProperties;
    }

    protected void mergeInheritedProperties(Class sourceClass, Class consolidatedClass) {
        Property mergedProperty;
        Class baseModelClass = this.getBaseModelClass((Classifier)sourceClass);
        List<Classifier> allConsolidatedParents = UMLUtil.getAllGeneralizations((Classifier)consolidatedClass);
        Class consolidationStop = null;
        for (Classifier consolParent : allConsolidatedParents) {
            if (!this.isIncludeBaseModel() && (this.isBaseModel((Element)consolParent) || this.isReferenceModel((Element)consolParent))) continue;
            Class parentConsolClass = this.consolMapping.get(EcoreUtil.getURI((EObject)consolParent).toString());
            if (parentConsolClass != null && parentConsolClass != consolidatedClass) {
                consolidationStop = parentConsolClass;
                break;
            }
            Class consolSpecial = this.findConsolSpecialization((Class)consolParent);
            if (consolSpecial == null) continue;
        }
        List<Classifier> consolidatedParents = this.getConsolidatedGeneralizations((Classifier)consolidatedClass, this.getConsolSource(consolidationStop));
        List<Property> allProperties = this.getAllProperties((Classifier)consolidatedClass, consolidationStop);
        ArrayList<Property> allAttributes = new ArrayList<Property>();
        ArrayList<Constraint> allConstraints = new ArrayList<Constraint>();
        int i = consolidatedParents.size() - 1;
        while (i >= 0) {
            Class parent = (Class)consolidatedParents.get(i);
            if (!this.isBaseModel((Element)parent)) {
                for (Constraint constraint : parent.getOwnedRules()) {
                    allConstraints.add(constraint);
                }
            }
            --i;
        }
        for (Property property : allProperties) {
            if (!this.isXMLAttribute(property)) continue;
            allAttributes.add(property);
        }
        allProperties.removeAll(allAttributes);
        Collections.sort(allAttributes, new NamedElementComparator());
        for (Property property : allAttributes) {
            mergedProperty = null;
            if (consolidatedClass.getOwnedAttributes().contains((Object)property)) {
                mergedProperty = property;
                consolidatedClass.getOwnedAttributes().remove((Object)property);
                consolidatedClass.getOwnedAttributes().add((Object)property);
                continue;
            }
            mergedProperty = (Property)EcoreUtil.copy((EObject)property);
            consolidatedClass.getOwnedAttributes().add((Object)mergedProperty);
            UMLUtil.cloneStereotypes((Element)property, (Element)mergedProperty);
        }
        for (Property property : allProperties) {
            Class sourceType;
            Type endType;
            mergedProperty = null;
            if (consolidatedClass.getOwnedAttributes().contains((Object)property)) {
                mergedProperty = property;
                consolidatedClass.getOwnedAttributes().remove((Object)property);
                consolidatedClass.getOwnedAttributes().add((Object)mergedProperty);
            } else {
                mergedProperty = (Property)EcoreUtil.copy((EObject)property);
                consolidatedClass.getOwnedAttributes().add((Object)mergedProperty);
                UMLUtil.cloneStereotypes((Element)property, (Element)mergedProperty);
            }
            mergedProperty.getRedefinedProperties().clear();
            mergedProperty.getSubsettedProperties().clear();
            if (property.getAssociation() == null || !((endType = property.getType()) instanceof Class)) continue;
            Class consolType = null;
            if (!this.isBaseModel((Element)endType) && (consolType = this.findConsolSpecialization((Class)endType)) == null && (sourceType = this.findSourceSpecialization((Class)endType)) != null) {
                consolType = this.consolidateClass(sourceType);
            }
            if (consolType == null) {
                if (endType.eIsProxy()) {
                    System.err.println("Property type is unresolved proxy: " + property.getQualifiedName());
                } else {
                    consolType = this.consolidateClass((Class)endType);
                }
            }
            mergedProperty.setType((Type)consolType);
            if (property.getAssociation().getNearestPackage() == consolidatedClass.getNearestPackage()) continue;
            Association assocClone = (Association)consolidatedClass.getNearestPackage().createOwnedType(null, UMLPackage.Literals.ASSOCIATION);
            assocClone.getMemberEnds().add((Object)mergedProperty);
            Property ownedEnd = UMLFactory.eINSTANCE.createProperty();
            ownedEnd.setType((Type)consolidatedClass);
            assocClone.getOwnedEnds().add((Object)ownedEnd);
            UMLUtil.cloneStereotypes((Element)property.getAssociation(), (Element)assocClone);
        }
        for (Constraint constraint : allConstraints) {
            if (consolidatedClass.getOwnedRules().contains((Object)constraint)) {
                consolidatedClass.getOwnedRules().remove((Object)constraint);
                consolidatedClass.getOwnedRules().add((Object)constraint);
                continue;
            }
            Constraint clone = (Constraint)EcoreUtil.copy((EObject)constraint);
            consolidatedClass.getOwnedRules().add((Object)clone);
            UMLUtil.cloneStereotypes((Element)constraint, (Element)clone);
            clone.getConstrainedElements().clear();
        }
        ArrayList currentComments = new ArrayList(consolidatedClass.getOwnedComments());
        consolidatedClass.getOwnedComments().clear();
        int i2 = 1;
        while (i2 < consolidatedParents.size()) {
            Classifier parent = consolidatedParents.get(i2);
            ArrayList comments = new ArrayList(parent.getOwnedComments());
            Iterator iterator = comments.iterator();
            while (iterator.hasNext()) {
                Comment comment = (Comment)iterator.next();
                Comment clone = (Comment)EcoreUtil.copy((EObject)comment);
                consolidatedClass.getOwnedComments().add((Object)clone);
                UMLUtil.cloneStereotypes((Element)comment, (Element)clone);
            }
            if (comments.size() > 0) break;
            ++i2;
        }
        consolidatedClass.getOwnedComments().addAll(currentComments);
        for (Comment comment : consolidatedClass.getOwnedComments()) {
            comment.getAnnotatedElements().clear();
            comment.getAnnotatedElements().add((Object)consolidatedClass);
        }
        consolidatedClass.getGeneralizations().clear();
        if (!this.isIncludeBaseModel() && consolidationStop != null) {
            consolidatedClass.createGeneralization((Classifier)consolidationStop);
        }
        if (!this.isIncludeBaseModel() && baseModelClass != null && consolidatedClass.getGeneralizations().isEmpty()) {
            consolidatedClass.createGeneralization((Classifier)baseModelClass);
        }
        if (this.isIncludeBaseModel()) {
            ArrayList substitutions = new ArrayList(consolidatedClass.getSubstitutions());
            for (Substitution subst : substitutions) {
                subst.destroy();
            }
            consolidatedClass.createSubstitution(null, (Classifier)baseModelClass);
        } else {
            HashSet<Class> substitutions = new HashSet<Class>();
            List<Classifier> allSourceParents = UMLUtil.getAllGeneralizations((Classifier)sourceClass);
            int i3 = allSourceParents.size() - 1;
            while (i3 >= 0) {
                Class parent = (Class)allSourceParents.get(i3);
                if ((this.isIncludeBaseModel() || !this.isReferenceModel((Element)parent) && !this.isBaseModel((Element)parent)) && !substitutions.contains(parent)) {
                    substitutions.add(parent);
                }
                --i3;
            }
        }
    }

    protected void mapExistingConsolidation() {
        for (Type consolType : this.consolPackage.getOwnedTypes()) {
            EAnnotation annotation;
            if (!(consolType instanceof Class) || (annotation = consolType.getEAnnotation(SOURCE_CLASS_ANNOTATION)) == null || annotation.getReferences().isEmpty()) continue;
            for (EObject reference : annotation.getReferences()) {
                if (!(reference instanceof Class)) continue;
                this.consolMapping.put(EcoreUtil.getURI((EObject)reference).toString(), (Class)consolType);
            }
        }
    }

    protected Class copyToConsolPackage(Class sourceClass) {
        Class mappedClass = this.consolMapping.get(EcoreUtil.getURI((EObject)sourceClass).toString());
        if (mappedClass == null) {
            Class mappedOwner;
            if (sourceClass.getOwner() instanceof Class && (mappedOwner = this.consolMapping.get(EcoreUtil.getURI((EObject)sourceClass.getOwner()).toString())) != null) {
                mappedClass = (Class)mappedOwner.getNestedClassifier(sourceClass.getName());
            }
            if (mappedClass == null) {
                mappedClass = (Class)EcoreUtil.copy((EObject)sourceClass);
                this.consolPackage.getOwnedTypes().add((Object)mappedClass);
                UMLUtil.cloneStereotypes(sourceClass, mappedClass);
            }
            this.consolMapping.put(EcoreUtil.getURI((EObject)sourceClass).toString(), mappedClass);
            this.consolInheritance.put((Classifier)mappedClass, UMLUtil.getAllGeneralizations((Classifier)sourceClass));
            if (!sourceClass.getQualifiedName().equals(mappedClass.getQualifiedName())) {
                this.qnameMapping.put(sourceClass.getQualifiedName(), mappedClass.getQualifiedName());
                List<Classifier> allParents = UMLUtil.getAllGeneralizations((Classifier)sourceClass);
                for (Classifier classifier : allParents) {
                    if (this.isBaseModel((Element)classifier) || this.isReferenceModel((Element)classifier) || this.qnameMapping.get(classifier.getQualifiedName()) != null) continue;
                    this.qnameMapping.put(classifier.getQualifiedName(), mappedClass.getQualifiedName());
                }
            }
            EAnnotation sourceAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            sourceAnnotation.setSource(SOURCE_CLASS_ANNOTATION);
            sourceAnnotation.getReferences().add((Object)sourceClass);
            mappedClass.getEAnnotations().add((Object)sourceAnnotation);
            for (Property property : sourceClass.getOwnedAttributes()) {
                Property mappedProperty;
                if (property.getAssociation() == null || (mappedProperty = mappedClass.getOwnedAttribute(property.getName(), property.getType())) == null) continue;
                Association assocClone = (Association)mappedClass.getNearestPackage().createOwnedType(null, UMLPackage.Literals.ASSOCIATION);
                assocClone.getMemberEnds().add((Object)mappedProperty);
                Property ownedEnd = UMLFactory.eINSTANCE.createProperty();
                ownedEnd.setType((Type)mappedClass);
                assocClone.getOwnedEnds().add((Object)ownedEnd);
                UMLUtil.cloneStereotypes((Element)property.getAssociation(), (Element)assocClone);
            }
        }
        return mappedClass;
    }

    protected List<Classifier> getConsolidatedGeneralizations(Classifier consolidatedClass, Class consolidationStop) {
        ArrayList<Classifier> parents = new ArrayList<Classifier>();
        parents.add(consolidatedClass);
        for (Classifier parent : consolidatedClass.getGenerals()) {
            Class special = this.findConsolSpecialization((Class)parent);
            if (special != null) {
                special = this.getConsolSource(special);
            }
            if (consolidationStop != null && (parents.contains(parent) || consolidationStop.equals(parent) || consolidationStop.equals(special))) continue;
            parents.addAll(this.getConsolidatedGeneralizations(parent, consolidationStop));
        }
        return parents;
    }

    private void mapClassInheritance(Package umlPackage, Map<Classifier, List<Classifier>> map) {
        for (Type type : umlPackage.getOwnedTypes()) {
            if (!(type instanceof Class)) continue;
            this.mapClassInheritance((Class)type, map);
        }
    }

    private void mapConsolInheritance(Package umlPackage, Map<Classifier, List<Classifier>> map) {
        for (Type type : umlPackage.getOwnedTypes()) {
            if (!(type instanceof Class)) continue;
            this.mapConsolInheritance((Class)type, map);
        }
    }

    private void mapClassInheritance(Class umlClass, Map<Classifier, List<Classifier>> map) {
        map.put((Classifier)umlClass, UMLUtil.getAllGeneralizations((Classifier)umlClass));
    }

    private void mapConsolInheritance(Class umlClass, Map<Classifier, List<Classifier>> map) {
        EAnnotation annotation = umlClass.getEAnnotation(SOURCE_CLASS_ANNOTATION);
        if (annotation != null && !annotation.getReferences().isEmpty()) {
            for (EObject reference : annotation.getReferences()) {
                if (!(reference instanceof Class)) continue;
                map.put((Classifier)umlClass, UMLUtil.getAllGeneralizations((Classifier)((Class)reference)));
            }
        }
    }

    protected Class getConsolSource(Class consolidatedClass) {
        EAnnotation annotation;
        if (consolidatedClass != null && (annotation = consolidatedClass.getEAnnotation(SOURCE_CLASS_ANNOTATION)) != null && !annotation.getReferences().isEmpty()) {
            for (EObject reference : annotation.getReferences()) {
                if (!(reference instanceof Class)) continue;
                return (Class)reference;
            }
        }
        return null;
    }

    protected Class findConsolSpecialization(Class umlClass) {
        Class specific = null;
        for (Classifier classifier : this.consolInheritance.keySet()) {
            if (!this.consolInheritance.get(classifier).contains(umlClass)) continue;
            return (Class)classifier;
        }
        return specific;
    }

    protected Class findSourceSpecialization(Class umlClass) {
        Class specific = null;
        for (Classifier classifier : this.sourceInheritance.keySet()) {
            if (!this.sourceInheritance.get(classifier).contains(umlClass)) continue;
            return (Class)classifier;
        }
        return specific;
    }

    protected int findProperty(List<Property> properties, String name) {
        if (name != null) {
            int i = 0;
            while (i < properties.size()) {
                if (name.equals(properties.get(i).getName())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

