/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.transform.core.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mdht.transform.core.ITransformContext;

public class TransformContext
implements ITransformContext {
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final Map<Object, Object> data = new HashMap<Object, Object>();
    private final ITransformContext delegate;

    public TransformContext() {
        this(null);
    }

    public TransformContext(ITransformContext delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean getBooleanOption(String name) {
        Boolean localValue = (Boolean)this.options.get(name);
        return localValue != null ? localValue.booleanValue() : this.delegatedGetBooleanOption(name);
    }

    protected boolean delegatedGetBooleanOption(String name) {
        return this.delegate == null ? false : this.delegate.getBooleanOption(name);
    }

    @Override
    public void setBooleanOption(String name, boolean value) {
        this.options.put(name, value);
    }

    @Override
    public String getStringOption(String name) {
        String localValue = (String)this.options.get(name);
        return localValue != null ? localValue : this.delegatedGetStringOption(name);
    }

    protected String delegatedGetStringOption(String name) {
        return this.delegate == null ? null : this.delegate.getStringOption(name);
    }

    @Override
    public void setStringOption(String name, String value) {
        if (value == null) {
            this.options.remove(name);
        } else {
            this.options.put(name, value);
        }
    }

    @Override
    public Object get(Object key) {
        Object localValue = this.data.get(key);
        return localValue != null ? localValue : this.delegatedGet(key);
    }

    protected Object delegatedGet(Object key) {
        return this.delegate == null ? null : this.delegate.get(key);
    }

    @Override
    public <T> T get(Class<? extends T> key) {
        Object localValue = this.data.get(key);
        if (localValue != null && !key.isInstance(localValue)) {
            throw new IllegalStateException(String.format("Invalid data for key of type %s: %s", key.getName(), localValue));
        }
        return (T)(localValue != null ? localValue : this.delegatedGet(key));
    }

    protected <T> T delegatedGet(Class<? extends T> key) {
        return this.delegate == null ? null : (T)this.delegate.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return value == null ? this.data.remove(key) : this.data.put(key, value);
    }

    @Override
    public <T> Object put(Class<? super T> key, T value) {
        return value == null ? this.data.remove(key) : this.data.put(key, value);
    }

    @Override
    public void dispose() {
        this.options.clear();
        this.data.clear();
    }
}

