/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.transform;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.transform.AbstractTransform;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class GenMethodHelper {
    public static final String LF = System.getProperty("line.separator");
    protected TransformerOptions transformerOptions;

    public GenMethodHelper(TransformerOptions options) {
        this.transformerOptions = options;
    }

    protected void addBodyAnnotation(Operation operation, String body) {
        EcoreUtil.setAnnotation((EModelElement)operation, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"body", (String)body);
    }

    protected void addBodyExpression(Operation operation, String language, String body) {
        Constraint bodyConstraint = operation.createBodyCondition("body");
        bodyConstraint.getConstrainedElements().add((Object)operation);
        OpaqueExpression bodyExpression = (OpaqueExpression)bodyConstraint.createSpecification(null, null, UMLPackage.eINSTANCE.getOpaqueExpression());
        bodyExpression.getLanguages().add((Object)language);
        bodyExpression.getBodies().add((Object)body);
    }

    public Operation genAddOperation(Classifier classifier, Property property, Classifier domainType) {
        Operation operation = null;
        String businessName = null;
        businessName = this.transformerOptions.isUseBusinessNames() ? AbstractTransform.normalizeCodeName((String)property.getLabel(false)) : AbstractTransform.normalizeCodeName((String)property.getName());
        String operationName = "add" + AbstractTransform.capitalize((String)businessName);
        Object[] paramNamesArray = new String[]{"value"};
        BasicEList.UnmodifiableEList parmNames = new BasicEList.UnmodifiableEList(1, paramNamesArray);
        Object[] paramTypesArray = new Type[]{domainType};
        BasicEList.UnmodifiableEList parmTypes = new BasicEList.UnmodifiableEList(1, paramTypesArray);
        if (classifier instanceof Interface) {
            operation = ((Interface)classifier).createOwnedOperation(operationName, (EList)parmNames, (EList)parmTypes, (Type)classifier);
        } else if (classifier instanceof Class) {
            operation = ((Class)classifier).createOwnedOperation(operationName, (EList)parmNames, (EList)parmTypes, (Type)classifier);
        }
        return operation;
    }

    public Operation genAssociationGetterOperation(Classifier classifier, Property sourceProperty, Classifier domainType) {
        Class sourceClass = sourceProperty.getClass_();
        Class targetClass = (Class)sourceProperty.getType();
        if (sourceClass == null || targetClass == null || sourceProperty == null) {
            return null;
        }
        String businessName = null;
        businessName = this.transformerOptions.isUseBusinessNames() ? AbstractTransform.normalizeCodeName((String)sourceProperty.getLabel(false)) : AbstractTransform.normalizeCodeName((String)sourceProperty.getName());
        Operation operation = null;
        String operationName = "get";
        operationName = String.valueOf(operationName) + (sourceProperty.getUpper() == 1 ? AbstractTransform.capitalize((String)businessName) : AbstractTransform.capitalize((String)AbstractTransform.pluralize((String)businessName)));
        if (classifier instanceof Class) {
            operation = ((Class)classifier).createOwnedOperation(operationName, null, null, (Type)domainType);
        } else if (classifier instanceof Interface) {
            operation = ((Interface)classifier).createOwnedOperation(operationName, null, null, (Type)domainType);
        } else {
            return null;
        }
        operation.setIsQuery(true);
        operation.setUpper(sourceProperty.getUpper());
        String domainTypeQName = domainType.getQualifiedName();
        Class cdaTargetClass = CDAModelUtil.getCDAClass((Classifier)targetClass);
        String cdaTargetName = cdaTargetClass == null ? targetClass.getName() : cdaTargetClass.getName();
        String cdaTargetLowerName = String.valueOf(cdaTargetName.substring(0, 1).toLowerCase()) + cdaTargetName.substring(1);
        String cdaTargetQName = cdaTargetClass == null ? targetClass.getQualifiedName() : cdaTargetClass.getQualifiedName();
        StringBuffer operationBody = new StringBuffer();
        if ((CDAModelUtil.isClinicalDocument((Type)sourceClass) || CDAModelUtil.isSection((Type)sourceClass)) && CDAModelUtil.isSection((Type)targetClass)) {
            operationBody.append("self.getAllSections()->select(");
            operationBody.append("section : cda::Section | not section.oclIsUndefined() and section.oclIsKindOf(" + domainTypeQName + "))");
        } else {
            operationBody.append("self.get" + AbstractTransform.pluralize((String)cdaTargetName) + "()->select(");
            operationBody.append(String.valueOf(cdaTargetLowerName) + " : " + cdaTargetQName + " | ");
            operationBody.append("not " + cdaTargetLowerName + ".oclIsUndefined() and ");
            operationBody.append(String.valueOf(cdaTargetLowerName) + ".oclIsKindOf(" + domainTypeQName + "))");
        }
        if (sourceProperty.getUpper() == 1) {
            operationBody.append("->asSequence()->any(true)");
        }
        operationBody.append(".oclAsType(" + domainTypeQName + ")");
        this.addBodyExpression(operation, "OCL", operationBody.toString());
        return operation;
    }

    public Operation genCreateOperation(Classifier classifier, Property property, Classifier domainType) {
        Operation operation = null;
        String businessName = null;
        businessName = this.transformerOptions.isUseBusinessNames() ? AbstractTransform.normalizeCodeName((String)property.getLabel(false)) : AbstractTransform.normalizeCodeName((String)property.getName());
        String operationVerb = property.getUpper() == 1 ? "with" : "add";
        String operationName = String.valueOf(operationVerb) + AbstractTransform.capitalize((String)businessName);
        StringBuffer operationBody = new StringBuffer();
        if (classifier instanceof Interface) {
            operation = ((Interface)classifier).createOwnedOperation(operationName, null, null, (Type)domainType);
        } else if (classifier instanceof Class) {
            operation = ((Class)classifier).createOwnedOperation(operationName, null, null, (Type)domainType);
        }
        if (operation != null) {
            Class sourceClass = property.getClass_();
            Class cdaTargetClass = CDAModelUtil.getCDAClass((Classifier)((Classifier)property.getType()));
            Property cdaProperty = CDAModelUtil.getCDAProperty((Property)property);
            if (CDAModelUtil.isDatatypeModel((Element)property.getType())) {
                operationBody.append("org.eclipse.emf.ecore.EPackage ePackage = org.eclipse.mdht.uml.hl7.datatypes.DatatypesPackage.eINSTANCE;" + LF);
                operationBody.append("org.eclipse.emf.ecore.EFactory eFactory = org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory.eINSTANCE;" + LF);
            } else if (CDAModelUtil.isCDAModel((Element)property.getType())) {
                operationBody.append("org.eclipse.emf.ecore.EPackage ePackage = org.eclipse.mdht.uml.cda.CDAPackage.eINSTANCE;" + LF);
                operationBody.append("org.eclipse.emf.ecore.EFactory eFactory = org.eclipse.mdht.uml.cda.CDAFactory.eINSTANCE;" + LF);
            } else {
                String nsURI = null;
                Package umlPackage = property.getType().getNearestPackage();
                Stereotype ePackage = umlPackage.getAppliedStereotype("Ecore::EPackage");
                if (ePackage != null) {
                    nsURI = (String)umlPackage.getValue(ePackage, "nsURI");
                } else {
                    Stereotype codegenSupport = CDAProfileUtil.getAppliedCDAStereotype((Element)umlPackage, (String)"CodegenSupport");
                    if (codegenSupport != null) {
                        nsURI = (String)umlPackage.getValue(codegenSupport, "nsURI");
                    }
                }
                if (nsURI == null) {
                    return null;
                }
                operationBody.append("org.eclipse.emf.ecore.EPackage ePackage = org.eclipse.emf.ecore.EPackage.Registry.INSTANCE.getEPackage(\"" + nsURI + "\");" + LF);
                operationBody.append("org.eclipse.emf.ecore.EFactory eFactory = org.eclipse.emf.ecore.EPackage.Registry.INSTANCE.getEFactory(\"" + nsURI + "\");" + LF);
            }
            operationBody.append("org.eclipse.emf.ecore.EClass eClass = (org.eclipse.emf.ecore.EClass) ePackage.getEClassifier(\"" + property.getType().getName() + "\");" + LF);
            operationBody.append("org.eclipse.emf.ecore.EObject eObject = eFactory.create(eClass);" + LF);
            if (property.getType() instanceof Class && CDAModelUtil.getTemplateId((Class)((Class)property.getType())) != null) {
                operationBody.append("try {" + LF);
                operationBody.append("\tjava.lang.reflect.Method initMethod = eObject.getClass().getMethod(\"init\", new java.lang.Class[0]);" + LF);
                operationBody.append("\tinitMethod.invoke(eObject, new Object[0]);" + LF);
                operationBody.append("} catch (Exception e) {" + LF);
                operationBody.append("\t// no init() method" + LF);
                operationBody.append("}" + LF);
            }
            if (this.transformerOptions.isGenerateDomainClasses() && cdaTargetClass != null && classifier.getNearestPackage() == domainType.getNearestPackage()) {
                operationBody.append("org.eclipse.emf.ecore.EPackage domainPackage = this.eClass().getEPackage();" + LF);
                operationBody.append("org.eclipse.emf.ecore.EFactory domainFactory = domainPackage.getEFactoryInstance();" + LF);
                operationBody.append("org.eclipse.emf.ecore.EClass domainEClass = (org.eclipse.emf.ecore.EClass) domainPackage.getEClassifier(\"" + domainType.getName() + "\");" + LF);
                operationBody.append("I" + domainType.getName() + " value = (" + "I" + domainType.getName() + ")domainFactory.create(domainEClass);" + LF);
                operationBody.append("value.setCDAType((org.eclipse.mdht.uml.cda." + cdaTargetClass.getName() + ")eObject);" + LF);
            } else {
                operationBody.append(String.valueOf(domainType.getName()) + " value = " + "(" + domainType.getName() + ") eObject;" + LF);
            }
            if (this.transformerOptions.isGenerateDomainClasses()) {
                operationBody.append("this.getCDAType().");
            }
            if ((CDAModelUtil.isClinicalDocument((Type)sourceClass) || CDAModelUtil.isSection((Type)sourceClass)) && CDAModelUtil.isSection((Type)cdaTargetClass)) {
                operationBody.append("addSection((org.eclipse.mdht.uml.cda.Section)eObject);" + LF);
                operationBody.append("return value;");
            } else if ((CDAModelUtil.isSection((Type)sourceClass) || CDAModelUtil.isClinicalStatement((Type)sourceClass)) && CDAModelUtil.isClinicalStatement((Type)cdaTargetClass)) {
                operationBody.append("add" + cdaTargetClass.getName() + "((org.eclipse.mdht.uml.cda." + cdaTargetClass.getName() + ")eObject);" + LF);
                operationBody.append("return value;");
            } else if (cdaProperty == null) {
                System.err.println("Unsupported facade property: " + property.getQualifiedName());
                operationBody = new StringBuffer();
            } else if (CDAModelUtil.isDatatypeModel((Element)property.getType())) {
                if (cdaProperty.getUpper() == 1) {
                    operationBody.append("set" + AbstractTransform.capitalize((String)cdaProperty.getName()) + "(value);" + LF);
                } else {
                    operationBody.append("get" + AbstractTransform.capitalize((String)AbstractTransform.pluralize((String)cdaProperty.getName())) + "().add(value);" + LF);
                }
                operationBody.append("return value;");
            } else if (CDAModelUtil.isCDAModel((Element)property.getType())) {
                if (cdaProperty.getUpper() == 1) {
                    operationBody.append("set" + AbstractTransform.capitalize((String)cdaProperty.getName()) + "(value);" + LF);
                } else {
                    operationBody.append("get" + AbstractTransform.capitalize((String)AbstractTransform.pluralize((String)cdaProperty.getName())) + "().add(value);" + LF);
                }
                operationBody.append("return value;");
            } else {
                if (property.getUpper() == 1) {
                    operationBody.append("set" + AbstractTransform.capitalize((String)property.getName()) + "(value);" + LF);
                } else {
                    operationBody.append("get" + AbstractTransform.capitalize((String)AbstractTransform.pluralize((String)property.getName())) + "().add(value);" + LF);
                }
                operationBody.append("return value;");
            }
            if (operationBody.length() > 0) {
                this.addBodyAnnotation(operation, operationBody.toString());
            }
        }
        return operation;
    }

    public Operation genPropertyGetterOperation(Classifier classifier, Property property, Classifier domainType) {
        if (property.getAssociation() != null) {
            return this.genAssociationGetterOperation(classifier, property, domainType);
        }
        Operation operation = null;
        String businessName = null;
        businessName = this.transformerOptions.isUseBusinessNames() ? AbstractTransform.normalizeCodeName((String)property.getLabel(false)) : AbstractTransform.normalizeCodeName((String)property.getName());
        String operationName = "get" + (property.getUpper() == 1 ? AbstractTransform.capitalize((String)businessName) : AbstractTransform.capitalize((String)AbstractTransform.pluralize((String)businessName)));
        StringBuffer operationBody = new StringBuffer();
        if (classifier instanceof Interface) {
            operation = ((Interface)classifier).createOwnedOperation(operationName, null, null, (Type)domainType);
        } else if (classifier instanceof Class) {
            operation = ((Class)classifier).createOwnedOperation(operationName, null, null, (Type)domainType);
        }
        if (operation != null) {
            operation.setIsQuery(true);
            operation.setUpper(property.getUpper());
            Property cdaProperty = CDAModelUtil.getCDAProperty((Property)property);
            if (cdaProperty != null) {
                operationBody.append("self." + cdaProperty.getName());
                operationBody.append(".oclAsType(" + domainType.getQualifiedName() + ")");
                this.addBodyExpression(operation, "OCL", operationBody.toString());
            }
        }
        return operation;
    }

    public Operation genSetOperation(Classifier classifier, Property property, Classifier domainType) {
        Operation operation = null;
        String businessName = null;
        businessName = this.transformerOptions.isUseBusinessNames() ? AbstractTransform.normalizeCodeName((String)property.getLabel(false)) : AbstractTransform.normalizeCodeName((String)property.getName());
        String operationVerb = property.getUpper() == 1 ? "set" : "add";
        String operationName = String.valueOf(operationVerb) + AbstractTransform.capitalize((String)businessName);
        StringBuffer operationBody = new StringBuffer();
        Object[] paramNamesArray = new String[]{"value"};
        BasicEList.UnmodifiableEList parmNames = new BasicEList.UnmodifiableEList(1, paramNamesArray);
        Object[] paramTypesArray = new Type[]{domainType};
        BasicEList.UnmodifiableEList parmTypes = new BasicEList.UnmodifiableEList(1, paramTypesArray);
        if (classifier instanceof Interface) {
            operation = ((Interface)classifier).createOwnedOperation(operationName, (EList)parmNames, (EList)parmTypes, (Type)classifier);
        } else if (classifier instanceof Class) {
            operation = ((Class)classifier).createOwnedOperation(operationName, (EList)parmNames, (EList)parmTypes, (Type)classifier);
        }
        Class sourceClass = property.getClass_();
        Class cdaTargetClass = CDAModelUtil.getCDAClass((Classifier)((Classifier)property.getType()));
        Property cdaProperty = CDAModelUtil.getCDAProperty((Property)property);
        if (this.transformerOptions.isGenerateDomainClasses()) {
            operationBody.append("this.getCDAType().");
        }
        if ((CDAModelUtil.isClinicalDocument((Type)sourceClass) || CDAModelUtil.isSection((Type)sourceClass)) && CDAModelUtil.isSection((Type)cdaTargetClass)) {
            operationBody.append("addSection((org.eclipse.mdht.uml.cda.Section)value);" + LF);
        } else if ((CDAModelUtil.isSection((Type)sourceClass) || CDAModelUtil.isClinicalStatement((Type)sourceClass)) && CDAModelUtil.isClinicalStatement((Type)cdaTargetClass)) {
            operationBody.append("add" + cdaTargetClass.getName() + "((org.eclipse.mdht.uml.cda." + cdaTargetClass.getName() + ")value);" + LF);
        } else if (cdaProperty == null) {
            System.err.println("Unsupported facade property: " + property.getQualifiedName());
            operationBody = new StringBuffer();
        } else if (CDAModelUtil.isDatatypeModel((Element)property.getType())) {
            if (cdaProperty.getUpper() == 1) {
                operationBody.append("set" + AbstractTransform.capitalize((String)cdaProperty.getName()) + "(value);" + LF);
            } else {
                operationBody.append("get" + AbstractTransform.capitalize((String)AbstractTransform.pluralize((String)cdaProperty.getName())) + "().add(value);" + LF);
            }
        } else if (CDAModelUtil.isCDAModel((Element)property.getType())) {
            if (cdaProperty.getUpper() == 1) {
                operationBody.append("set" + AbstractTransform.capitalize((String)cdaProperty.getName()) + "(value);" + LF);
            } else {
                operationBody.append("get" + AbstractTransform.capitalize((String)AbstractTransform.pluralize((String)cdaProperty.getName())) + "().add(value);" + LF);
            }
        } else if (property.getUpper() == 1) {
            operationBody.append("set" + AbstractTransform.capitalize((String)property.getName()) + "(value);" + LF);
        } else {
            operationBody.append("get" + AbstractTransform.capitalize((String)AbstractTransform.pluralize((String)property.getName())) + "().add(value);" + LF);
        }
        operationBody.append("return this;");
        if (operationBody.length() > 0) {
            this.addBodyAnnotation(operation, operationBody.toString());
        }
        return operation;
    }
}

