/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.dita.internal;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mdht.dita.ui.util.DitaUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.dita.DitaTransformerOptions;
import org.eclipse.mdht.uml.cda.dita.TransformClassContent;
import org.eclipse.mdht.uml.ui.properties.internal.sections.ConstraintEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class TextEditor
implements ConstraintEditor {
    private Text text;
    private Constraint constraint;
    private Button closeErrorTextButton;
    private Text errorText;
    private boolean checkDita = false;

    public void setText(Text text) {
        this.text = text;
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                TextEditor.this.checkDita = true;
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextEditor.this.handleChange();
            }
        });
    }

    public boolean isDitaEnabled() {
        Boolean ditaEnabled = false;
        try {
            Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)this.constraint, (String)"ConstraintValidation");
            ditaEnabled = (Boolean)this.constraint.getValue(stereotype, "enabledDitaForConstraints");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ditaEnabled;
    }

    public void setDitaEnabled(boolean isEnabled) {
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)this.constraint, (String)"ConstraintValidation");
        if (stereotype == null) {
            stereotype = CDAProfileUtil.applyCDAStereotype((Element)this.constraint, (String)"ConstraintValidation");
        }
        this.constraint.setValue(stereotype, "enabledDitaForConstraints", (Object)isEnabled);
    }

    private void handleChange() {
        if (this.checkDita && this.isDitaEnabled()) {
            this.runHandleChange();
        }
    }

    private void runHandleChange() {
        IPath tmpFile;
        block7: {
            this.checkDita = false;
            tmpFile = this.generateTempDita();
            boolean errorOccured = false;
            try {
                try {
                    DitaUtil.validate((IPath)tmpFile);
                }
                catch (Exception exception) {
                    this.showError(exception.toString());
                    errorOccured = true;
                    this.hideError(errorOccured);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.hideError(errorOccured);
                throw throwable;
            }
            this.hideError(errorOccured);
        }
        try {
            FileUtils.deleteDirectory((File)tmpFile.toFile().getParentFile());
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    private void hideError(boolean errorOccured) {
        if (!errorOccured) {
            this.errorText.setVisible(false);
            this.closeErrorTextButton.setVisible(false);
        }
    }

    private void showError(String error) {
        this.errorText.setText(error);
        this.errorText.setVisible(true);
        this.closeErrorTextButton.setVisible(true);
    }

    public void setConstraint(Constraint constraint) {
        boolean firstRun = this.constraint == null && constraint != null;
        this.constraint = constraint;
        this.checkDita = true;
        if (firstRun) {
            this.runHandleChange();
        } else {
            this.handleChange();
        }
    }

    private IPath generateTempDita() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String tmpName = this.constraint.getContext().getName() == null ? "tmp" : this.constraint.getContext().getName();
        IPath tmpFileInWorkspaceDir = workspace.getRoot().getLocation().append("tmp").append(tmpName).addFileExtension("dita");
        DitaTransformerOptions transformerOptions = new DitaTransformerOptions();
        transformerOptions.setExampleDepth(0);
        TransformClassContent transformer = new TransformClassContent(transformerOptions);
        if (!tmpFileInWorkspaceDir.toFile().getParentFile().exists()) {
            tmpFileInWorkspaceDir.toFile().getParentFile().mkdirs();
        }
        transformer.writeClassToFile((Class)this.constraint.getContext(), tmpFileInWorkspaceDir);
        return tmpFileInWorkspaceDir;
    }

    public void setErrorText(Text errorText) {
        this.errorText = errorText;
    }

    public void setCloseErrorText(Button closeErrorTextButton) {
        this.closeErrorTextButton = closeErrorTextButton;
    }
}

