/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.edit.provider.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.mdht.uml.edit.internal.Logger;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;

public class NamedElementOperations {
    public static final String nameFeature = UMLPackage.eINSTANCE.getNamedElement_Name().getName();
    public static final String visibilityFeature = UMLPackage.eINSTANCE.getNamedElement_Visibility().getName();

    public static void modify(Object element, final String property, final Object value) {
        final NamedElement namedElement = (NamedElement)element;
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)namedElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    if (nameFeature.equals(property)) {
                        this.setLabel("Set Name");
                        namedElement.setName(value.toString());
                    } else if (visibilityFeature.equals(property) && value instanceof Integer) {
                        this.setLabel("Set Visibility");
                        namedElement.setVisibility(VisibilityKind.get((int)((Integer)value)));
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ee) {
                Logger.logException(ee);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

