/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.profile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EntryKind implements Enumerator
{
    COMP(0, "COMP", "COMP"),
    DRIV(1, "DRIV", "DRIV");

    public static final int COMP_VALUE = 0;
    public static final int DRIV_VALUE = 1;
    private static final EntryKind[] VALUES_ARRAY;
    public static final List<EntryKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EntryKind[]{COMP, DRIV};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EntryKind get(int value) {
        switch (value) {
            case 0: {
                return COMP;
            }
            case 1: {
                return DRIV;
            }
        }
        return null;
    }

    public static EntryKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntryKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntryKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntryKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private EntryKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

