/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContextControl implements Enumerator
{
    AN(0, "AN", "AN"),
    AP(1, "AP", "AP"),
    ON(2, "ON", "ON"),
    OP(3, "OP", "OP");

    public static final int AN_VALUE = 0;
    public static final int AP_VALUE = 1;
    public static final int ON_VALUE = 2;
    public static final int OP_VALUE = 3;
    private static final ContextControl[] VALUES_ARRAY;
    public static final List<ContextControl> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContextControl[]{AN, AP, ON, OP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContextControl get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContextControl result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContextControl getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContextControl result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContextControl get(int value) {
        switch (value) {
            case 0: {
                return AN;
            }
            case 1: {
                return AP;
            }
            case 2: {
                return ON;
            }
            case 3: {
                return OP;
            }
        }
        return null;
    }

    private ContextControl(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

