/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mdht.uml.cda.ui.util.CDAProjectUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.uml2.uml.Type;

public class DocumentClassDialog {
    public static String CANCELLED = "CANCELLED";
    boolean workspaceMode = true;
    private String documentClassQName = null;
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){
        private List<Object> contents;

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.contents != null && this.contents == inputElement) {
                return this.contents.toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.contents = newInput instanceof List ? (List)newInput : null;
        }
    };
    private ILabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            return element.toString();
        }
    };

    public boolean isWorkspaceMode() {
        return this.workspaceMode;
    }

    public String getDocumentClassQName() {
        return this.documentClassQName;
    }

    public String selectDocumentClass() {
        CDAProjectUtil projectUtil = new CDAProjectUtil();
        projectUtil.loadCDAModelsfromWorkspace();
        Map<String, Type> cdaDocuments = projectUtil.getCDADocuments();
        if (cdaDocuments.keySet().isEmpty()) {
            projectUtil.loadCDAModelsfromPlugins();
            cdaDocuments = projectUtil.getCDADocuments();
            if (cdaDocuments.keySet().isEmpty()) {
                return null;
            }
            this.workspaceMode = false;
        }
        final ArrayList<String> qnames = new ArrayList<String>(cdaDocuments.keySet());
        Collections.sort(qnames);
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ListDialog dialog = new ListDialog(activeShell);
                dialog.setLabelProvider(DocumentClassDialog.this.labelProvider);
                dialog.setContentProvider(DocumentClassDialog.this.contentProvider);
                dialog.setInput((Object)qnames);
                dialog.setTitle("CDA Document Types");
                dialog.setMessage("Select document type for validation or just Select OK to continue;  \nHit Cancel to Skip CDA Validation");
                dialog.open();
                Object[] results = dialog.getResult();
                if (dialog.getReturnCode() == 1) {
                    DocumentClassDialog.this.documentClassQName = CANCELLED;
                } else if (results != null && results.length > 0) {
                    DocumentClassDialog.this.documentClassQName = results[0].toString();
                }
            }
        });
        return this.documentClassQName;
    }
}

