/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.handlers;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mdht.uml.cda.core.profile.LogicalConstraint;
import org.eclipse.mdht.uml.cda.core.profile.LogicalOperator;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.common.ui.dialogs.SubclassEditorDialog;
import org.eclipse.mdht.uml.common.ui.dialogs.SubclassEditorViewContentProvider;
import org.eclipse.mdht.uml.common.ui.dialogs.SubclassEditorViewLabelProvider;
import org.eclipse.mdht.uml.common.ui.dialogs.SubclassHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class LogicalSubclassHandler
extends SubclassHandler {
    LogicalOperator logicalOperator;

    protected SubclassEditorDialog createSubclassDialog() {
        SubclassEditorDialog subclassDialog = new SubclassEditorDialog(this.shell, this.labelProvider, this.contentProvider, this.getSubclass());
        subclassDialog.setTitle("Create Logical Constraint " + this.logicalOperator.getLiteral());
        return subclassDialog;
    }

    public LogicalSubclassHandler(Shell shell, Class subclass, SubclassEditorViewContentProvider subclassEditorViewContentProvider, SubclassEditorViewLabelProvider subclassEditorViewLabelProvider, LogicalOperator logicalOperator) {
        super(shell, subclass);
        this.logicalOperator = logicalOperator;
    }

    public int openSubclassDialog() {
        this.subclassDialog = this.createSubclassDialog();
        int resultStatus = this.subclassDialog.open();
        if (this.subclassDialog.getReturnCode() == 0) {
            Object[] selectionArray = this.subclassDialog.getResult();
            this.createConstraint(selectionArray, this.getSubclass());
        }
        return resultStatus;
    }

    private void createConstraint(Object[] selectionArray, Class subclass) {
        if (selectionArray != null) {
            Constraint logicalConstraint = UMLFactory.eINSTANCE.createConstraint();
            String constraintName = "LogicalConstraint" + this.logicalOperator.getLiteral();
            int a = 0;
            while (subclass.getOwnedRule(String.valueOf(constraintName) + (a == 0 ? "" : Integer.valueOf(a))) != null) {
                ++a;
            }
            logicalConstraint.setName(String.valueOf(constraintName) + (a == 0 ? "" : Integer.valueOf(a)));
            ArrayList<Property> selectedAttributes = new ArrayList<Property>();
            int i = 0;
            while (i < selectionArray.length) {
                if (selectionArray[i] instanceof Property) {
                    selectedAttributes.add((Property)selectionArray[i]);
                }
                ++i;
            }
            StringBuffer sb = new StringBuffer();
            for (Property p : selectedAttributes) {
                logicalConstraint.getConstrainedElements().add((Object)p);
                if (sb.length() > 0) {
                    sb.append(" " + (this.logicalOperator.equals((Object)LogicalOperator.IFTHEN) ? " THEN " : this.logicalOperator.getLiteral()) + " ");
                }
                if (sb.length() == 0 && this.logicalOperator.equals((Object)LogicalOperator.IFTHEN)) {
                    sb.append(" IF ");
                }
                sb.append(p.getName());
            }
            OpaqueExpression opaqueExpression = UMLFactory.eINSTANCE.createOpaqueExpression();
            opaqueExpression.getLanguages().add((Object)"Analysis");
            opaqueExpression.getBodies().add((Object)("Logical Constraint of " + sb.toString()));
            logicalConstraint.setSpecification((ValueSpecification)opaqueExpression);
            subclass.getOwnedRules().add((Object)logicalConstraint);
            CDAProfileUtil.applyCDAStereotype((Element)logicalConstraint, (String)"LogicalConstraint");
            for (EObject eObject : logicalConstraint.getStereotypeApplications()) {
                if (!(eObject instanceof LogicalConstraint)) continue;
                ((LogicalConstraint)eObject).setOperation(this.logicalOperator);
            }
        }
    }

    public LogicalSubclassHandler(Shell shell, Class subclass, SubclassEditorViewContentProvider contentProvider, SubclassEditorViewLabelProvider labelProvider) {
        super(shell, subclass, contentProvider, labelProvider);
    }
}

