/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.actions;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.acceleo.engine.utils.AcceleoLaunchingUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.ui.acceleo.main.Generate;
import org.eclipse.mdht.uml.common.UmlPlugin;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.osgi.framework.Bundle;

public class GenerateAll {
    private URI modelURI;
    private IContainer targetFolder;
    List<? extends Object> arguments;

    protected void collapseFragments(Resource umlResource) {
        EcoreUtil.resolveAll((ResourceSet)umlResource.getResourceSet());
        for (Resource controlledResource : UMLUtil.getControlledResources((Resource)umlResource)) {
            EList umlResourceContents = umlResource.getContents();
            ListIterator contents = controlledResource.getContents().listIterator();
            while (contents.hasNext()) {
                EObject next = (EObject)contents.next();
                contents.remove();
                if (next.eContainer() != null) continue;
                umlResourceContents.add((Object)next);
            }
        }
    }

    public GenerateAll(URI modelURI, IContainer targetFolder, List<? extends Object> arguments) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        UmlPlugin.computeModelPathMapExtensions();
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        Package pkg = (Package)UML2Util.load((ResourceSet)resourceSet, (URI)modelURI, (EClass)UMLPackage.Literals.PACKAGE);
        this.collapseFragments(pkg.eResource());
        URI tempModelURI = pkg.eResource().getURI();
        tempModelURI = tempModelURI.trimFileExtension();
        tempModelURI = tempModelURI.trimSegments(1).appendSegment(String.valueOf(tempModelURI.lastSegment()) + "_TEMP");
        String fileExtension = pkg.eResource().getURI().fileExtension();
        if (!fileExtension.equals(tempModelURI.fileExtension())) {
            tempModelURI = tempModelURI.appendFileExtension(fileExtension);
        }
        try {
            HashMap saveOptions = new HashMap();
            pkg.eResource().setURI(tempModelURI);
            pkg.eResource().save(saveOptions);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.modelURI = tempModelURI;
        this.targetFolder = targetFolder;
        this.arguments = arguments;
    }

    public void doGenerate(IProgressMonitor monitor) throws IOException {
        if (!this.targetFolder.getLocation().toFile().exists()) {
            this.targetFolder.getLocation().toFile().mkdirs();
        }
        monitor.subTask("Loading...");
        Generate gen0 = new Generate(this.modelURI, this.targetFolder.getLocation().toFile(), this.arguments);
        monitor.worked(1);
        String generationID = AcceleoLaunchingUtil.computeUIProjectID((String)"org.eclipse.acceleo.module.sampleA", (String)"org.eclipse.acceleo.module.sampleA.main.Generate", (String)this.modelURI.toString(), (String)this.targetFolder.getFullPath().toString(), new ArrayList());
        gen0.setGenerationID(generationID);
        gen0.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
    }

    private URI getTemplateURI(String bundleID, IPath relativePath) throws IOException {
        Enumeration entries;
        Bundle bundle = Platform.getBundle((String)bundleID);
        if (bundle == null) {
            return URI.createPlatformResourceURI((String)new Path(bundleID).append(relativePath).toString(), (boolean)false);
        }
        URL url = bundle.getEntry(relativePath.toString());
        if (url == null && relativePath.segmentCount() > 1 && (entries = bundle.findEntries("/", "*.emtl", true)) != null) {
            String[] segmentsRelativePath = relativePath.segments();
            while (url == null && entries.hasMoreElements()) {
                String[] segmentsPath;
                URL entry = (URL)entries.nextElement();
                Path path = new Path(entry.getPath());
                if (path.segmentCount() > relativePath.segmentCount()) {
                    path = path.removeFirstSegments(path.segmentCount() - relativePath.segmentCount());
                }
                boolean equals = (segmentsPath = path.segments()).length == segmentsRelativePath.length;
                int i = 0;
                while (equals && i < segmentsPath.length) {
                    equals = segmentsPath[i].equals(segmentsRelativePath[i]);
                    ++i;
                }
                if (!equals) continue;
                url = bundle.getEntry(entry.getPath());
            }
        }
        URI result = url != null ? URI.createPlatformPluginURI((String)new Path(bundleID).append((IPath)new Path(url.getPath())).toString(), (boolean)false) : URI.createPlatformResourceURI((String)new Path(bundleID).append(relativePath).toString(), (boolean)false);
        return result;
    }
}

