/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

public class MonotonicBlockPackedReader
extends LongValues
implements Accountable {
    private static final int BLOCK_SIZE = 8;
    private static final int BLOCK_BITS = 3;
    private static final int MOD_MASK = 7;
    final int blockShift;
    final int blockMask;
    final long valueCount;
    final long[] minValues;
    final float[] averages;
    final LongValues[] subReaders;
    final long sumBPV;
    final long totalByteCount;

    static long expected(long origin, float average, int index) {
        return origin + (long)(average * (float)index);
    }

    public static MonotonicBlockPackedReader of(IndexInput in, int packedIntsVersion, int blockSize, long valueCount) throws IOException {
        return new MonotonicBlockPackedReader(in, packedIntsVersion, blockSize, valueCount);
    }

    private MonotonicBlockPackedReader(IndexInput in, int packedIntsVersion, int blockSize, long valueCount) throws IOException {
        this.valueCount = valueCount;
        this.blockShift = PackedInts.checkBlockSize(blockSize, 64, 0x8000000);
        this.blockMask = blockSize - 1;
        int numBlocks = PackedInts.numBlocks(valueCount, blockSize);
        this.minValues = new long[numBlocks];
        this.averages = new float[numBlocks];
        this.subReaders = new LongValues[numBlocks];
        long sumBPV = 0L;
        long totalByteCount = 0L;
        for (int i = 0; i < numBlocks; ++i) {
            this.minValues[i] = in.readZLong();
            this.averages[i] = Float.intBitsToFloat(in.readInt());
            final int bitsPerValue = in.readVInt();
            sumBPV += (long)bitsPerValue;
            if (bitsPerValue > 64) {
                throw new IOException("Corrupted");
            }
            if (bitsPerValue == 0) {
                this.subReaders[i] = LongValues.ZEROES;
                continue;
            }
            int size = (int)Math.min((long)blockSize, valueCount - (long)i * (long)blockSize);
            int byteCount = Math.toIntExact(PackedInts.Format.PACKED.byteCount(packedIntsVersion, size, bitsPerValue));
            totalByteCount += (long)byteCount;
            final byte[] blocks = new byte[byteCount];
            in.readBytes(blocks, 0, byteCount);
            final long maskRight = (1L << bitsPerValue) - 1L;
            final int bpvMinusBlockSize = bitsPerValue - 8;
            this.subReaders[i] = new LongValues(){

                @Override
                public long get(long index) {
                    long majorBitPos = index * (long)bitsPerValue;
                    int blockOffset = (int)(majorBitPos >>> 3);
                    long endBits = (majorBitPos & 7L) + (long)bpvMinusBlockSize;
                    if (endBits <= 0L) {
                        return ((long)blocks[blockOffset] & 0xFFL) >>> (int)(-endBits) & maskRight;
                    }
                    long value = ((long)blocks[blockOffset++] & 0xFFL) << (int)endBits & maskRight;
                    while (endBits > 8L) {
                        value |= ((long)blocks[blockOffset++] & 0xFFL) << (int)(endBits -= 8L);
                    }
                    return value | ((long)blocks[blockOffset] & 0xFFL) >>> (int)(8L - endBits);
                }
            };
        }
        this.sumBPV = sumBPV;
        this.totalByteCount = totalByteCount;
    }

    @Override
    public long get(long index) {
        assert (index >= 0L && index < this.valueCount);
        int block = (int)(index >>> this.blockShift);
        int idx = (int)(index & (long)this.blockMask);
        return MonotonicBlockPackedReader.expected(this.minValues[block], this.averages[block], idx) + this.subReaders[block].get(idx);
    }

    public long size() {
        return this.valueCount;
    }

    @Override
    public long ramBytesUsed() {
        long sizeInBytes = 0L;
        sizeInBytes += RamUsageEstimator.sizeOf(this.minValues);
        sizeInBytes += RamUsageEstimator.sizeOf(this.averages);
        return sizeInBytes += this.totalByteCount;
    }

    public String toString() {
        long avgBPV = this.subReaders.length == 0 ? 0L : this.sumBPV / (long)this.subReaders.length;
        return this.getClass().getSimpleName() + "(blocksize=" + (1 << this.blockShift) + ",size=" + this.valueCount + ",avgBPV=" + avgBPV + ")";
    }
}

