/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.dialogs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.forms.widgets.ScrolledFormText;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetCollectionElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetCollectionSorter;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.state.DefaultStateManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetView;
import org.eclipse.ui.internal.cheatsheets.views.ViewUtilities;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class CheatSheetCategoryBasedSelectionDialog
extends TrayDialog
implements ISelectionChangedListener {
    private static final String CHEAT_SHEET_SELECTION_HELP_ID = "org.eclipse.ui.cheatsheets.cheatSheetSelection";
    private IDialogSettings settings;
    private final CheatSheetCollectionElement cheatsheetCategories;
    private CheatSheetElement currentSelection;
    private TreeViewer treeViewer;
    private ScrolledFormText desc;
    private Button showAllButton;
    private Button selectRegisteredRadio;
    private Button selectFileRadio;
    private Button selectUrlRadio;
    private Combo selectFileCombo;
    private Combo selectUrlCombo;
    private final ActivityViewerFilter activityViewerFilter = new ActivityViewerFilter();
    private boolean okButtonState;
    private static final String DIALOG_SETTINGS_SECTION = "CheatSheetCategoryBasedSelectionDialog";
    private static final String STORE_EXPANDED_CATEGORIES_ID = "CheatSheetCategoryBasedSelectionDialog.STORE_EXPANDED_CATEGORIES_ID";
    private static final String STORE_SELECTED_CHEATSHEET_ID = "CheatSheetCategoryBasedSelectionDialog.STORE_SELECTED_CHEATSHEET_ID";
    private static final String STORE_RADIO_SETTING = "CheatSheetCategoryBasedSelectionDialog.STORE_RADIO_SELECTION";
    private static final String STORE_CHEATSHEET_FILENAME = "CheatSheetCategoryBasedSelectionDialog.STORE_CHEATSHEET_FILENAME";
    private static final String STORE_CHEATSHEET_URL = "CheatSheetCategoryBasedSelectionDialog.STORE_CHEATSHEET_URL";
    private static final String STORE_URL_MRU = "CheatSheetCategoryBasedSelectionDialog.STORE_URL_MRU";
    private static final String STORE_FILE_MRU = "CheatSheetCategoryBasedSelectionDialog.STORE_FILE_MRU";
    private static final int MOST_RECENT_LENGTH = 3;
    private static final int RADIO_REGISTERED = 1;
    private static final int RADIO_FILE = 2;
    private static final int RADIO_URL = 3;
    private Button browseFileButton;
    private final String title;
    private IStatus status = Status.OK_STATUS;
    List<String> mostRecentFiles = new ArrayList<String>();
    List<String> mostRecentUrls = new ArrayList<String>();

    public CheatSheetCategoryBasedSelectionDialog(Shell shell, CheatSheetCollectionElement cheatsheetCategories) {
        super(shell);
        this.cheatsheetCategories = cheatsheetCategories;
        this.title = Messages.CHEAT_SHEET_SELECTION_DIALOG_TITLE;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title != null) {
            newShell.setText(this.title);
        }
        newShell.setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_VIEW"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.enableOKButton(this.okButtonState);
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        IDialogSettings workbenchSettings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(CheatSheetCategoryBasedSelectionDialog.class)).getDialogSettings();
        IDialogSettings dialogSettings = workbenchSettings.getSection(DIALOG_SETTINGS_SECTION);
        if (dialogSettings == null) {
            dialogSettings = workbenchSettings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        this.setDialogSettings(dialogSettings);
        Composite outerContainer = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CHEAT_SHEET_SELECTION_HELP_ID);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        outerContainer.setLayout((Layout)gridLayout);
        outerContainer.setLayoutData((Object)new GridData(1808));
        this.createMessageArea(outerContainer);
        this.selectRegisteredRadio = new Button(outerContainer, 16);
        this.selectRegisteredRadio.setText(Messages.SELECTION_DIALOG_OPEN_REGISTERED);
        SashForm sform = new SashForm(outerContainer, 512);
        GridData data = new GridData(1808);
        data.heightHint = 300;
        sform.setLayoutData((Object)data);
        this.treeViewer = new TreeViewer((Composite)sform, 2820);
        this.treeViewer.getTree().setLayoutData((Object)data);
        this.treeViewer.setContentProvider(this.getCheatSheetProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CheatsheetLabelProvider());
        this.treeViewer.setComparator((ViewerComparator)CheatSheetCollectionSorter.INSTANCE);
        this.treeViewer.addFilter((ViewerFilter)this.activityViewerFilter);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.setInput((Object)this.cheatsheetCategories);
        this.desc = new ScrolledFormText((Composite)sform, true);
        this.desc.setEnabled(false);
        sform.setWeights(new int[]{10, 2});
        if (this.activityViewerFilter.getHasEncounteredFilteredItem()) {
            this.createShowAllButton(outerContainer);
        }
        this.treeViewer.addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object obj = selection.getFirstElement();
            if (obj instanceof CheatSheetCollectionElement) {
                boolean state = this.treeViewer.getExpandedState(obj);
                this.treeViewer.setExpandedState(obj, !state);
            } else {
                this.okPressed();
            }
        });
        this.selectFileRadio = new Button(outerContainer, 16);
        this.selectFileRadio.setText(Messages.SELECTION_DIALOG_OPEN_FROM_FILE);
        Composite selectFileComposite = new Composite(outerContainer, 0);
        GridLayout selectFileLayout = new GridLayout();
        selectFileLayout.marginWidth = 0;
        selectFileLayout.marginHeight = 0;
        selectFileLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        selectFileLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        selectFileLayout.numColumns = 2;
        selectFileComposite.setLayout((Layout)selectFileLayout);
        GridData sfCompositeData = new GridData(768);
        sfCompositeData.widthHint = 300;
        selectFileComposite.setLayoutData((Object)sfCompositeData);
        this.selectFileCombo = new Combo(selectFileComposite, 2048);
        GridData sfTextData = new GridData(768);
        this.selectFileCombo.setLayoutData((Object)sfTextData);
        this.browseFileButton = new Button(selectFileComposite, 0);
        this.browseFileButton.setText(Messages.SELECTION_DIALOG_FILEPICKER_BROWSE);
        this.setButtonLayoutData(this.browseFileButton);
        this.selectUrlRadio = new Button(outerContainer, 16);
        this.selectUrlRadio.setText(Messages.SELECTION_DIALOG_OPEN_FROM_URL);
        this.selectUrlCombo = new Combo(outerContainer, 2048);
        GridData suTextData = new GridData(768);
        this.selectUrlCombo.setLayoutData((Object)suTextData);
        this.restoreWidgetValues();
        this.restoreFileSettings();
        if (!this.treeViewer.getSelection().isEmpty()) {
            this.treeViewer.getTree().setFocus();
        }
        Dialog.applyDialogFont((Control)outerContainer);
        this.selectFileCombo.addModifyListener((ModifyListener)new FileAndUrlListener());
        this.browseFileButton.addSelectionListener((SelectionListener)new BrowseListener());
        this.selectRegisteredRadio.addSelectionListener((SelectionListener)new RadioSelectionListener());
        this.selectUrlRadio.addSelectionListener((SelectionListener)new RadioSelectionListener());
        this.selectUrlCombo.addModifyListener((ModifyListener)new FileAndUrlListener());
        this.checkRadioButtons();
        return outerContainer;
    }

    private void checkRadioButtons() {
        this.selectFileCombo.setEnabled(this.selectFileRadio.getSelection());
        this.browseFileButton.setEnabled(this.selectFileRadio.getSelection());
        if (this.showAllButton != null) {
            this.showAllButton.setEnabled(this.selectRegisteredRadio.getSelection());
        }
        this.treeViewer.getTree().setEnabled(this.selectRegisteredRadio.getSelection());
        this.selectUrlCombo.setEnabled(this.selectUrlRadio.getSelection());
        this.setOkButton();
    }

    private void createShowAllButton(Composite parent) {
        this.showAllButton = new Button(parent, 32);
        this.showAllButton.setText(Messages.CheatSheetCategoryBasedSelectionDialog_showAll);
        this.showAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CheatSheetCategoryBasedSelectionDialog.this.showAllButton.getSelection()) {
                    CheatSheetCategoryBasedSelectionDialog.this.treeViewer.resetFilters();
                } else {
                    CheatSheetCategoryBasedSelectionDialog.this.treeViewer.addFilter((ViewerFilter)CheatSheetCategoryBasedSelectionDialog.this.activityViewerFilter);
                }
            }
        });
    }

    private void enableOKButton(boolean value) {
        Button button = this.getButton(0);
        this.okButtonState = value;
        if (button != null) {
            button.setEnabled(value);
        }
    }

    protected CheatSheetCollectionElement expandPreviouslyExpandedCategories() {
        String[] expandedCategoryPaths = this.settings.getArray(STORE_EXPANDED_CATEGORIES_ID);
        ArrayList<CheatSheetCollectionElement> categoriesToExpand = new ArrayList<CheatSheetCollectionElement>(expandedCategoryPaths.length);
        String[] stringArray = expandedCategoryPaths;
        int n = expandedCategoryPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String expandedCategoryPath = stringArray[n2];
            CheatSheetCollectionElement category = this.cheatsheetCategories.findChildCollection(IPath.fromOSString((String)expandedCategoryPath));
            if (category != null) {
                categoriesToExpand.add(category);
            }
            ++n2;
        }
        if (!categoriesToExpand.isEmpty()) {
            this.treeViewer.setExpandedElements(categoriesToExpand.toArray());
        }
        return categoriesToExpand.isEmpty() ? null : (CheatSheetCollectionElement)((Object)categoriesToExpand.get(categoriesToExpand.size() - 1));
    }

    protected IContentProvider getCheatSheetProvider() {
        return new BaseWorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                Object[] subCategories;
                Object[] cheatsheets;
                if (o instanceof CheatSheetCollectionElement) {
                    cheatsheets = ((CheatSheetCollectionElement)((Object)o)).getCheatSheets();
                    subCategories = ((CheatSheetCollectionElement)((Object)o)).getChildren();
                } else {
                    cheatsheets = new Object[]{};
                    subCategories = new Object[]{};
                }
                if (cheatsheets.length == 0) {
                    return subCategories;
                }
                if (subCategories.length == 0) {
                    return cheatsheets;
                }
                Object[] result = new Object[cheatsheets.length + subCategories.length];
                System.arraycopy(subCategories, 0, result, 0, subCategories.length);
                System.arraycopy(cheatsheets, 0, result, subCategories.length, cheatsheets.length);
                return result;
            }
        };
    }

    protected Object getSingleSelection(IStructuredSelection selection) {
        return selection.size() == 1 ? selection.getFirstElement() : null;
    }

    public void selectionChanged(SelectionChangedEvent selectionEvent) {
        Object obj = this.getSingleSelection(selectionEvent.getStructuredSelection());
        this.currentSelection = obj instanceof CheatSheetCollectionElement ? null : (CheatSheetElement)((Object)obj);
        String description = this.currentSelection != null ? this.currentSelection.getDescription() : "";
        this.desc.getFormText().setText(description, false, false);
        this.desc.reflow(true);
        this.setOkButton();
    }

    private void setOkButton() {
        if (this.selectRegisteredRadio.getSelection()) {
            this.enableOKButton(this.currentSelection != null);
        } else if (this.selectFileRadio.getSelection()) {
            this.enableOKButton(this.selectFileCombo.getText().length() > 0);
        } else {
            this.enableOKButton(this.selectUrlCombo.getText().length() > 0);
        }
    }

    protected void okPressed() {
        this.getShell().setVisible(false);
        if (this.selectFileRadio.getSelection()) {
            this.setResultFromFile();
        } else if (this.selectRegisteredRadio.getSelection()) {
            this.setResultFromTree();
        } else {
            this.setResultFromUrl();
        }
        this.saveWidgetValues();
        super.okPressed();
    }

    private void setResultFromTree() {
        ITriggerPoint triggerPoint;
        if (this.currentSelection != null && WorkbenchActivityHelper.allowUseOf((ITriggerPoint)(triggerPoint = PlatformUI.getWorkbench().getActivitySupport().getTriggerPointManager().getTriggerPoint("org.eclipse.ui.cheatsheetSelectionDialog")), (Object)((Object)this.currentSelection))) {
            OpenCheatSheetAction openCheatSheetAction = new OpenCheatSheetAction(this.currentSelection.getID());
            openCheatSheetAction.setTargetShell(this.getParentShell());
            openCheatSheetAction.run();
        }
    }

    private void setResultFromFile() {
        IPath filePath = IPath.fromOSString((String)this.selectFileCombo.getText());
        String id = filePath.lastSegment();
        int extensionIndex = id.indexOf(46);
        if (extensionIndex > 0) {
            id = id.substring(0, extensionIndex);
        }
        URL url = null;
        boolean opened = false;
        try {
            File contentFile = new File(this.selectFileCombo.getText());
            url = contentFile.toURI().toURL();
            OpenCheatSheetAction openCheatSheetAction = new OpenCheatSheetAction(id, id, url);
            openCheatSheetAction.setTargetShell(this.getParentShell());
            openCheatSheetAction.run();
            opened = true;
        }
        catch (MalformedURLException malformedURLException) {
            opened = false;
        }
        if (!opened) {
            String message = NLS.bind((String)Messages.ERROR_OPENING_FILE, (Object[])new Object[]{this.selectFileCombo.getText()});
            this.status = new Status(4, "org.eclipse.ui.cheatsheets", 1001, message, null);
            CheatSheetView view = ViewUtilities.showCheatSheetView();
            view.getCheatSheetViewer().showError(message);
        }
    }

    private void setResultFromUrl() {
        int extensionIndex;
        IPath filePath = IPath.fromOSString((String)this.selectUrlCombo.getText());
        String id = filePath.lastSegment();
        if (id == null) {
            id = "";
        }
        if ((extensionIndex = id.indexOf(46)) > 0) {
            id = id.substring(0, extensionIndex);
        }
        URL url = null;
        boolean opened = false;
        CheatSheetView view = ViewUtilities.showCheatSheetView();
        if (view == null) {
            return;
        }
        try {
            url = new URL(this.selectUrlCombo.getText());
            view.getCheatSheetViewer().setInput(id, id, url, new DefaultStateManager(), true);
            opened = true;
        }
        catch (MalformedURLException malformedURLException) {
            opened = false;
        }
        if (!opened) {
            String message = NLS.bind((String)Messages.ERROR_OPENING_FILE, (Object[])new Object[]{this.selectUrlCombo.getText()});
            this.status = new Status(4, "org.eclipse.ui.cheatsheets", 1001, message, null);
            view.getCheatSheetViewer().showError(message);
        }
    }

    protected void restoreWidgetValues() {
        String[] expandedCategoryPaths = this.settings.getArray(STORE_EXPANDED_CATEGORIES_ID);
        if (expandedCategoryPaths == null) {
            return;
        }
        CheatSheetCollectionElement category = this.expandPreviouslyExpandedCategories();
        if (category != null) {
            this.selectPreviouslySelectedCheatSheet(category);
        }
    }

    private void restoreFileSettings() {
        String url;
        int radioSetting = 1;
        try {
            radioSetting = this.settings.getInt(STORE_RADIO_SETTING);
        }
        catch (NumberFormatException numberFormatException) {}
        this.selectFileRadio.setSelection(radioSetting == 2);
        this.selectRegisteredRadio.setSelection(radioSetting == 1);
        this.selectUrlRadio.setSelection(radioSetting == 3);
        String fileName = this.settings.get(STORE_CHEATSHEET_FILENAME);
        if (fileName != null) {
            this.selectFileCombo.setText(fileName);
        }
        if ((url = this.settings.get(STORE_CHEATSHEET_URL)) != null) {
            this.selectUrlCombo.setText(url);
        }
        this.loadMRU(this.mostRecentUrls, STORE_URL_MRU, this.selectUrlCombo);
        this.loadMRU(this.mostRecentFiles, STORE_FILE_MRU, this.selectFileCombo);
    }

    private void loadMRU(List<String> mostRecentList, String key, Combo combo) {
        int i = 0;
        while (i < 3) {
            String name = this.settings.get(key + i);
            if (name != null) {
                mostRecentList.add(name);
                combo.add(name);
            }
            ++i;
        }
    }

    private void saveMRU(List<String> mostRecentList, String key, String selection) {
        if (selection.length() > 0 && !mostRecentList.contains(selection)) {
            mostRecentList.add(0, selection);
        }
        int i = 0;
        while (i < 3 && i < mostRecentList.size()) {
            String name = mostRecentList.get(i);
            if (name.length() > 0) {
                this.settings.put(key + i, name);
            }
            ++i;
        }
    }

    public void saveWidgetValues() {
        this.storeExpandedCategories();
        this.storeSelectedCheatSheet();
        this.storeFileSettings();
    }

    protected void selectPreviouslySelectedCheatSheet(CheatSheetCollectionElement category) {
        String cheatsheetId = this.settings.get(STORE_SELECTED_CHEATSHEET_ID);
        if (cheatsheetId == null) {
            return;
        }
        CheatSheetElement cheatsheet = category.findCheatSheet(cheatsheetId, false);
        if (cheatsheet == null) {
            return;
        }
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)cheatsheet));
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.settings = settings;
    }

    protected void storeExpandedCategories() {
        Object[] expandedElements = this.treeViewer.getExpandedElements();
        String[] expandedElementPaths = new String[expandedElements.length];
        int i = 0;
        while (i < expandedElements.length) {
            expandedElementPaths[i] = ((CheatSheetCollectionElement)((Object)expandedElements[i])).getPath().toString();
            ++i;
        }
        this.settings.put(STORE_EXPANDED_CATEGORIES_ID, expandedElementPaths);
    }

    protected void storeSelectedCheatSheet() {
        CheatSheetElement element = null;
        Object el = this.getSingleSelection((IStructuredSelection)this.treeViewer.getStructuredSelection());
        if (el == null) {
            return;
        }
        if (!(el instanceof CheatSheetElement)) {
            return;
        }
        element = (CheatSheetElement)((Object)el);
        this.settings.put(STORE_SELECTED_CHEATSHEET_ID, element.getID());
    }

    private void storeFileSettings() {
        int radioSetting = 0;
        if (this.selectRegisteredRadio.getSelection()) {
            radioSetting = 1;
        }
        if (this.selectFileRadio.getSelection()) {
            radioSetting = 2;
        }
        if (this.selectUrlRadio.getSelection()) {
            radioSetting = 3;
        }
        this.settings.put(STORE_RADIO_SETTING, radioSetting);
        this.settings.put(STORE_CHEATSHEET_FILENAME, this.selectFileCombo.getText());
        this.settings.put(STORE_CHEATSHEET_URL, this.selectUrlCombo.getText());
        this.saveMRU(this.mostRecentUrls, STORE_URL_MRU, this.selectUrlCombo.getText());
        this.saveMRU(this.mostRecentFiles, STORE_FILE_MRU, this.selectFileCombo.getText());
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(CheatSheetCategoryBasedSelectionDialog.class)).getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    private Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.CHEAT_SHEET_SELECTION_DIALOG_MSG);
        label.setFont(composite.getFont());
        return label;
    }

    public IStatus getStatus() {
        return this.status;
    }

    private static class ActivityViewerFilter
    extends ViewerFilter {
        private boolean hasEncounteredFilteredItem = false;

        private ActivityViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (WorkbenchActivityHelper.filterItem((Object)element)) {
                this.setHasEncounteredFilteredItem(true);
                return false;
            }
            return true;
        }

        public boolean getHasEncounteredFilteredItem() {
            return this.hasEncounteredFilteredItem;
        }

        public void setHasEncounteredFilteredItem(boolean hasEncounteredFilteredItem) {
            this.hasEncounteredFilteredItem = hasEncounteredFilteredItem;
        }
    }

    private class BrowseListener
    implements SelectionListener {
        private BrowseListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            FileDialog fileDlg = new FileDialog(CheatSheetCategoryBasedSelectionDialog.this.getShell());
            fileDlg.setFilterExtensions(new String[]{"*.xml"});
            fileDlg.setText(Messages.SELECTION_DIALOG_FILEPICKER_TITLE);
            fileDlg.open();
            String filename = fileDlg.getFileName();
            if (filename != null) {
                IPath folderPath = IPath.fromOSString((String)fileDlg.getFilterPath());
                IPath filePath = folderPath.append(filename);
                CheatSheetCategoryBasedSelectionDialog.this.selectFileCombo.setText(filePath.toOSString());
                CheatSheetCategoryBasedSelectionDialog.this.checkRadioButtons();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class CheatsheetLabelProvider
    extends LabelProvider {
        private CheatsheetLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof WorkbenchAdapter) {
                return ((WorkbenchAdapter)obj).getLabel(null);
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof CheatSheetElement) {
                CheatSheetElement element = (CheatSheetElement)((Object)obj);
                if (element.isComposite()) {
                    return CheatSheetPlugin.getPlugin().getImageRegistry().get("COMPOSITE_OBJ");
                }
                return CheatSheetPlugin.getPlugin().getImageRegistry().get("CHEATSHEET_OBJ");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
    }

    private class FileAndUrlListener
    implements ModifyListener {
        private FileAndUrlListener() {
        }

        public void modifyText(ModifyEvent e) {
            CheatSheetCategoryBasedSelectionDialog.this.setOkButton();
        }
    }

    private class RadioSelectionListener
    implements SelectionListener {
        private RadioSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            CheatSheetCategoryBasedSelectionDialog.this.checkRadioButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

