/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.internal.collectionextract.FieldSizeArrayCollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class IdentityHashMapCollectionExtractor
extends FieldSizeArrayCollectionExtractor
implements IMapExtractor {
    public IdentityHashMapCollectionExtractor(String sizeField, String arrayField) {
        super(sizeField, arrayField);
    }

    @Override
    public Integer getCapacity(IObject collection) throws SnapshotException {
        Integer capacity = super.getCapacity(collection);
        return capacity != null ? Integer.valueOf(capacity / 2) : null;
    }

    @Override
    public boolean hasExtractableArray() {
        return false;
    }

    @Override
    public boolean hasExtractableContents() {
        return true;
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        Integer value = ExtractionUtils.toInteger(coll.resolveValue(this.sizeField));
        if (value != null) {
            return value;
        }
        return ExtractionUtils.getNumberOfNotNullArrayElements(this.extractEntryIds(coll));
    }

    @Override
    public int[] extractEntryIds(IObject idMap) throws SnapshotException {
        ISnapshot snapshot = idMap.getSnapshot();
        IObjectArray array = super.extractEntries(idMap);
        if (array == null) {
            return new int[0];
        }
        ArrayInt result = new ArrayInt();
        int i = 0;
        while (i < array.getLength()) {
            long[] l = array.getReferenceArray(i, 2);
            boolean empty = true;
            int j = 0;
            while (j < l.length) {
                if (l[j] != 0L) {
                    empty = false;
                    break;
                }
                ++j;
            }
            if (!empty) {
                j = 0;
                while (j < l.length) {
                    int objId = l[j] != 0L ? snapshot.mapAddressToId(l[j]) : -1;
                    result.add(objId);
                    ++j;
                }
            }
            i += 2;
        }
        return result.toArray();
    }

    @Override
    public boolean hasCollisionRatio() {
        return true;
    }

    @Override
    public Double getCollisionRatio(IObject coll) throws SnapshotException {
        IObjectArray array = super.extractEntries(coll);
        if (array == null) {
            return 0.0;
        }
        int consec = 0;
        int count = 0;
        boolean first = false;
        boolean prev = false;
        int i = 0;
        while (i < array.getLength()) {
            long[] l = array.getReferenceArray(i, 2);
            boolean empty = true;
            int j = 0;
            while (j < l.length) {
                if (l[j] != 0L) {
                    empty = false;
                    break;
                }
                ++j;
            }
            if (empty) {
                prev = false;
            } else {
                ++count;
                if (i == 0) {
                    first = true;
                }
                if (prev) {
                    ++consec;
                }
                prev = true;
            }
            i += 2;
        }
        if (first && prev) {
            ++consec;
        }
        if (count == 0) {
            return 0.0;
        }
        double x = (double)consec / (double)count;
        return 0.29 * x + 0.21 * x * x;
    }

    @Override
    public Double getFillRatio(IObject coll) throws SnapshotException {
        return super.getFillRatio(coll);
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject coll) throws SnapshotException {
        return super.getNumberOfNotNullElements(coll) / 2;
    }

    @Override
    public Iterator<Map.Entry<IObject, IObject>> extractMapEntries(IObject coll) throws SnapshotException {
        try {
            return new EntryIterator(coll.getSnapshot(), this.extractEntryIds(coll));
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    private static class EntryIterator
    implements Iterator<Map.Entry<IObject, IObject>> {
        private final ISnapshot snapshot;
        private final int[] ids;
        private int idx;

        public EntryIterator(ISnapshot snapshot, int[] ids) {
            this.snapshot = snapshot;
            this.ids = ids;
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.ids.length;
        }

        @Override
        public Map.Entry<IObject, IObject> next() {
            final int oidx = this.idx;
            this.idx += 2;
            return new Map.Entry<IObject, IObject>(){

                @Override
                public IObject getKey() {
                    int objectId;
                    block3: {
                        try {
                            objectId = ids[oidx];
                            if (objectId != -1) break block3;
                            return null;
                        }
                        catch (SnapshotException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return snapshot.getObject(objectId);
                }

                @Override
                public IObject getValue() {
                    int objectId;
                    block3: {
                        try {
                            objectId = ids[oidx + 1];
                            if (objectId != -1) break block3;
                            return null;
                        }
                        catch (SnapshotException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return snapshot.getObject(objectId);
                }

                @Override
                public IObject setValue(IObject value) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

