/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.HashMapLongObject;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.hprof.AbstractParser;
import org.eclipse.mat.hprof.ByteArrayPositionInputStream;
import org.eclipse.mat.hprof.IHprofParserHandler;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.describer.Version;
import org.eclipse.mat.hprof.ui.HprofPreferences;
import org.eclipse.mat.parser.IPreliminaryIndex;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexManager;
import org.eclipse.mat.parser.index.IndexReader;
import org.eclipse.mat.parser.index.IndexWriter;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.PrimitiveArrayImpl;
import org.eclipse.mat.parser.model.XGCRootInfo;
import org.eclipse.mat.parser.model.XSnapshotInfo;
import org.eclipse.mat.snapshot.UnreachableObjectsHistogram;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

public class HprofParserHandlerImpl
implements IHprofParserHandler {
    private Version version;
    private XSnapshotInfo info = new XSnapshotInfo();
    private Map<String, List<ClassImpl>> classesByName = new HashMap<String, List<ClassImpl>>();
    private HashMapLongObject<ClassImpl> classesByAddress = new HashMapLongObject();
    private HashMapLongObject<List<XGCRootInfo>> gcRoots = new HashMapLongObject(200);
    private IndexWriter.Identifier identifiers0 = null;
    private IIndexReader.IOne2LongIndex identifiers = null;
    private IndexWriter.IntArray1NWriter outbound = null;
    private IndexWriter.IntIndexCollector object2classId = null;
    private IndexWriter.LongIndexCollector object2position = null;
    private ObjectToSize array2size = null;
    private HashMap<Long, Boolean> requiredArrayClassIDs = new HashMap();
    private HashMap<Long, Integer> requiredClassIDs = new HashMap();
    private IClass[] primitiveArrays = new IClass[IPrimitiveArray.TYPE.length];
    private boolean[] requiredPrimitiveArrays = new boolean[IPrimitiveArray.COMPONENT_TYPE.length];
    private HashMapLongObject<HashMapLongObject<List<XGCRootInfo>>> threadAddressToLocals = new HashMapLongObject();
    private ConcurrentHashMap<Integer, ClassImpl> discardedObjectsByClass = new ConcurrentHashMap();
    private int refSize;
    private int pointerSize;
    private int objectAlign;
    private final boolean NEWCLASSSIZE = HprofPreferences.useAdditionalClassReferences();
    private long maxFilePosition = 0L;
    private Pattern discardPattern = Pattern.compile("char\\[\\]|java\\.lang\\.String");
    private double discardRatio = 0.0;
    private double discardOffset = 0.0;
    private long discardSeed = 1L;
    private Random rand = new Random(this.discardSeed);
    ConcurrentHashMap<Long, List<IClass>> classHierarchyCache = new ConcurrentHashMap();

    @Override
    public void beforePass1(XSnapshotInfo snapshotInfo) throws IOException {
        this.info = snapshotInfo;
        this.identifiers0 = new IndexWriter.Identifier();
        if (this.info.getProperty("discard_ratio") instanceof Integer) {
            this.discardRatio = (double)((Integer)this.info.getProperty("discard_ratio")).intValue() / 100.0;
            if (this.info.getProperty("discard_offset") instanceof Integer) {
                this.discardOffset = (double)((Integer)this.info.getProperty("discard_offset")).intValue() / 100.0;
            } else {
                this.info.setProperty("discard_offset", (Serializable)Integer.valueOf((int)Math.round(this.discardOffset * 100.0)));
            }
            if (this.info.getProperty("discard_seed") instanceof Integer) {
                this.discardSeed = ((Integer)this.info.getProperty("discard_seed")).intValue();
            } else {
                this.info.setProperty("discard_seed", (Serializable)Long.valueOf(this.discardSeed));
            }
            this.rand = new Random(this.discardSeed);
            if (this.info.getProperty("discard_pattern") instanceof String) {
                this.discardPattern = Pattern.compile((String)((Object)this.info.getProperty("discard_pattern")));
            } else {
                this.info.setProperty("discard_pattern", (Serializable)((Object)this.discardPattern.toString()));
            }
        }
    }

    @Override
    public void beforePass2(IProgressListener monitor) throws IOException, SnapshotException {
        this.identifiers0.add(0L);
        this.identifiers0.sort();
        this.calculateAlignment();
        if (this.pointerSize == 8) {
            this.info.setProperty("$useCompressedOops", (Serializable)Boolean.valueOf(this.refSize == 4));
        }
        this.createRequiredFakeClasses();
        monitor.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.HprofParserHandlerImpl_HeapContainsObjects, (Object[])new Object[]{this.info.getPath(), this.identifiers0.size()}), null);
        this.addTypesAndDummyStatics();
        int maxClassId = 0;
        Iterator e = this.classesByAddress.values();
        while (e.hasNext()) {
            ClassImpl clazz = (ClassImpl)e.next();
            int index = this.identifiers0.reverse(clazz.getObjectAddress());
            clazz.setObjectId(index);
            maxClassId = Math.max(maxClassId, index);
            clazz.setHeapSizePerInstance((long)this.calculateInstanceSize(clazz));
            clazz.setUsedHeapSize((long)this.calculateClassSize(clazz));
        }
        this.identifiers = new IndexWriter.LongIndexStreamer().writeTo(IndexManager.Index.IDENTIFIER.getFile(String.valueOf(this.info.getPrefix()) + "temp."), this.identifiers0.iterator());
        this.identifiers0.delete();
        this.identifiers0 = null;
        this.outbound = new IndexWriter.IntArray1NWriter(this.identifiers.size(), IndexManager.Index.OUTBOUND.getFile(String.valueOf(this.info.getPrefix()) + "temp."));
        this.object2classId = new IndexWriter.IntIndexCollector(this.identifiers.size(), IndexWriter.mostSignificantBit((int)maxClassId));
        this.object2position = new IndexWriter.LongIndexCollector(this.identifiers.size(), IndexWriter.mostSignificantBit((long)this.maxFilePosition));
        this.array2size = new ObjectToSize(this.identifiers.size());
        List<ClassImpl> javaLangClasses = this.classesByName.get("java.lang.Class");
        ClassImpl javaLangClass = javaLangClasses.get(0);
        javaLangClass.setObjectId(this.identifiers.reverse(javaLangClass.getObjectAddress()));
        Iterator e2 = this.classesByAddress.values();
        while (e2.hasNext()) {
            ClassImpl clazz = (ClassImpl)e2.next();
            clazz.setSuperClassIndex(this.identifiers.reverse(clazz.getSuperClassAddress()));
            clazz.setClassLoaderIndex(this.identifiers.reverse(clazz.getClassLoaderAddress()));
            if (clazz.getClassLoaderId() < 0) {
                clazz.setClassLoaderAddress(0L);
                clazz.setClassLoaderIndex(this.identifiers.reverse(0L));
            }
            boolean skipLogRefs = false;
            if (clazz.getClazz() == null) {
                clazz.setClassInstance(javaLangClass);
                if (this.NEWCLASSSIZE) {
                    clazz.setUsedHeapSize(clazz.getUsedHeapSize() + clazz.getClazz().getHeapSizePerInstance());
                }
                clazz.getClazz().addInstance(clazz.getUsedHeapSize());
            } else {
                skipLogRefs = true;
            }
            ClassImpl superclass = this.lookupClass(clazz.getSuperClassAddress());
            if (superclass != null) {
                superclass.addSubClass(clazz);
            }
            this.object2classId.set(clazz.getObjectId(), clazz.getClazz().getObjectId());
            if (skipLogRefs) continue;
            this.outbound.log(this.identifiers, clazz.getObjectId(), clazz.getReferences());
        }
        ClassImpl classLoaderClass = this.classesByName.get("java.lang.ClassLoader").get(0);
        IHprofParserHandler.HeapObject heapObject = new IHprofParserHandler.HeapObject(0L, classLoaderClass, classLoaderClass.getHeapSizePerInstance());
        heapObject.references.add(classLoaderClass.getObjectAddress());
        this.addObject(heapObject, true);
    }

    private void addTypesAndDummyStatics() {
        ClassImpl type;
        ClassImpl cl;
        HashMapLongObject.Entry e;
        Iterator it = this.classesByAddress.entries();
        while (it.hasNext()) {
            e = (HashMapLongObject.Entry)it.next();
            cl = (ClassImpl)e.getValue();
            type = cl.getClazz();
            if (type == null) continue;
            ArrayList<Field> newStatics = new ArrayList<Field>(cl.getStaticFields());
            List<IClass> icls = this.resolveClassHierarchy(type.getClassAddress());
            for (IClass tcl : icls) {
                for (FieldDescriptor fd : tcl.getFieldDescriptors()) {
                    Field st = new Field("<" + fd.getName() + ">", fd.getType(), null);
                    newStatics.add(st);
                }
            }
            if (newStatics.size() == cl.getStaticFields().size()) continue;
            ClassImpl newcl = new ClassImpl(cl.getObjectAddress(), cl.getName(), cl.getSuperClassAddress(), cl.getClassLoaderAddress(), newStatics.toArray(new Field[newStatics.size()]), cl.getFieldDescriptors().toArray(new FieldDescriptor[0]));
            newcl.setClassInstance(type);
            this.classesByAddress.put(e.getKey(), (Object)newcl);
            List<ClassImpl> nms = this.classesByName.get(cl.getName());
            int i = 0;
            while (i < nms.size()) {
                if (nms.get(i) == cl) {
                    nms.set(i, newcl);
                }
                ++i;
            }
        }
        it = this.classesByAddress.entries();
        while (it.hasNext()) {
            ClassImpl type2;
            e = (HashMapLongObject.Entry)it.next();
            cl = (ClassImpl)e.getValue();
            type = cl.getClazz();
            if (type == null || type == (type2 = (ClassImpl)this.classesByAddress.get(type.getObjectAddress()))) continue;
            cl.setClassInstance(type2);
        }
    }

    private void calculateAlignment() {
        int minAlign = 8;
        int maxAlign = 256;
        long prev = 0L;
        long align = 0L;
        for (long next : this.identifiers0) {
            if (next == 0L) continue;
            long diff = next - prev;
            prev = next;
            if (next == diff) continue;
            if (align == 0L) {
                align = diff;
                continue;
            }
            long mx = Math.max(align, diff);
            long mn = Math.min(align, diff);
            long d = mx % mn;
            while (d != 0L) {
                mx = mn;
                mn = d;
                d = mx % mn;
            }
            align = mn;
            if (align <= 8L) break;
        }
        this.objectAlign = Math.max((int)Math.min(align, 256L), 8);
    }

    private void createRequiredFakeClasses() throws IOException, SnapshotException {
        String[] clss;
        long nextObjectAddress = 0L;
        int clsid = 0;
        List<ClassImpl> jlos = this.classesByName.get("java.lang.Object");
        long jlo = jlos == null || jlos.isEmpty() ? 0L : jlos.get(0).getObjectAddress();
        String[] stringArray = clss = new String[]{"java.lang.Class", "java.lang.ClassLoader"};
        int n = clss.length;
        int n2 = 0;
        while (n2 < n) {
            String cls = stringArray[n2];
            List<ClassImpl> jlcs = this.classesByName.get(cls);
            if (jlcs == null || jlcs.isEmpty()) {
                while (this.identifiers0.reverse(nextObjectAddress += (long)this.objectAlign) >= 0) {
                }
                ClassImpl type = new ClassImpl(nextObjectAddress, cls, jlo, 0L, new Field[0], new FieldDescriptor[0]);
                this.addFakeClass(type, -1L);
            }
            ++n2;
        }
        if (!this.requiredArrayClassIDs.isEmpty()) {
            for (long arrayClassID : this.requiredArrayClassIDs.keySet()) {
                ClassImpl arrayType = this.lookupClass(arrayClassID);
                if (arrayType != null) continue;
                int objectId = this.identifiers0.reverse(arrayClassID);
                if (objectId >= 0) {
                    String msg = MessageUtil.format((String)Messages.HprofParserHandlerImpl_Error_ExpectedClassSegment, (Object[])new Object[]{Long.toHexString(arrayClassID)});
                    throw new SnapshotException(msg);
                }
                arrayType = new ClassImpl(arrayClassID, "unknown-class-" + clsid + "[]", jlo, 0L, new Field[0], new FieldDescriptor[0]);
                ++clsid;
                this.addFakeClass(arrayType, -1L);
            }
        }
        this.requiredArrayClassIDs = null;
        int arrayType = 0;
        while (arrayType < this.requiredPrimitiveArrays.length) {
            if (this.requiredPrimitiveArrays[arrayType]) {
                String name = IPrimitiveArray.TYPE[arrayType];
                IClass clazz = this.lookupClassByName(name, true);
                if (clazz == null) {
                    while (this.identifiers0.reverse(nextObjectAddress += (long)this.objectAlign) >= 0) {
                    }
                    clazz = new ClassImpl(nextObjectAddress, name, jlo, 0L, new Field[0], new FieldDescriptor[0]);
                    this.addFakeClass((ClassImpl)clazz, -1L);
                }
                this.primitiveArrays[arrayType] = clazz;
            }
            ++arrayType;
        }
        if (!this.requiredClassIDs.isEmpty()) {
            for (Map.Entry<Long, Integer> e : this.requiredClassIDs.entrySet()) {
                long classID = e.getKey();
                ClassImpl type = this.lookupClass(classID);
                if (type != null) continue;
                int objectId = this.identifiers0.reverse(classID);
                if (objectId >= 0) {
                    String msg = MessageUtil.format((String)Messages.HprofParserHandlerImpl_Error_ExpectedClassSegment, (Object[])new Object[]{Long.toHexString(classID)});
                    throw new SnapshotException(msg);
                }
                int size = e.getValue();
                if (size >= Integer.MAX_VALUE) {
                    size = 0;
                }
                int nfields = size / 4 + Integer.bitCount(size % 4);
                FieldDescriptor[] fds = new FieldDescriptor[nfields];
                int i = 0;
                while (i < size / 4) {
                    fds[i] = new FieldDescriptor("unknown-field-" + i, 10);
                    ++i;
                }
                if ((size & 2) != 0) {
                    fds[i] = new FieldDescriptor("unknown-field-" + i, 9);
                    ++i;
                }
                if ((size & 1) != 0) {
                    fds[i] = new FieldDescriptor("unknown-field-" + i, 8);
                    ++i;
                }
                type = new ClassImpl(classID, "unknown-class-" + clsid, jlo, 0L, new Field[0], fds);
                ++clsid;
                this.addFakeClass(type, -1L);
            }
        }
        this.requiredClassIDs = null;
        this.identifiers0.sort();
    }

    private int calculateInstanceSize(ClassImpl clazz) {
        if (!clazz.isArrayType()) {
            return this.alignUpToX(this.calculateSizeRecursive(clazz), this.objectAlign);
        }
        return this.refSize;
    }

    private int calculateSizeRecursive(ClassImpl clazz) {
        if (clazz.getSuperClassAddress() == 0L) {
            return this.pointerSize + this.refSize;
        }
        ClassImpl superClass = (ClassImpl)this.classesByAddress.get(clazz.getSuperClassAddress());
        int ownFieldsSize = 0;
        for (FieldDescriptor field : clazz.getFieldDescriptors()) {
            ownFieldsSize += this.sizeOf(field);
        }
        return this.alignUpToX(ownFieldsSize + this.calculateSizeRecursive(superClass), this.refSize);
    }

    private int calculateClassSize(ClassImpl clazz) {
        int staticFieldsSize = 0;
        for (Field field : clazz.getStaticFields()) {
            staticFieldsSize += this.sizeOf((FieldDescriptor)field);
        }
        return this.alignUpToX(staticFieldsSize, this.objectAlign);
    }

    private int sizeOf(FieldDescriptor field) {
        int type = field.getType();
        if (type == 2) {
            return this.refSize;
        }
        return IPrimitiveArray.ELEMENT_SIZE[type];
    }

    private int alignUpToX(int n, int x) {
        int r = n % x;
        return r == 0 ? n : n + x - r;
    }

    private long alignUpToX(long n, int x) {
        long r = n % (long)x;
        return r == 0L ? n : n + (long)x - r;
    }

    @Override
    public IIndexReader.IOne2LongIndex fillIn(IPreliminaryIndex index, IProgressListener listener) throws IOException {
        boolean foundSystemClasses = false;
        Iterator it = this.gcRoots.values();
        block0: while (it.hasNext() && !foundSystemClasses) {
            for (XGCRootInfo x : (List)it.next()) {
                if (x.getType() != 2) continue;
                foundSystemClasses = true;
                continue block0;
            }
        }
        if (!foundSystemClasses) {
            ClassImpl[] allClasses;
            ClassImpl[] classImplArray = allClasses = (ClassImpl[])this.classesByAddress.getAllValues((Object[])new ClassImpl[0]);
            int n = allClasses.length;
            int n2 = 0;
            while (n2 < n) {
                ClassImpl clazz = classImplArray[n2];
                if (clazz.getClassLoaderAddress() == 0L && !clazz.isArrayType() && !this.gcRoots.containsKey(clazz.getObjectAddress())) {
                    this.addGCRoot(clazz.getObjectAddress(), 0L, 2);
                }
                ++n2;
            }
        }
        HashMapIntObject classesById = new HashMapIntObject(this.classesByAddress.size());
        Iterator iter = this.classesByAddress.values();
        while (iter.hasNext()) {
            ClassImpl clazz = (ClassImpl)iter.next();
            classesById.put(clazz.getObjectId(), (Object)clazz);
        }
        index.setClassesById(classesById);
        long discardedObjects = 0L;
        long discardedSize = 0L;
        ArrayList<UnreachableObjectsHistogram.Record> records = new ArrayList<UnreachableObjectsHistogram.Record>();
        for (ClassImpl clazz : this.discardedObjectsByClass.values()) {
            records.add(new UnreachableObjectsHistogram.Record(clazz.getName(), clazz.getObjectAddress(), clazz.getNumberOfObjects(), clazz.getTotalSize()));
            discardedObjects += (long)clazz.getNumberOfObjects();
            discardedSize += clazz.getTotalSize();
        }
        if (discardedObjects > 0L) {
            UnreachableObjectsHistogram deadObjectHistogram = new UnreachableObjectsHistogram(records);
            this.info.setProperty(UnreachableObjectsHistogram.class.getName(), (Serializable)deadObjectHistogram);
            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.HprofParserHandlerImpl_DiscardedObjects, (Object[])new Object[]{discardedObjects, discardedSize, this.discardRatio, this.discardPattern}), null);
        }
        index.setGcRoots(this.map2ids(this.gcRoots));
        HashMapIntObject thread2objects2roots = new HashMapIntObject();
        Iterator iter2 = this.threadAddressToLocals.entries();
        while (iter2.hasNext()) {
            HashMapIntObject<List<XGCRootInfo>> objects2roots;
            HashMapLongObject.Entry entry = (HashMapLongObject.Entry)iter2.next();
            int threadId = this.identifiers.reverse(entry.getKey());
            if (threadId < 0 || (objects2roots = this.map2ids((HashMapLongObject<List<XGCRootInfo>>)((HashMapLongObject)entry.getValue()))).isEmpty()) continue;
            thread2objects2roots.put(threadId, objects2roots);
        }
        index.setThread2objects2roots(thread2objects2roots);
        index.setIdentifiers(this.identifiers);
        index.setArray2size(this.array2size.writeTo(IndexManager.Index.A2SIZE.getFile(String.valueOf(this.info.getPrefix()) + "temp.")));
        index.setObject2classId(this.object2classId.writeTo(IndexManager.Index.O2CLASS.getFile(String.valueOf(this.info.getPrefix()) + "temp.")));
        index.setOutbound(this.outbound.flush());
        return this.object2position.writeTo(new File(String.valueOf(this.info.getPrefix()) + "temp.o2hprof.index"));
    }

    private HashMapIntObject<List<XGCRootInfo>> map2ids(HashMapLongObject<List<XGCRootInfo>> source) {
        HashMapIntObject sink = new HashMapIntObject();
        Iterator iter = source.entries();
        while (iter.hasNext()) {
            HashMapLongObject.Entry entry = (HashMapLongObject.Entry)iter.next();
            int idx = this.identifiers.reverse(entry.getKey());
            if (idx < 0) continue;
            Iterator roots = ((List)entry.getValue()).iterator();
            while (roots.hasNext()) {
                XGCRootInfo root = (XGCRootInfo)roots.next();
                root.setObjectId(idx);
                if (root.getContextAddress() == 0L) continue;
                int contextId = this.identifiers.reverse(root.getContextAddress());
                if (contextId < 0) {
                    roots.remove();
                    continue;
                }
                root.setContextId(contextId);
            }
            sink.put(idx, (Object)((List)entry.getValue()));
        }
        return sink;
    }

    @Override
    public void cancel() {
        if (this.outbound != null) {
            this.outbound.cancel();
        }
    }

    @Override
    public void addProperty(String name, String value) throws IOException {
        if ("VERSION".equals(name)) {
            this.version = Version.valueOf(value);
            this.info.setProperty("hprof.version", (Serializable)((Object)this.version.name()));
        } else if ("ID_SIZE".equals(name)) {
            int idSize = Integer.parseInt(value);
            this.info.setIdentifierSize(idSize);
            this.pointerSize = idSize;
            this.refSize = idSize;
        } else if ("CREATION_DATE".equals(name)) {
            this.info.setCreationDate(new Date(Long.parseLong(value)));
        } else if ("REF_SIZE".equals(name)) {
            this.refSize = Integer.parseInt(value);
        } else if ("LENGTH".equals(name)) {
            long length = Long.parseLong(value);
            this.info.setProperty("hprof.length", (Serializable)Long.valueOf(length));
        } else if ("HEAP_POS".equals(name)) {
            long pos = Long.parseLong(value);
            this.info.setProperty("hprof.heap.start", (Serializable)Long.valueOf(pos));
        }
    }

    @Override
    public void addGCRoot(long id, long referrer, int rootType) {
        if (referrer != 0L) {
            ArrayList<XGCRootInfo> gcRootInfo;
            HashMapLongObject localAddressToRootInfo = (HashMapLongObject)this.threadAddressToLocals.get(referrer);
            if (localAddressToRootInfo == null) {
                localAddressToRootInfo = new HashMapLongObject();
                this.threadAddressToLocals.put(referrer, (Object)localAddressToRootInfo);
            }
            if ((gcRootInfo = (ArrayList<XGCRootInfo>)localAddressToRootInfo.get(id)) == null) {
                gcRootInfo = new ArrayList<XGCRootInfo>(1);
                localAddressToRootInfo.put(id, gcRootInfo);
            }
            gcRootInfo.add(new XGCRootInfo(id, referrer, rootType));
            return;
        }
        ArrayList<XGCRootInfo> r = (ArrayList<XGCRootInfo>)this.gcRoots.get(id);
        if (r == null) {
            r = new ArrayList<XGCRootInfo>(3);
            this.gcRoots.put(id, r);
        }
        r.add(new XGCRootInfo(id, referrer, rootType));
    }

    private void addFakeClass(ClassImpl clazz, long filePosition) throws IOException {
        this.identifiers0.add(clazz.getObjectAddress());
        this.classesByAddress.put(clazz.getObjectAddress(), (Object)clazz);
        List<ClassImpl> list = this.classesByName.get(clazz.getName());
        if (list == null) {
            list = new ArrayList<ClassImpl>();
            this.classesByName.put(clazz.getName(), list);
        }
        list.add(clazz);
    }

    @Override
    public void addClass(ClassImpl clazz, long filePosition, int idSize, int instsize) throws IOException {
        this.identifiers0.add(clazz.getObjectAddress());
        this.classesByAddress.put(clazz.getObjectAddress(), (Object)clazz);
        List<ClassImpl> list = this.classesByName.get(clazz.getName());
        if (list == null) {
            list = new ArrayList<ClassImpl>();
            this.classesByName.put(clazz.getName(), list);
        }
        list.add(clazz);
        if (clazz.getSuperClassAddress() != 0L) {
            int ownFieldsSize = 0;
            for (FieldDescriptor field : clazz.getFieldDescriptors()) {
                int type = field.getType();
                if (type == 2) {
                    ownFieldsSize += idSize;
                    continue;
                }
                ownFieldsSize += IPrimitiveArray.ELEMENT_SIZE[type];
            }
            int supersize = Math.max(instsize - ownFieldsSize, 0);
            this.reportRequiredClass(clazz.getSuperClassAddress(), supersize, false);
        }
    }

    private void prepareHeapObject(IHprofParserHandler.HeapObject object) throws IOException {
        if (object.isPrimitiveArray) {
            byte elementType = (byte)object.classIdOrElementType;
            ClassImpl clazz = (ClassImpl)this.lookupPrimitiveArrayClassByType(elementType);
            object.usedHeapSize = this.getPrimitiveArrayHeapSize(elementType, object.arraySize);
            object.references.add(clazz.getObjectAddress());
            object.clazz = clazz;
        }
        if (object.isObjectArray) {
            long arrayClassObjectID = object.classIdOrElementType;
            ClassImpl arrayType = this.lookupClass(arrayClassObjectID);
            if (arrayType == null) {
                throw new RuntimeException(MessageUtil.format((String)Messages.Pass2Parser_Error_HandlerMustCreateFakeClassForAddress, (Object[])new Object[]{Long.toHexString(arrayClassObjectID)}));
            }
            object.usedHeapSize = this.getObjectArrayHeapSize(arrayType, object.arraySize);
            object.references.add(arrayType.getObjectAddress());
            long[] ids = object.ids;
            int ii = 0;
            while (ii < object.arraySize) {
                if (ids[ii] != 0L) {
                    object.references.add(ids[ii]);
                }
                ++ii;
            }
            object.clazz = arrayType;
            ids = null;
            object.ids = null;
        }
        if (!object.isObjectArray && !object.isPrimitiveArray) {
            long classID = object.classIdOrElementType;
            List<IClass> hierarchy = this.resolveClassHierarchy(classID);
            ByteArrayPositionInputStream in = new ByteArrayPositionInputStream(object.instanceData, object.idSize);
            ClassImpl thisClazz = (ClassImpl)hierarchy.get(0);
            ClassImpl objcl = this.lookupClass(object.objectAddress);
            Field[] statics = new Field[]{};
            if (objcl != null) {
                ClassImpl objcls = objcl;
                statics = objcls.getStaticFields().toArray(statics);
                object.clazz = thisClazz;
                object.usedHeapSize = objcls.getUsedHeapSize();
                object.references.addAll(objcls.getReferences());
            } else {
                object.clazz = thisClazz;
                object.usedHeapSize = thisClazz.getHeapSizePerInstance();
                object.references.add(thisClazz.getObjectAddress());
            }
            int pos = 0;
            for (IClass clazz : hierarchy) {
                for (FieldDescriptor field : clazz.getFieldDescriptors()) {
                    int type = field.getType();
                    Field stField = null;
                    int stidx = 0;
                    while (stidx < statics.length) {
                        if (statics[stidx] != null && statics[stidx].getType() == type && statics[stidx].getName().equals("<" + field.getName() + ">")) {
                            stField = statics[stidx];
                            statics[stidx] = null;
                            break;
                        }
                        ++stidx;
                    }
                    if (type == 2) {
                        long refId = in.readID(object.idSize);
                        pos += object.idSize;
                        if (refId == 0L) continue;
                        object.references.add(refId);
                        if (stField == null) continue;
                        stField.setValue((Object)new ObjectReference(null, refId));
                        continue;
                    }
                    Object value = AbstractParser.readValue(in, null, type, object.idSize);
                    if (stField == null) continue;
                    stField.setValue(value);
                }
            }
            if (pos != object.instanceData.length) {
                boolean unknown = false;
                for (IClass clazz : hierarchy) {
                    if (!clazz.getName().startsWith("unknown-class")) continue;
                    unknown = true;
                }
            }
        }
    }

    @Override
    public void addObject(IHprofParserHandler.HeapObject object) throws IOException {
        this.addObject(object, false);
    }

    private void addObject(IHprofParserHandler.HeapObject object, boolean prepared) throws IOException {
        int index;
        if (!prepared) {
            this.prepareHeapObject(object);
        }
        if ((index = this.mapAddressToId(object.objectAddress)) < 0) {
            ClassImpl cls = this.discardedObjectsByClass.get(object.clazz.getObjectId());
            if (cls == null) {
                cls = new ClassImpl(object.clazz.getObjectAddress(), object.clazz.getName(), object.clazz.getSuperClassAddress(), object.clazz.getClassLoaderAddress(), new Field[0], new FieldDescriptor[0]);
                cls.setHeapSizePerInstance(object.clazz.getHeapSizePerInstance());
                ClassImpl clsOld = this.discardedObjectsByClass.putIfAbsent(object.clazz.getObjectId(), cls);
                if (clsOld != null) {
                    cls = clsOld;
                }
            }
            cls.addInstance(object.usedHeapSize);
            return;
        }
        HashMapLongObject localVars = (HashMapLongObject)this.threadAddressToLocals.get(object.objectAddress);
        if (localVars != null) {
            IteratorLong e = localVars.keys();
            while (e.hasNext()) {
                object.references.add(e.next());
            }
        }
        this.outbound.log(this.identifiers, index, object.references);
        int classIndex = object.clazz.getObjectId();
        object.clazz.addInstance(object.usedHeapSize);
        this.object2classId.set(index, classIndex);
        this.object2position.set(index, object.filePosition);
        if (object.isPrimitiveArray || object.isObjectArray) {
            this.array2size.set(index, object.usedHeapSize);
        }
    }

    private boolean discard() {
        double top;
        if (this.discardRatio <= 0.0) {
            return false;
        }
        if (this.identifiers0.size() == 0) {
            return false;
        }
        double d = this.rand.nextDouble();
        return d < (top = this.discardRatio + this.discardOffset) && d >= this.discardOffset || d < top - 1.0;
    }

    private boolean discard(long classId) {
        if (!this.discard()) {
            return false;
        }
        ClassImpl cls = this.lookupClass(classId);
        return cls != null && this.discardPattern.matcher(cls.getName()).matches();
    }

    private void reportFilePosition(long filePosition) {
        if (filePosition > this.maxFilePosition) {
            this.maxFilePosition = filePosition;
        }
    }

    private void reportInstance(long id, long filePosition) {
        this.identifiers0.add(id);
        this.reportFilePosition(filePosition);
    }

    @Override
    public void reportInstanceWithClass(long id, long filePosition, long classID, int size) {
        if (this.discard(classID)) {
            this.reportFilePosition(filePosition);
            return;
        }
        this.reportInstance(id, filePosition);
        this.reportRequiredClass(classID, size, true);
    }

    @Override
    public void reportInstanceOfObjectArray(long id, long filePosition, long arrayClassID) {
        if (this.discard(arrayClassID)) {
            this.reportFilePosition(filePosition);
            return;
        }
        this.reportInstance(id, filePosition);
        this.reportRequiredObjectArray(arrayClassID);
    }

    @Override
    public void reportInstanceOfPrimitiveArray(long id, long filePosition, int arrayType) {
        if (this.discard() && this.discardPattern.matcher(IPrimitiveArray.TYPE[arrayType]).matches()) {
            this.reportFilePosition(filePosition);
            this.reportRequiredPrimitiveArray(arrayType);
            return;
        }
        this.reportInstance(id, filePosition);
        this.reportRequiredPrimitiveArray(arrayType);
    }

    private void reportRequiredObjectArray(long arrayClassID) {
        this.requiredArrayClassIDs.putIfAbsent(arrayClassID, true);
    }

    private void reportRequiredPrimitiveArray(int arrayType) {
        this.requiredPrimitiveArrays[arrayType] = true;
    }

    private void reportRequiredClass(long classID, int size, boolean sizeKnown) {
        if (sizeKnown) {
            this.requiredClassIDs.put(classID, size);
        } else {
            this.requiredClassIDs.putIfAbsent(classID, size);
        }
    }

    @Override
    public int getIdentifierSize() {
        return this.info.getIdentifierSize();
    }

    public ClassImpl lookupClass(long classId) {
        return (ClassImpl)this.classesByAddress.get(classId);
    }

    @Override
    public IClass lookupPrimitiveArrayClassByType(byte elementType) {
        return this.primitiveArrays[elementType];
    }

    @Override
    public IClass lookupClassByName(String name, boolean failOnMultipleInstances) {
        List<ClassImpl> list = this.classesByName.get(name);
        if (list == null) {
            return null;
        }
        if (failOnMultipleInstances && list.size() != 1) {
            throw new RuntimeException(MessageUtil.format((String)Messages.HprofParserHandlerImpl_Error_MultipleClassInstancesExist, (Object[])new Object[]{name}));
        }
        return (IClass)list.get(0);
    }

    @Override
    public IClass lookupClassByIndex(int objIndex) {
        return this.lookupClass(this.identifiers.get(objIndex));
    }

    @Override
    public List<IClass> resolveClassHierarchy(long classId) {
        List<IClass> cached = this.classHierarchyCache.get(classId);
        if (cached != null) {
            return cached;
        }
        ArrayList<IClass> answer = new ArrayList<IClass>();
        ClassImpl clazz = (ClassImpl)this.classesByAddress.get(classId);
        answer.add((IClass)clazz);
        while (clazz.hasSuperClass()) {
            clazz = (ClassImpl)this.classesByAddress.get(clazz.getSuperClassAddress());
            answer.add((IClass)clazz);
        }
        this.classHierarchyCache.put(classId, answer);
        return answer;
    }

    @Override
    public int mapAddressToId(long address) {
        return this.identifiers.reverse(address);
    }

    @Override
    public XSnapshotInfo getSnapshotInfo() {
        return this.info;
    }

    @Override
    public long getObjectArrayHeapSize(ClassImpl arrayType, int size) {
        long usedHeapSize = this.alignUpToX((long)(this.pointerSize + this.refSize + 4) + (long)size * arrayType.getHeapSizePerInstance(), this.objectAlign);
        return usedHeapSize;
    }

    @Override
    public long getPrimitiveArrayHeapSize(byte elementType, int size) {
        long usedHeapSize = this.alignUpToX((long)this.alignUpToX(this.pointerSize + this.refSize + 4, this.refSize) + (long)size * (long)PrimitiveArrayImpl.ELEMENT_SIZE[elementType], this.objectAlign);
        return usedHeapSize;
    }

    private static class ObjectToSize {
        private byte[] objectToSize;
        private ConcurrentHashMap<Integer, Long> bigObjs = new ConcurrentHashMap();
        private static final int SHIFT = 3;
        private static final int MASK = 255;

        ObjectToSize(int size) {
            this.objectToSize = new byte[size];
        }

        long get(int index) {
            if (this.bigObjs.containsKey(index)) {
                long size = this.bigObjs.get(index);
                return size;
            }
            return (this.objectToSize[index] & 0xFF) << 3;
        }

        long getSize(int index) {
            return this.get(index);
        }

        void set(int index, long size) {
            if ((size & 0xFFFFFFFFFFFFF807L) == 0L) {
                this.objectToSize[index] = (byte)(size >>> 3);
            } else {
                this.bigObjs.put(index, size);
            }
        }

        public IIndexReader.IOne2SizeIndex writeTo(File indexFile) throws IOException {
            final int size = this.objectToSize.length;
            return new IndexReader.SizeIndexReader(new IndexWriter.IntIndexStreamer().writeTo(indexFile, new IteratorInt(){
                int i;

                public boolean hasNext() {
                    return this.i < size;
                }

                public int next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return IndexWriter.SizeIndexCollectorUncompressed.compress((long)this.getSize(this.i++));
                }
            }));
        }
    }
}

