/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.accessibility;

import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class AccessibleCompositeAdapter {
    private static final char space = ' ';

    public static void access(Table table) {
        AccessibleCompositeAdapter.access((Composite)table, 24);
    }

    public static void access(Tree tree) {
        AccessibleCompositeAdapter.access((Composite)tree, 35);
    }

    private static void access(final Composite composite, final int role) {
        composite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID != -1) {
                    Item item = null;
                    if (role == 24) {
                        int maxchild = AccessibleCompositeAdapter.getItemCount(composite, role);
                        if (e.childID >= 0 && e.childID < maxchild) {
                            item = AccessibleCompositeAdapter.getItem(composite, role, e.childID);
                        }
                    } else {
                        Widget widget = composite.getDisplay().findWidget((Widget)composite, (long)e.childID);
                        if (widget instanceof Item) {
                            item = (Item)widget;
                        }
                    }
                    if (item != null) {
                        boolean nameOnly = role == 24;
                        int ncol = AccessibleCompositeAdapter.getColumnCount(composite, role);
                        if (nameOnly && ncol > 1) {
                            ncol = 1;
                        }
                        int[] colorder = AccessibleCompositeAdapter.getColumnOrder(composite, role);
                        StringBuffer rowbuf = new StringBuffer();
                        Item column = null;
                        Image image = null;
                        int icol = 0;
                        while (icol < ncol) {
                            String cellText;
                            int jcol = colorder[icol];
                            image = AccessibleCompositeAdapter.getImage(item, role, jcol);
                            if (image != null) {
                                rowbuf.append(MemoryAnalyserPlugin.getDefault().getImageText(image));
                                rowbuf.append(' ');
                            }
                            if ((cellText = AccessibleCompositeAdapter.getText(item, role, jcol)).trim().length() > 0) {
                                if (!nameOnly) {
                                    column = AccessibleCompositeAdapter.getColumn(composite, role, jcol);
                                    rowbuf.append(column.getText());
                                    rowbuf.append(' ');
                                }
                                rowbuf.append(cellText);
                                rowbuf.append(' ');
                            }
                            ++icol;
                        }
                        e.result = rowbuf.toString();
                    }
                }
            }
        });
        composite.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = e.childID == -1 ? role : 42;
            }
        });
    }

    private static Item getColumn(Composite composite, int role, int index) {
        return role == 24 ? ((Table)composite).getColumn(index) : ((Tree)composite).getColumn(index);
    }

    private static int getColumnCount(Composite composite, int role) {
        return role == 24 ? ((Table)composite).getColumnCount() : ((Tree)composite).getColumnCount();
    }

    private static int[] getColumnOrder(Composite composite, int role) {
        return role == 24 ? ((Table)composite).getColumnOrder() : ((Tree)composite).getColumnOrder();
    }

    private static Item getItem(Composite composite, int role, int index) {
        return role == 24 ? ((Table)composite).getItem(index) : ((Tree)composite).getItem(index);
    }

    private static int getItemCount(Composite composite, int role) {
        return role == 24 ? ((Table)composite).getItemCount() : ((Tree)composite).getItemCount();
    }

    private static Image getImage(Item item, int role, int index) {
        return role == 24 ? ((TableItem)item).getImage(index) : ((TreeItem)item).getImage(index);
    }

    private static String getText(Item item, int role, int index) {
        return role == 24 ? ((TableItem)item).getText(index) : ((TreeItem)item).getText(index);
    }
}

