/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.compaction;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.json.JsonMapBuilder;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.GraphObject;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.ListObject;
import com.apicatalog.jsonld.lang.NodeObject;
import com.apicatalog.jsonld.lang.Utils;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public final class Compaction {
    private final ActiveContext context;
    private boolean compactArrays;
    private boolean ordered;

    private Compaction(ActiveContext context) {
        this.context = context;
        this.compactArrays = false;
        this.ordered = false;
    }

    public static Compaction with(ActiveContext activeContext) {
        return new Compaction(activeContext);
    }

    public Compaction compactArrays(boolean compactArrays) {
        this.compactArrays = compactArrays;
        return this;
    }

    public Compaction ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public JsonValue compact(JsonValue element) throws JsonLdError {
        return this.compact(null, element);
    }

    public JsonValue compact(String activeProperty, JsonValue element) throws JsonLdError {
        JsonValue result;
        ActiveContext typeContext = this.context;
        ActiveContext activeContext = this.context;
        if (JsonUtils.isScalar(element)) {
            return element;
        }
        Optional<TermDefinition> activePropertyDefinition = activeContext.getTerm(activeProperty);
        if (JsonUtils.isArray(element)) {
            JsonArrayBuilder resultBuilder = Json.createArrayBuilder();
            for (JsonValue item : element.asJsonArray()) {
                JsonValue compactedItem = Compaction.with(activeContext).compactArrays(this.compactArrays).ordered(this.ordered).compact(activeProperty, item);
                if (!JsonUtils.isNotNull(compactedItem)) continue;
                resultBuilder.add(compactedItem);
            }
            JsonArray result2 = resultBuilder.build();
            if (result2.isEmpty() || result2.size() > 1 || !this.compactArrays || "@graph".equals(activeProperty) || "@set".equals(activeProperty) || activePropertyDefinition.filter(d -> d.hasContainerMapping("@list") || d.hasContainerMapping("@set")).isPresent()) {
                return result2;
            }
            return (JsonValue)result2.get(0);
        }
        JsonObject elementObject = element.asJsonObject();
        if (!(activeContext.getPreviousContext() == null || elementObject.containsKey((Object)"@value") || elementObject.containsKey((Object)"@id") && elementObject.size() == 1)) {
            activeContext = activeContext.getPreviousContext();
        }
        if (activePropertyDefinition.map(TermDefinition::getLocalContext).isPresent()) {
            activeContext = activeContext.newContext().overrideProtected(true).create(activePropertyDefinition.get().getLocalContext(), activePropertyDefinition.get().getBaseUrl());
        }
        if (!(!elementObject.containsKey((Object)"@value") && !elementObject.containsKey((Object)"@id") || activeContext.getOptions().isRdfStar() && elementObject.containsKey((Object)"@annotation") || !JsonUtils.isScalar(result = activeContext.valueCompaction().compact(elementObject, activeProperty)) && !activePropertyDefinition.map(TermDefinition::getTypeMapping).filter("@json"::equals).isPresent())) {
            return result;
        }
        if (ListObject.isListObject(element) && activePropertyDefinition.filter(d -> d.hasContainerMapping("@list")).isPresent()) {
            return Compaction.with(activeContext).compactArrays(this.compactArrays).ordered(this.ordered).compact(activeProperty, (JsonValue)elementObject.get((Object)"@list"));
        }
        boolean insideReverse = "@reverse".equals(activeProperty);
        JsonMapBuilder result3 = JsonMapBuilder.create();
        if (elementObject.containsKey((Object)"@type")) {
            ArrayList<String> compactedTypes = new ArrayList<String>();
            for (JsonValue type : JsonUtils.toCollection((JsonValue)elementObject.get((Object)"@type"))) {
                compactedTypes.add(activeContext.uriCompaction().vocab(true).compact(((JsonString)type).getString()));
            }
            Collections.sort(compactedTypes);
            for (String term : compactedTypes) {
                Optional<TermDefinition> termDefinition = typeContext.getTerm(term);
                if (!termDefinition.filter(TermDefinition::hasLocalContext).isPresent()) continue;
                activeContext = activeContext.newContext().propagate(false).create(termDefinition.get().getLocalContext(), termDefinition.get().getBaseUrl());
            }
        }
        for (String expandedProperty : Utils.index(elementObject.keySet(), this.ordered)) {
            String alias;
            JsonValue compactedValue;
            JsonValue expandedValue = (JsonValue)elementObject.get((Object)expandedProperty);
            if ("@id".equals(expandedProperty)) {
                compactedValue = JsonValue.NULL;
                if (JsonUtils.isString(expandedValue)) {
                    compactedValue = JsonUtils.toJsonValue(activeContext.uriCompaction().compact(((JsonString)expandedValue).getString()));
                } else if (activeContext.getOptions().isRdfStar() && NodeObject.isEmbeddedNode(expandedValue)) {
                    compactedValue = Compaction.with(activeContext).compactArrays(this.compactArrays).ordered(this.ordered).compact(expandedValue);
                }
                alias = activeContext.uriCompaction().vocab(true).compact(expandedProperty);
                result3.put(alias, compactedValue);
                continue;
            }
            if ("@type".equals(expandedProperty)) {
                if (JsonUtils.isString(expandedValue)) {
                    compactedValue = JsonUtils.toJsonValue(typeContext.uriCompaction().vocab(true).compact(((JsonString)expandedValue).getString()));
                } else if (JsonUtils.isArray(expandedValue)) {
                    JsonArrayBuilder compactedArray = Json.createArrayBuilder();
                    for (JsonValue expandedType : expandedValue.asJsonArray()) {
                        compactedArray.add(typeContext.uriCompaction().vocab(true).compact(((JsonString)expandedType).getString()));
                    }
                    compactedValue = compactedArray.build();
                } else {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_TYPE_VALUE, "@type value is not valid [" + expandedValue + "].");
                }
                alias = activeContext.uriCompaction().vocab(true).compact(expandedProperty);
                boolean asArray = !this.compactArrays || activeContext.inMode(JsonLdVersion.V1_1) && activeContext.getTerm(alias).filter(t -> t.hasContainerMapping("@set")).isPresent();
                result3.add(alias, compactedValue, asArray);
                continue;
            }
            if ("@reverse".equals(expandedProperty)) {
                JsonObject compactedMap = Compaction.with(activeContext).compactArrays(this.compactArrays).ordered(this.ordered).compact("@reverse", expandedValue).asJsonObject();
                JsonObjectBuilder remaining = null;
                for (Map.Entry entry : compactedMap.entrySet()) {
                    if (activeContext.getTerm((String)entry.getKey()).filter(TermDefinition::isReverseProperty).isPresent()) {
                        boolean asArray = !this.compactArrays || activeContext.getTerm((String)entry.getKey()).filter(td -> td.hasContainerMapping("@set")).isPresent();
                        result3.add((String)entry.getKey(), (JsonValue)entry.getValue(), asArray);
                        continue;
                    }
                    if (remaining == null) {
                        remaining = Json.createObjectBuilder();
                    }
                    remaining.add((String)entry.getKey(), (JsonValue)entry.getValue());
                }
                if (remaining == null) continue;
                String alias2 = activeContext.uriCompaction().vocab(true).compact("@reverse");
                result3.put(alias2, (JsonValue)remaining.build());
                continue;
            }
            if ("@preserve".equals(expandedProperty)) {
                compactedValue = Compaction.with(activeContext).compactArrays(this.compactArrays).ordered(this.ordered).compact(activeProperty, expandedValue);
                if (JsonUtils.isEmptyArray(compactedValue)) continue;
                result3.put("@preserve", compactedValue);
                continue;
            }
            if ("@index".equals(expandedProperty) && activePropertyDefinition.filter(d -> d.hasContainerMapping("@index")).isPresent()) continue;
            if (Keywords.anyMatch(expandedProperty, "@direction", "@index", "@language", "@value")) {
                String alias3 = activeContext.uriCompaction().vocab(true).compact(expandedProperty);
                result3.put(alias3, expandedValue);
                continue;
            }
            if (JsonUtils.isEmptyArray(expandedValue)) {
                String itemActiveProperty = activeContext.uriCompaction().value(expandedValue).vocab(true).reverse(insideReverse).compact(expandedProperty);
                Optional<String> nestProperty = activeContext.getTerm(itemActiveProperty).map(TermDefinition::getNestValue);
                if (nestProperty.isPresent()) {
                    String nestTerm = nestProperty.get();
                    if (!"@nest".equals(nestTerm) && !"@nest".equals(activeContext.uriExpansion().vocab(true).expand(nestTerm))) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_NEST_VALUE);
                    }
                    result3.getMapBuilder(nestTerm).add(itemActiveProperty, (JsonValue)JsonValue.EMPTY_JSON_ARRAY);
                } else {
                    result3.add(itemActiveProperty, (JsonValue)JsonValue.EMPTY_JSON_ARRAY);
                }
            }
            for (JsonValue expandedItem : expandedValue.asJsonArray()) {
                String itemActiveProperty = activeContext.uriCompaction().value(expandedItem).vocab(true).reverse(insideReverse).compact(expandedProperty);
                JsonMapBuilder nestResult = null;
                String nestResultKey = null;
                Optional<String> nestProperty = activeContext.getTerm(itemActiveProperty).map(TermDefinition::getNestValue);
                if (nestProperty.isPresent()) {
                    String nestTerm = nestProperty.get();
                    if (!"@nest".equals(nestTerm) && !"@nest".equals(activeContext.uriExpansion().vocab(true).expand(nestTerm))) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_NEST_VALUE);
                    }
                    nestResult = result3.getMapBuilder(nestTerm);
                    nestResultKey = nestTerm;
                } else {
                    nestResult = result3;
                }
                Collection container = activeContext.getTerm(itemActiveProperty).map(TermDefinition::getContainerMapping).orElseGet(() -> Collections.emptyList());
                boolean asArray = container.contains("@set") || "@graph".equals(itemActiveProperty) || "@list".equals(itemActiveProperty) || !this.compactArrays;
                JsonValue expandedItemValue = expandedItem;
                if (ListObject.isListObject(expandedItem)) {
                    expandedItemValue = (JsonValue)expandedItem.asJsonObject().get((Object)"@list");
                } else if (GraphObject.isGraphObject(expandedItem)) {
                    expandedItemValue = (JsonValue)expandedItem.asJsonObject().get((Object)"@graph");
                }
                JsonValue compactedItem = Compaction.with(activeContext).compactArrays(this.compactArrays).ordered(this.ordered).compact(itemActiveProperty, expandedItemValue);
                if (ListObject.isListObject(expandedItem)) {
                    compactedItem = JsonUtils.toJsonArray(compactedItem);
                    if (!container.contains("@list")) {
                        String key = activeContext.uriCompaction().vocab(true).compact("@list");
                        compactedItem = Json.createObjectBuilder().add(key, compactedItem).build();
                        if (JsonUtils.isObject(expandedItem) && expandedItem.asJsonObject().containsKey((Object)"@index")) {
                            String indexKey = activeContext.uriCompaction().vocab(true).compact("@index");
                            compactedItem = Json.createObjectBuilder((JsonObject)compactedItem.asJsonObject()).add(indexKey, (JsonValue)expandedItem.asJsonObject().get((Object)"@index")).build();
                        }
                        nestResult.add(itemActiveProperty, compactedItem, asArray);
                    } else {
                        nestResult.put(itemActiveProperty, compactedItem);
                    }
                } else if (GraphObject.isGraphObject(expandedItem)) {
                    String mapKey;
                    boolean followup = false;
                    if (container.contains("@graph") && container.contains("@id")) {
                        mapKey = null;
                        if (expandedItem.asJsonObject().containsKey((Object)"@id")) {
                            String id = expandedItem.asJsonObject().getString("@id");
                            mapKey = activeContext.uriCompaction().compact(id);
                        } else {
                            mapKey = activeContext.uriCompaction().vocab(true).compact("@none");
                        }
                        nestResult.getMapBuilder(itemActiveProperty).add(mapKey, compactedItem, asArray);
                    } else if (container.contains("@graph") && container.contains("@index") && GraphObject.isSimpleGraphObject(expandedItem)) {
                        mapKey = expandedItem.asJsonObject().containsKey((Object)"@index") ? expandedItem.asJsonObject().getString("@index") : "@none";
                        nestResult.getMapBuilder(itemActiveProperty).add(mapKey, compactedItem, asArray);
                    } else if (container.contains("@graph") && GraphObject.isSimpleGraphObject(expandedItem)) {
                        if (JsonUtils.isArray(compactedItem) && compactedItem.asJsonArray().size() > 1) {
                            compactedItem = Json.createObjectBuilder().add(activeContext.uriCompaction().vocab(true).compact("@included"), compactedItem).build();
                        }
                        nestResult.add(itemActiveProperty, compactedItem, asArray);
                    } else {
                        followup = true;
                    }
                    if (!container.contains("@graph") || followup) {
                        compactedItem = Json.createObjectBuilder().add(activeContext.uriCompaction().vocab(true).compact("@graph"), compactedItem).build();
                        if (expandedItem.asJsonObject().containsKey((Object)"@id")) {
                            compactedItem = Json.createObjectBuilder((JsonObject)compactedItem.asJsonObject()).add(activeContext.uriCompaction().vocab(true).compact("@id"), activeContext.uriCompaction().compact(expandedItem.asJsonObject().getString("@id"))).build();
                        }
                        if (expandedItem.asJsonObject().containsKey((Object)"@index")) {
                            compactedItem = Json.createObjectBuilder((JsonObject)compactedItem.asJsonObject()).add(activeContext.uriCompaction().vocab(true).compact("@index"), expandedItem.asJsonObject().getString("@index")).build();
                        }
                        nestResult.add(itemActiveProperty, compactedItem, asArray);
                    }
                } else if ((container.contains("@language") || container.contains("@index") || container.contains("@id") || container.contains("@type")) && !container.contains("@graph")) {
                    String keyToCompact = null;
                    if (container.contains("@language")) {
                        keyToCompact = "@language";
                    } else if (container.contains("@index")) {
                        keyToCompact = "@index";
                    } else if (container.contains("@id")) {
                        keyToCompact = "@id";
                    } else if (container.contains("@type")) {
                        keyToCompact = "@type";
                    }
                    String containerKey = activeContext.uriCompaction().vocab(true).compact(keyToCompact);
                    String indexKey = activeContext.getTerm(itemActiveProperty).map(TermDefinition::getIndexMapping).orElse("@index");
                    String mapKey = null;
                    if (container.contains("@language") && expandedItem.asJsonObject().containsKey((Object)"@value")) {
                        if (JsonUtils.isObject(compactedItem)) {
                            compactedItem = (JsonValue)compactedItem.asJsonObject().get((Object)"@value");
                        }
                        if (expandedItem.asJsonObject().containsKey((Object)"@language")) {
                            mapKey = expandedItem.asJsonObject().getString("@language");
                        }
                    } else if (container.contains("@index") && "@index".equals(indexKey)) {
                        if (expandedItem.asJsonObject().containsKey((Object)"@index")) {
                            mapKey = expandedItem.asJsonObject().getString("@index");
                        }
                    } else if (container.contains("@index") && !"@index".equals(indexKey)) {
                        containerKey = activeContext.uriCompaction().vocab(true).compact(activeContext.uriExpansion().expand(indexKey));
                        if (JsonUtils.isObject(compactedItem) && compactedItem.asJsonObject().containsKey((Object)containerKey)) {
                            JsonValue containerValue = (JsonValue)compactedItem.asJsonObject().get((Object)containerKey);
                            if (JsonUtils.isString(containerValue)) {
                                mapKey = ((JsonString)containerValue).getString();
                                compactedItem = Json.createObjectBuilder((JsonObject)compactedItem.asJsonObject()).remove(containerKey).build();
                            } else if (JsonUtils.isArray(containerValue) && !JsonUtils.isEmptyArray(containerValue)) {
                                mapKey = containerValue.asJsonArray().getString(0);
                                if (containerValue.asJsonArray().size() > 1) {
                                    Object containerKeyValue = null;
                                    containerKeyValue = containerValue.asJsonArray().size() == 2 ? (JsonValue)containerValue.asJsonArray().get(1) : Json.createArrayBuilder((JsonArray)containerValue.asJsonArray()).remove(0).build();
                                    compactedItem = Json.createObjectBuilder((JsonObject)compactedItem.asJsonObject()).remove(containerKey).add(containerKey, containerKeyValue).build();
                                } else {
                                    compactedItem = Json.createObjectBuilder((JsonObject)compactedItem.asJsonObject()).remove(containerKey).build();
                                }
                            }
                        }
                    } else if (container.contains("@id")) {
                        if (JsonUtils.isObject(compactedItem) && compactedItem.asJsonObject().containsKey((Object)containerKey)) {
                            mapKey = compactedItem.asJsonObject().getString(containerKey);
                            compactedItem = Json.createObjectBuilder((JsonObject)compactedItem.asJsonObject()).remove(containerKey).build();
                        }
                    } else if (container.contains("@type")) {
                        String expandedKey;
                        if (JsonUtils.isObject(compactedItem) && compactedItem.asJsonObject().containsKey((Object)containerKey)) {
                            JsonValue compactedKeyValue = (JsonValue)compactedItem.asJsonObject().get((Object)containerKey);
                            if (JsonUtils.isNotNull(compactedKeyValue)) {
                                JsonArray compactedKeyArray = JsonUtils.toJsonArray(compactedKeyValue);
                                mapKey = compactedKeyArray.getString(0);
                                if (compactedKeyArray.size() > 1) {
                                    Object compactedKeyArrayValue = null;
                                    compactedKeyArrayValue = compactedKeyArray.size() == 2 ? (JsonValue)compactedKeyArray.get(1) : Json.createArrayBuilder((JsonArray)compactedKeyArray).remove(0).build();
                                    compactedItem = Json.createObjectBuilder((JsonObject)compactedItem.asJsonObject()).remove(containerKey).add(containerKey, compactedKeyArrayValue).build();
                                } else {
                                    compactedItem = Json.createObjectBuilder((JsonObject)compactedItem.asJsonObject()).remove(containerKey).build();
                                }
                            } else {
                                compactedItem = Json.createObjectBuilder((JsonObject)compactedItem.asJsonObject()).remove(containerKey).build();
                            }
                        }
                        if (JsonUtils.isObject(compactedItem) && compactedItem.asJsonObject().size() == 1 && "@id".equals(expandedKey = activeContext.uriExpansion().vocab(true).expand((String)compactedItem.asJsonObject().keySet().iterator().next()))) {
                            JsonObject map = Json.createObjectBuilder().add("@id", (JsonValue)expandedItem.asJsonObject().get((Object)"@id")).build();
                            compactedItem = Compaction.with(activeContext).compact(itemActiveProperty, (JsonValue)map);
                        }
                    }
                    if (mapKey == null) {
                        mapKey = activeContext.uriCompaction().vocab(true).compact("@none");
                    }
                    nestResult.getMapBuilder(itemActiveProperty).add(mapKey, compactedItem, asArray);
                } else {
                    nestResult.add(itemActiveProperty, compactedItem, asArray);
                }
                if (nestResult == null || nestResultKey == null) continue;
                result3.put(nestResultKey, nestResult);
            }
        }
        return result3.build();
    }
}

