/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.query.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.eclipse.lyo.core.query.NestedProperty;
import org.eclipse.lyo.core.query.Property;
import org.eclipse.lyo.core.query.impl.PropertiesInvocationHandler;
import org.eclipse.lyo.core.query.impl.PropertyInvocationHandler;

class NestedPropertyInvocationHandler
extends PropertyInvocationHandler {
    private final Tree tree;
    private List<Property> children = null;

    public NestedPropertyInvocationHandler(Tree tree, Map<String, String> prefixMap) {
        super((CommonTree)tree.getChild(0).getChild(0), Property.Type.NESTED_PROPERTY, prefixMap, tree.getChild(0).getType() == 25);
        this.tree = tree;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        boolean isChildren = methodName.equals("children");
        if (!isChildren && !methodName.equals("toString")) {
            return super.invoke(proxy, method, args);
        }
        if (isChildren && this.children != null) {
            return this.children;
        }
        this.children = PropertiesInvocationHandler.createChildren((CommonTree)this.tree.getChild(1), this.prefixMap);
        if (isChildren) {
            return this.children;
        }
        NestedProperty nestedProperty = (NestedProperty)proxy;
        StringBuffer buffer = new StringBuffer();
        buffer.append(nestedProperty.isWildcard() ? "*" : nestedProperty.identifier().toString());
        buffer.append('{');
        PropertiesInvocationHandler.childrenToString(buffer, this.children);
        buffer.append('}');
        return buffer.toString();
    }
}

