/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.java.definition;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.util.Ranges;
import org.eclipse.lsp4mp.commons.MicroProfileDefinition;
import org.eclipse.lsp4mp.jdt.core.java.definition.IJavaDefinitionParticipant;
import org.eclipse.lsp4mp.jdt.core.java.definition.JavaDefinitionContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public abstract class AbstractAnnotationDefinitionParticipant
implements IJavaDefinitionParticipant {
    private final String annotationName;
    private final String annotationMemberName;

    public AbstractAnnotationDefinitionParticipant(String annotationName, String annotationMemberName) {
        this.annotationName = annotationName;
        this.annotationMemberName = annotationMemberName;
    }

    @Override
    public boolean isAdaptedForDefinition(JavaDefinitionContext context, IProgressMonitor monitor) throws JavaModelException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, this.annotationName) != null;
    }

    @Override
    public List<MicroProfileDefinition> collectDefinitions(JavaDefinitionContext context, IProgressMonitor monitor) throws CoreException {
        ITypeRoot typeRoot = context.getTypeRoot();
        IJavaProject javaProject = typeRoot.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        IJavaElement hyperlinkedElement = context.getHyperlinkedElement();
        if (!this.isAdaptableFor(hyperlinkedElement)) {
            return null;
        }
        Position definitionPosition = context.getHyperlinkedPosition();
        IAnnotation annotation = AnnotationUtils.getAnnotation((IAnnotatable)hyperlinkedElement, this.annotationName);
        if (annotation == null) {
            return null;
        }
        String annotationSource = annotation.getSource();
        String annotationMemberValue = AnnotationUtils.getAnnotationMemberValue(annotation, this.annotationMemberName);
        if (annotationMemberValue == null) {
            return null;
        }
        ISourceRange r = annotation.getSourceRange();
        int offset = annotationSource.indexOf(annotationMemberValue);
        IJDTUtils utils = context.getUtils();
        Range annotationMemberValueRange = utils.toRange((IOpenable)typeRoot, r.getOffset() + offset, annotationMemberValue.length());
        if (definitionPosition.equals((Object)annotationMemberValueRange.getEnd()) || !Ranges.containsPosition((Range)annotationMemberValueRange, (Position)definitionPosition)) {
            return null;
        }
        return this.collectDefinitions(annotationMemberValue, annotationMemberValueRange, annotation, context, monitor);
    }

    protected boolean isAdaptableFor(IJavaElement hyperlinkedElement) {
        return hyperlinkedElement.getElementType() == 8 || hyperlinkedElement.getElementType() == 14;
    }

    protected abstract List<MicroProfileDefinition> collectDefinitions(String var1, Range var2, IAnnotation var3, JavaDefinitionContext var4, IProgressMonitor var5) throws JavaModelException;
}

