/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4jakarta.jdt.core.IProjectLabelProvider;

public class ProjectLabelDefinition {
    private static final Logger LOGGER = Logger.getLogger(ProjectLabelDefinition.class.getName());
    private final IProjectLabelProvider projectLabelProvider;

    public ProjectLabelDefinition(IProjectLabelProvider projectLabelProvider) {
        this.projectLabelProvider = projectLabelProvider;
    }

    public List<String> getProjectLabels(IJavaProject project) {
        try {
            return this.projectLabelProvider.getProjectLabels(project);
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting project labels", e);
            return Collections.emptyList();
        }
    }
}

