/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.servlet;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.TypeHierarchyUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.internal.servlet.ErrorCode;

public class ServletDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IType[] alltypes;
        String uri = context.getUri();
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit == null) {
            return diagnostics;
        }
        IType[] iTypeArray = alltypes = unit.getAllTypes();
        int n = alltypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            IAnnotation[] allAnnotations = type.getAnnotations();
            IAnnotation webServletAnnotation = null;
            IAnnotation[] iAnnotationArray = allAnnotations;
            int n3 = allAnnotations.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation = iAnnotationArray[n4];
                if (DiagnosticUtils.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.servlet.annotation.WebServlet")) {
                    webServletAnnotation = annotation;
                    break;
                }
                ++n4;
            }
            if (webServletAnnotation != null) {
                Range range;
                try {
                    int r = TypeHierarchyUtils.doesITypeHaveSuperType(type, "HttpServlet");
                    if (r == -1) {
                        Range range2 = PositionUtils.toNameRange(type, context.getUtils());
                        diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("WebServletMustExtend", new Object[0]), range2, "jakarta-servlet", null, ErrorCode.WebServletAnnotatedClassDoesNotExtendHttpServlet, DiagnosticSeverity.Error));
                    } else if (r == 0) {
                        Range range3 = PositionUtils.toNameRange(type, context.getUtils());
                        diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("WebServletMustExtend", new Object[0]), range3, "jakarta-servlet", null, ErrorCode.WebServletAnnotatedClassUnknownSuperTypeDoesNotExtendHttpServlet, DiagnosticSeverity.Warning));
                    }
                }
                catch (CoreException e) {
                    JakartaCorePlugin.logException("Cannot check type hierarchy", e);
                }
                IMemberValuePair[] memberValues = webServletAnnotation.getMemberValuePairs();
                boolean isUrlpatternSpecified = false;
                boolean isValueSpecified = false;
                IMemberValuePair[] iMemberValuePairArray = memberValues;
                int n5 = memberValues.length;
                int n6 = 0;
                while (n6 < n5) {
                    IMemberValuePair mv = iMemberValuePairArray[n6];
                    if (mv.getMemberName().equals("urlPatterns")) {
                        isUrlpatternSpecified = true;
                    } else if (mv.getMemberName().equals("value")) {
                        isValueSpecified = true;
                    }
                    ++n6;
                }
                if (!isUrlpatternSpecified && !isValueSpecified) {
                    range = PositionUtils.toNameRange(webServletAnnotation, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("WebServletMustDefine", new Object[0]), range, "jakarta-servlet", null, ErrorCode.WebServletAnnotationMissingAttributes, DiagnosticSeverity.Error));
                }
                if (isUrlpatternSpecified && isValueSpecified) {
                    range = PositionUtils.toNameRange(webServletAnnotation, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("WebServletCannotHaveBoth", new Object[0]), range, "jakarta-servlet", null, ErrorCode.WebServletAnnotationAttributeConflict, DiagnosticSeverity.Error));
                }
            }
            ++n2;
        }
        return diagnostics;
    }
}

