/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.ASTRewriteCorrectionProposal;

public class AddConstructorProposal
extends ASTRewriteCorrectionProposal {
    private final CompilationUnit invocationNode;
    private final IBinding binding;
    private final String visibility;

    public AddConstructorProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance) {
        super(label, "quickfix", targetCU, (ASTRewrite)null, relevance);
        this.invocationNode = invocationNode;
        this.binding = binding;
        this.visibility = "protected";
    }

    public AddConstructorProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance, String visibility) {
        super(label, "quickfix", targetCU, (ASTRewrite)null, relevance);
        this.invocationNode = invocationNode;
        this.binding = binding;
        this.visibility = visibility;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        ASTNode declNode = null;
        ASTNode boundNode = this.invocationNode.findDeclaringNode(this.binding);
        CompilationUnit newRoot = this.invocationNode;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            newRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.binding.getKey());
        }
        AST ast = declNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ListRewrite list = rewrite.getListRewrite(declNode, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        MethodDeclaration md = ast.newMethodDeclaration();
        SimpleName name = ast.newSimpleName(declNode.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.NAME_PROPERTY).toString());
        Block methodBody = ast.newBlock();
        List modifiers = md.modifiers();
        modifiers.add(ast.newModifier(Modifier.ModifierKeyword.toKeyword((String)this.visibility)));
        md.setName(name);
        md.setConstructor(true);
        md.setBody(methodBody);
        list.insertFirst((ASTNode)md, null);
        return rewrite;
    }
}

