/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4jakarta.commons.JakartaDiagnosticsParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.jdt.codeAction.CodeActionHandler;
import org.eclipse.lsp4jakarta.jdt.core.DiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.annotations.AnnotationDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.beanvalidation.BeanValidationDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.cdi.ManagedBeanDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.di.DependencyInjectionDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.jax_rs.Jax_RSClassDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.jax_rs.ResourceMethodDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.jsonb.JsonbDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.jsonp.JsonpDiagnosticCollector;
import org.eclipse.lsp4jakarta.jdt.core.persistence.PersistenceEntityDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.persistence.PersistenceMapKeyDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.servlet.FilterDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.servlet.ListenerDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.servlet.ServletDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.websocket.WebSocketDiagnosticsCollector;

public class JDTServicesManager {
    private List<DiagnosticsCollector> diagnosticsCollectors = new ArrayList<DiagnosticsCollector>();
    private static final JDTServicesManager INSTANCE = new JDTServicesManager();
    private final CodeActionHandler codeActionHandler;

    public static JDTServicesManager getInstance() {
        return INSTANCE;
    }

    private JDTServicesManager() {
        this.diagnosticsCollectors.add(new ServletDiagnosticsCollector());
        this.diagnosticsCollectors.add(new AnnotationDiagnosticsCollector());
        this.diagnosticsCollectors.add(new FilterDiagnosticsCollector());
        this.diagnosticsCollectors.add(new ListenerDiagnosticsCollector());
        this.diagnosticsCollectors.add(new BeanValidationDiagnosticsCollector());
        this.diagnosticsCollectors.add(new PersistenceEntityDiagnosticsCollector());
        this.diagnosticsCollectors.add(new PersistenceMapKeyDiagnosticsCollector());
        this.diagnosticsCollectors.add(new ResourceMethodDiagnosticsCollector());
        this.diagnosticsCollectors.add(new Jax_RSClassDiagnosticsCollector());
        this.diagnosticsCollectors.add(new JsonbDiagnosticsCollector());
        this.diagnosticsCollectors.add(new ManagedBeanDiagnosticsCollector());
        this.diagnosticsCollectors.add(new DependencyInjectionDiagnosticsCollector());
        this.diagnosticsCollectors.add(new JsonpDiagnosticCollector());
        this.diagnosticsCollectors.add(new WebSocketDiagnosticsCollector());
        this.codeActionHandler = new CodeActionHandler();
    }

    public List<PublishDiagnosticsParams> getJavaDiagnostics(JakartaDiagnosticsParams javaParams) {
        return this.getJavaDiagnostics(javaParams.getUris(), (IProgressMonitor)new NullProgressMonitor());
    }

    public List<PublishDiagnosticsParams> getJavaDiagnostics(List<String> uris, IProgressMonitor monitor) {
        if (uris == null) {
            return Collections.emptyList();
        }
        ArrayList<PublishDiagnosticsParams> publishDiagnostics = new ArrayList<PublishDiagnosticsParams>();
        for (String uri : uris) {
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            URI u = JDTUtils.toURI(uri);
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit(u);
            for (DiagnosticsCollector d : this.diagnosticsCollectors) {
                if (monitor.isCanceled()) break;
                d.collectDiagnostics(unit, diagnostics);
            }
            PublishDiagnosticsParams publishDiagnostic = new PublishDiagnosticsParams(uri, diagnostics);
            publishDiagnostics.add(publishDiagnostic);
            if (!monitor.isCanceled()) continue;
            return Collections.emptyList();
        }
        return publishDiagnostics;
    }

    public List<String> getExistingContextsFromClassPath(String uri, List<String> snippetContexts) {
        ArrayList<String> classpath = new ArrayList<String>();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(JDTUtils.toURI(uri));
        IJavaProject project = unit.getJavaProject();
        if (project != null) {
            snippetContexts.forEach(ctx -> {
                IType classPathctx = null;
                try {
                    classPathctx = project.findType(ctx);
                    if (classPathctx != null) {
                        classpath.add((String)ctx);
                    } else {
                        classpath.add(null);
                    }
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.logException((String)"Failed to retrieve projectContext from JDT...", (Throwable)e);
                    classpath.add(null);
                }
            });
        } else {
            snippetContexts.forEach(ctx -> classpath.add(null));
        }
        String className = unit.getElementName();
        if (className.endsWith(".java")) {
            className = className.substring(0, className.length() - 5);
        }
        String packageName = unit.getParent() != null ? unit.getParent().getElementName() : "";
        classpath.add(packageName);
        classpath.add(className);
        return classpath;
    }

    public List<CodeAction> getCodeAction(JakartaJavaCodeActionParams params, JDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        return this.codeActionHandler.codeAction(params, utils, monitor);
    }
}

