/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.annotations;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaDiagnosticsParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.jdt.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.JakartaForJavaAssert;
import org.junit.Test;

public class PreDestroyAnnotationTest
extends BaseJakartaTest {
    protected static JDTUtils JDT_UTILS = new JDTUtils();

    @Test
    public void GeneratedAnnotation() throws Exception {
        IJavaProject javaProject = PreDestroyAnnotationTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/annotations/PreDestroyAnnotation.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaDiagnosticsParams diagnosticsParams = new JakartaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(20, 16, 28, "A method with the annotation @PreDestroy must not have any parameters.", DiagnosticSeverity.Error, "jakarta-annotations", "PreDestroyParams");
        Diagnostic d2 = JakartaForJavaAssert.d(26, 20, 31, "A method with the annotation @PreDestroy must not be static.", DiagnosticSeverity.Error, "jakarta-annotations", "PreDestroyStatic");
        d2.setData((Object)9);
        Diagnostic d3 = JakartaForJavaAssert.d(31, 13, 25, "A method with the annotation @PreDestroy must not throw checked exceptions.", DiagnosticSeverity.Warning, "jakarta-annotations", "PreDestroyException");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, JDT_UTILS, d2, d1, d3);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te = JakartaForJavaAssert.te(19, 1, 20, 1, "");
        TextEdit te1 = JakartaForJavaAssert.te(20, 29, 20, 40, "");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Remove @PreDestroy", d1, te);
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Remove all parameters", d1, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, JDT_UTILS, ca, ca1);
        JakartaJavaCodeActionParams codeActionParams1 = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        TextEdit te2 = JakartaForJavaAssert.te(25, 1, 26, 1, "");
        TextEdit te3 = JakartaForJavaAssert.te(26, 7, 26, 14, "");
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Remove @PreDestroy", d2, te2);
        CodeAction ca3 = JakartaForJavaAssert.ca(uri, "Remove the 'static' modifier from this method", d2, te3);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams1, JDT_UTILS, ca2, ca3);
    }
}

