/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.viewpoint;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallbackWithConfimation;
import org.eclipse.sirius.ui.business.internal.viewpoint.ViewpointSelectionDialog;
import org.eclipse.sirius.ui.tools.internal.viewpoint.ViewpointHelper;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public final class ViewpointSelection {
    private static final String VIEWPOINT_SELECTION_WIZARD_PAGE_TITLE = Messages.ViewpointSelection_wizardTitle;
    private static final String VIEWPOINTS_SELECTION_WIZARD_PAGE_ID = "viewpointsSelection";
    private static final String[] COLUMNS = new String[]{" ", Messages.ViewpointSelection_iconColumn, Messages.ViewpointSelection_viewpointColumn};

    private ViewpointSelection() {
    }

    public static Set<Viewpoint> getViewpoints(final String fileExtension) {
        Predicate<Viewpoint> isValidViewpoint = new Predicate<Viewpoint>(){

            public boolean apply(Viewpoint viewpoint) {
                return new ViewpointQuery(viewpoint).handlesSemanticModelExtension(fileExtension != null ? fileExtension : "*");
            }
        };
        Set allViewpoints = ViewpointRegistry.getInstance().getViewpoints();
        HashSet<Viewpoint> validViewpoints = new HashSet<Viewpoint>();
        validViewpoints.addAll(Collections2.filter((Collection)allViewpoints, (Predicate)isValidViewpoint));
        return validViewpoints;
    }

    private static Set<Viewpoint> getViewpoints(Collection<String> fileExtensions) {
        TreeSet<Viewpoint> validViewpoints = new TreeSet<Viewpoint>((Comparator<Viewpoint>)new ViewpointRegistry.ViewpointComparator());
        for (String extension : fileExtensions) {
            validViewpoints.addAll(ViewpointSelection.getViewpoints(extension));
        }
        return validViewpoints;
    }

    private static Collection<String> getSemanticFileExtensions(Session session) {
        HashSet<String> fileExtensions = new HashSet<String>();
        for (Resource resource : session.getSemanticResources()) {
            String currentFileExtension;
            if (resource == null || resource.getURI() == null || (currentFileExtension = resource.getURI().fileExtension()) == null) continue;
            fileExtensions.add(currentFileExtension);
        }
        return fileExtensions;
    }

    public static WizardPage createWizardPage(String fileExtension, final SortedMap<Viewpoint, Boolean> viewpointsMap) {
        TreeSet<Viewpoint> viewpoints = new TreeSet<Viewpoint>((Comparator<Viewpoint>)new ViewpointRegistry.ViewpointComparator());
        viewpoints.addAll(ViewpointSelection.getViewpoints(fileExtension));
        for (Viewpoint viewpoint : viewpoints) {
            viewpointsMap.put(viewpoint, Boolean.FALSE);
        }
        WizardPage page = new WizardPage(VIEWPOINTS_SELECTION_WIZARD_PAGE_ID, VIEWPOINT_SELECTION_WIZARD_PAGE_TITLE, null){

            public void createControl(Composite parent) {
                this.setControl(ViewpointSelection.createViewpointsTableControl(parent, this.getContainer(), viewpointsMap));
            }

            private boolean isThereOneSelectedViewpoint() {
                return Maps.filterValues((SortedMap)viewpointsMap, (Predicate)new Predicate<Boolean>(){

                    public boolean apply(Boolean input) {
                        return input;
                    }
                }).entrySet().iterator().hasNext();
            }

            public boolean isPageComplete() {
                return super.isPageComplete() && this.isThereOneSelectedViewpoint();
            }
        };
        return page;
    }

    private static Control createViewpointsTableControl(Composite parent, IWizardContainer wizardContainer, Map<Viewpoint, Boolean> viewpoints) {
        return ViewpointSelection.createViewpointsTableControl(parent, viewpoints.keySet(), new WizardViewpointsTableLazyCellModifier(viewpoints, wizardContainer), (IBaseLabelProvider)new ViewpointsTableLabelProvider(viewpoints));
    }

    public static WizardPage createWizardPage(IFile semanticModel, SortedMap<Viewpoint, Boolean> viewpointsMap) {
        String semanticExtension = null;
        if (semanticModel != null) {
            semanticExtension = semanticModel.getFileExtension();
        }
        return ViewpointSelection.createWizardPage(semanticExtension, viewpointsMap);
    }

    public static void openViewpointsSelectionDialog(Session session) {
        ViewpointSelection.openViewpointsSelectionDialog(session, true);
    }

    public static void openViewpointsSelectionDialog(Session session, boolean createNewRepresentations) {
        session.getSemanticCrossReferencer();
        SortedMap<Viewpoint, Boolean> viewpointsMap = ViewpointSelection.getViewpointsWithMonitor(session);
        ViewpointSelectionDialog vsd = new ViewpointSelectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), viewpointsMap);
        if (vsd.open() == 0) {
            ViewpointHelper.applyNewViewpointSelection(viewpointsMap, vsd.getSelection(), session, createNewRepresentations, new ViewpointSelectionCallbackWithConfimation());
        }
    }

    public static String getMissingDependenciesErrorMessage(Map<String, Collection<String>> missingDependencies) {
        Function<Collection<String>, String> toStringList = new Function<Collection<String>, String>(){

            public String apply(Collection<String> from) {
                return Joiner.on((String)", ").join(from);
            }
        };
        StringBuilder sb = new StringBuilder(Messages.ViewpointSelection_missingDependencies_header).append("\n");
        ArrayList<String> lines = new ArrayList<String>();
        for (Map.Entry<String, Collection<String>> entry : missingDependencies.entrySet()) {
            lines.add("- " + MessageFormat.format(Messages.ViewpointSelection_missingDependencies_requirements, entry.getKey(), toStringList.apply(entry.getValue())));
        }
        sb.append(Joiner.on((String)"\n").join(lines));
        return sb.toString();
    }

    public static Map<String, Collection<String>> getMissingDependencies(Set<Viewpoint> selected) {
        HashSet selectedURIs = Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform(selected, (Function)new Function<Viewpoint, String>(){

            public String apply(Viewpoint from) {
                Option uri = new ViewpointQuery(from).getViewpointURI();
                if (uri.some()) {
                    return ((URI)uri.get()).toString();
                }
                return null;
            }
        }), (Predicate)Predicates.notNull()));
        HashMultimap result = HashMultimap.create();
        for (Viewpoint viewpoint : selected) {
            for (RepresentationExtensionDescription extension : new ViewpointQuery(viewpoint).getAllRepresentationExtensionDescriptions()) {
                String extended = extension.getViewpointURI();
                Pattern pattern = Pattern.compile(extended);
                if (ViewpointHelper.atLeastOneUriMatchesPattern(selectedURIs, pattern)) continue;
                result.put((Object)viewpoint.getName(), (Object)extended.trim().replaceFirst("^viewpoint:/[^/]+/", ""));
            }
        }
        return result.asMap();
    }

    private static SortedMap<Viewpoint, Boolean> getViewpointsWithMonitor(final Session session) {
        final TreeSet allViewpoints = new TreeSet(new ViewpointRegistry.ViewpointComparator());
        final TreeMap<Viewpoint, Boolean> viewpointsMap = new TreeMap<Viewpoint, Boolean>((Comparator<Viewpoint>)new ViewpointRegistry.ViewpointComparator());
        IProgressService ps = PlatformUI.getWorkbench().getProgressService();
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) {
                    pm.beginTask(Messages.ViewpointSelection_loadingViewpointsTask, 4);
                    Collection semanticFileExtensions = ViewpointSelection.getSemanticFileExtensions(session);
                    pm.worked(1);
                    Set viewpoints = ViewpointSelection.getViewpoints(semanticFileExtensions);
                    pm.worked(1);
                    allViewpoints.addAll(viewpoints);
                    pm.worked(1);
                    Collection selectedViewpoints = session.getSelectedViewpoints(false);
                    for (Viewpoint viewpoint : allViewpoints) {
                        boolean selected = false;
                        for (Viewpoint selectedViewpoint : selectedViewpoints) {
                            if (!EqualityHelper.areEquals((EObject)selectedViewpoint, (EObject)viewpoint)) continue;
                            selected = true;
                            break;
                        }
                        viewpointsMap.put(viewpoint, selected);
                    }
                    pm.done();
                }
            });
            return viewpointsMap;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Control createViewpointsTableControl(Composite parent, Set<Viewpoint> viewpoints, TableViewerAwareCellModifier cellModifier, IBaseLabelProvider labelProvider) {
        Composite control = SWTUtil.createCompositeBothFill((Composite)parent, (int)1, (boolean)false);
        TableViewer tableViewer = new TableViewer(control, 67584);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
        Table table = tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn tc0 = new TableColumn(table, 0x1000000, 0);
        tc0.setWidth(30);
        TableColumn tc1 = new TableColumn(table, 0x1000000, 1);
        tc1.setWidth(30);
        TableViewerColumn column = new TableViewerColumn(tableViewer, 16384, 2);
        column.getColumn().setWidth(450);
        table.setSize(new Point(table.getSize().x, 510));
        CellEditor[] editors = new CellEditor[3];
        editors[0] = new CheckboxCellEditor((Composite)table);
        int i = 1;
        while (i < 3) {
            editors[i] = null;
            ++i;
        }
        tableViewer.setColumnProperties(COLUMNS);
        tableViewer.setCellEditors(editors);
        cellModifier.setViewer(tableViewer);
        tableViewer.setCellModifier((ICellModifier)cellModifier);
        tableViewer.setContentProvider((IContentProvider)new ViewpointsTableContentProvider());
        tableViewer.setLabelProvider(labelProvider);
        tableViewer.setComparator(new ViewerComparator());
        tableViewer.setInput(viewpoints);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        return control;
    }

    private static abstract class AbstractViewpointsTableCellModifier
    implements TableViewerAwareCellModifier {
        protected TableViewer tableViewer;
        protected final Map<Viewpoint, Boolean> viewpoints;

        AbstractViewpointsTableCellModifier(Map<Viewpoint, Boolean> viewpoints) {
            this.viewpoints = viewpoints;
        }

        @Override
        public void setViewer(TableViewer viewer) {
            this.tableViewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return property.equals(COLUMNS[0]);
        }
    }

    public static interface Callback {
        public void selectViewpoint(Viewpoint var1, Session var2, IProgressMonitor var3);

        public void selectViewpoint(Viewpoint var1, Session var2, boolean var3, IProgressMonitor var4);

        default public void selectViewpoint(Viewpoint viewpoint, Session session, boolean createNewRepresentations, Set<Viewpoint> allSelectedViewpoint, IProgressMonitor monitor) {
            this.selectViewpoint(viewpoint, session, createNewRepresentations, monitor);
        }

        public void deselectViewpoint(Viewpoint var1, Session var2, IProgressMonitor var3);

        default public void deselectViewpoint(Viewpoint deselectedViewpoint, Session session, Set<Viewpoint> allDeselectedViewpoint, IProgressMonitor monitor) {
            this.deselectViewpoint(deselectedViewpoint, session, monitor);
        }
    }

    private static interface TableViewerAwareCellModifier
    extends ICellModifier {
        public void setViewer(TableViewer var1);
    }

    private static final class ViewpointsTableContentProvider
    implements IStructuredContentProvider {
        private ViewpointsTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Set) {
                Set viewpoints = (Set)inputElement;
                return viewpoints.toArray();
            }
            return Collections.EMPTY_LIST.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static final class ViewpointsTableLabelProvider
    extends ColumnLabelProvider {
        private final Map<Viewpoint, Boolean> viewpoints;
        private int columnIndex;

        ViewpointsTableLabelProvider(Map<Viewpoint, Boolean> viewpoints) {
            this.viewpoints = viewpoints;
        }

        private boolean findViewpoint(Viewpoint vp) {
            for (Map.Entry<Viewpoint, Boolean> entry : this.viewpoints.entrySet()) {
                if (!EqualityHelper.areEquals((EObject)((EObject)entry.getKey()), (EObject)vp) || !entry.getValue().booleanValue()) continue;
                return true;
            }
            return false;
        }

        public Image getImage(Object element) {
            Image image = null;
            switch (this.columnIndex) {
                case 0: {
                    if (!(element instanceof Viewpoint)) break;
                    Viewpoint vp = (Viewpoint)element;
                    image = SiriusEditPlugin.getPlugin().getBundledImage("/icons/full/others/checkbox_inactive.gif");
                    if (!this.findViewpoint(vp)) break;
                    image = SiriusEditPlugin.getPlugin().getBundledImage("/icons/full/others/checkbox_active.gif");
                    break;
                }
                case 1: {
                    if (!(element instanceof Viewpoint)) break;
                    Viewpoint vp = (Viewpoint)element;
                    image = ViewpointHelper.getImage(vp);
                    break;
                }
                case 2: {
                    break;
                }
            }
            return image;
        }

        public String getText(Object element) {
            switch (this.columnIndex) {
                case 2: {
                    if (!(element instanceof Viewpoint)) break;
                    return MessageTranslator.INSTANCE.getMessage((EObject)((Viewpoint)element), new IdentifiedElementQuery((IdentifiedElement)((Viewpoint)element)).getLabel());
                }
            }
            return null;
        }

        public String getToolTipText(Object element) {
            String toolTip = null;
            if (this.columnIndex == 2 && element instanceof Viewpoint) {
                Viewpoint viewpoint = (Viewpoint)element;
                Resource resource = ((Viewpoint)element).eResource();
                if (resource != null) {
                    toolTip = resource.getURI().toString();
                }
                if (viewpoint.getEndUserDocumentation() != null && viewpoint.getEndUserDocumentation().trim().length() > 0) {
                    toolTip = toolTip != null ? String.valueOf(toolTip) + "\n\n" : "";
                    toolTip = String.valueOf(toolTip) + viewpoint.getEndUserDocumentation();
                }
            }
            return toolTip;
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 200;
        }

        public void update(ViewerCell cell) {
            this.columnIndex = cell.getColumnIndex();
            super.update(cell);
        }

        public int getToolTipStyle(Object object) {
            return 8;
        }
    }

    private static class ViewpointsTableLazyCellModifier
    extends AbstractViewpointsTableCellModifier {
        ViewpointsTableLazyCellModifier(Map<Viewpoint, Boolean> viewpoints) {
            super(viewpoints);
        }

        public Object getValue(Object element, String property) {
            Viewpoint viewpoint = (Viewpoint)element;
            Object result = null;
            if (property.equals(COLUMNS[0])) {
                result = Boolean.FALSE;
                for (Map.Entry entry : this.viewpoints.entrySet()) {
                    if (!((Boolean)entry.getValue()).booleanValue() || !EqualityHelper.areEquals((EObject)viewpoint, (EObject)((EObject)entry.getKey()))) continue;
                    result = Boolean.TRUE;
                    break;
                }
            } else if (!property.equals(COLUMNS[1])) {
                result = new IdentifiedElementQuery((IdentifiedElement)viewpoint).getLabel();
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            Object objElement = element instanceof Item ? ((Item)element).getData() : element;
            if (property.equals(COLUMNS[0])) {
                Viewpoint vp = (Viewpoint)objElement;
                Boolean result = Boolean.TRUE.equals(value);
                for (Viewpoint viewpoint : this.viewpoints.keySet()) {
                    if (!EqualityHelper.areEquals((EObject)viewpoint, (EObject)vp)) continue;
                    this.viewpoints.put(viewpoint, result);
                    break;
                }
                this.tableViewer.update((Object)vp, null);
            }
        }
    }

    private static class WizardViewpointsTableLazyCellModifier
    extends ViewpointsTableLazyCellModifier {
        private final IWizardContainer wizardContainer;

        WizardViewpointsTableLazyCellModifier(Map<Viewpoint, Boolean> viewpoints, IWizardContainer wizardContainer) {
            super(viewpoints);
            this.wizardContainer = wizardContainer;
        }

        @Override
        public void modify(Object element, String property, Object value) {
            super.modify(element, property, value);
            if (property.equals(COLUMNS[0])) {
                this.wizardContainer.updateButtons();
            }
        }
    }
}

