/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceConsolePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.progress.WorkbenchJob;

public class JavaStackTraceConsole
extends TextConsole {
    public static final String CONSOLE_TYPE = "javaStackTraceConsole";
    public static final String FILE_NAME = String.valueOf(JDIDebugUIPlugin.getDefault().getStateLocation().toOSString()) + File.separator + "stackTraceConsole.txt";
    private static final String NL = "\n";
    private static final String INDENT_STR = "    ";
    private static final int INDENT_WIDTH = 4;
    private JavaStackTraceConsolePartitioner partitioner = new JavaStackTraceConsolePartitioner();
    private IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("org.eclipse.debug.ui.consoleFont")) {
                JavaStackTraceConsole.this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
            }
        }
    };
    boolean showsUsageHint = false;
    private final IDocumentListener documentsFirstChangeListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            event.getDocument().removeDocumentListener(JavaStackTraceConsole.this.documentsFirstChangeListener);
            JavaStackTraceConsole.this.showsUsageHint = false;
        }
    };

    public JavaStackTraceConsole() {
        super(ConsoleMessages.JavaStackTraceConsoleFactory_0, CONSOLE_TYPE, JavaDebugImages.getImageDescriptor("IMG_JAVA_STACKTRACE_CONSOLE"), true);
        Font font = JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont");
        this.setFont(font);
        this.partitioner.connect(this.getDocument());
    }

    public void initializeDocument() {
        File file = new File(FILE_NAME);
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));){
                    int fileLength = (int)file.length();
                    byte[] fileContent = new byte[fileLength];
                    int bufIndex = 0;
                    int read = 0;
                    while (bufIndex < fileContent.length) {
                        read = ((InputStream)fin).read(fileContent, bufIndex, fileContent.length - bufIndex);
                        if (read < 0) break;
                        bufIndex += read;
                    }
                    this.getDocument().set(new String(fileContent, 0, bufIndex));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.getDocument().set(NLS.bind((String)ConsoleMessages.JavaStackTraceConsole_2, (Object)e.getMessage()));
            }
        } else {
            this.getDocument().set(ConsoleMessages.JavaStackTraceConsole_0);
            this.getDocument().addDocumentListener(this.documentsFirstChangeListener);
            this.showsUsageHint = true;
        }
    }

    protected void init() {
        JFaceResources.getFontRegistry().addListener(this.propertyListener);
    }

    protected void dispose() {
        this.saveDocument();
        JFaceResources.getFontRegistry().removeListener(this.propertyListener);
        super.dispose();
    }

    public void saveDocument() {
        IDocument document = this.getDocument();
        if (document != null) {
            if (document.getLength() > 0) {
                String contents = document.get();
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (FileOutputStream fout = new FileOutputStream(FILE_NAME);){
                        fout.write(contents.getBytes());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    JDIDebugUIPlugin.log(e);
                }
            } else {
                File file = new File(FILE_NAME);
                file.delete();
            }
        }
    }

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public String getHelpContextId() {
        return IJavaDebugHelpContextIds.STACK_TRACE_CONSOLE;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        return new JavaStackTraceConsolePage(this, view);
    }

    public void format() {
        WorkbenchJob job = new WorkbenchJob(ConsoleMessages.JavaStackTraceConsole_1){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IJobManager jobManager = Job.getJobManager();
                try {
                    jobManager.join((Object)this, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return Status.CANCEL_STATUS;
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                IDocument document = JavaStackTraceConsole.this.getDocument();
                String orig = document.get();
                if (orig != null && orig.length() > 0) {
                    document.set(JavaStackTraceConsole.this.format(orig));
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private String format(String trace) {
        StringTokenizer tokenizer = new StringTokenizer(trace, " \t\n\r\f", true);
        StringBuilder formattedTrace = new StringBuilder(trace.length());
        boolean insideAt = false;
        boolean newLine = true;
        int pendingSpaces = 0;
        boolean antTrace = false;
        int depth = 1;
        HashMap<Integer, Integer> blockDepth = new HashMap<Integer, Integer>(3);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.isEmpty()) continue;
            char c = token.charAt(0);
            switch (c) {
                case ' ': {
                    if (newLine) {
                        ++pendingSpaces;
                        break;
                    }
                    pendingSpaces = 1;
                    break;
                }
                case '\t': {
                    if (newLine) {
                        pendingSpaces += 4;
                        break;
                    }
                    pendingSpaces = 1;
                    break;
                }
                case '\n': 
                case '\f': 
                case '\r': {
                    if (insideAt) {
                        pendingSpaces = 1;
                        break;
                    }
                    pendingSpaces = 0;
                    newLine = true;
                    break;
                }
                default: {
                    if (newLine) {
                        if (c == '\"') {
                            formattedTrace.append("\n\n");
                        } else {
                            if (c == '-' || "...".equals(token)) {
                                this.applyIndentedToken(formattedTrace, depth, token, antTrace);
                                pendingSpaces = 0;
                                break;
                            }
                            if ("at".equals(token)) {
                                insideAt = true;
                                this.applyIndentedToken(formattedTrace, depth, token, antTrace);
                                pendingSpaces = 0;
                                break;
                            }
                            if (c == '[') {
                                if ("[CIRCULAR".equals(token)) {
                                    this.applyIndentedToken(formattedTrace, depth, token, antTrace);
                                    pendingSpaces = 0;
                                    break;
                                }
                                if (antTrace) {
                                    formattedTrace.append(NL);
                                }
                                formattedTrace.append(token);
                                pendingSpaces = 0;
                                antTrace = true;
                                break;
                            }
                            if ("Caused".equals(token)) {
                                depth = 0;
                                for (Map.Entry block : blockDepth.entrySet()) {
                                    if ((Integer)block.getKey() > pendingSpaces || (Integer)block.getValue() <= depth) continue;
                                    depth = (Integer)block.getValue();
                                }
                                this.applyIndentedToken(formattedTrace, depth, token, antTrace);
                                ++depth;
                                pendingSpaces = 0;
                                break;
                            }
                            if ("Suppressed:".equals(token)) {
                                if (depth >= 2) {
                                    --depth;
                                }
                                blockDepth.put(pendingSpaces, depth);
                                this.applyIndentedToken(formattedTrace, depth, token, antTrace);
                                depth = 2;
                                pendingSpaces = 0;
                                break;
                            }
                        }
                        newLine = false;
                    }
                    if (pendingSpaces > 0) {
                        int i = 0;
                        while (i < pendingSpaces) {
                            formattedTrace.append(' ');
                            ++i;
                        }
                        pendingSpaces = 0;
                    }
                    formattedTrace.append(token);
                    insideAt = false;
                }
            }
        }
        return formattedTrace.toString();
    }

    private void applyIndentedToken(StringBuilder formattedTrace, int depth, String token, boolean antTrace) {
        if (antTrace) {
            formattedTrace.append(' ');
        } else {
            formattedTrace.append(NL);
        }
        int i = 0;
        while (i < depth) {
            formattedTrace.append(INDENT_STR);
            ++i;
        }
        formattedTrace.append(token);
    }

    class JavaStackTraceConsolePartitioner
    extends FastPartitioner
    implements IConsoleDocumentPartitioner {
        public JavaStackTraceConsolePartitioner() {
            super((IPartitionTokenScanner)new RuleBasedPartitionScanner(), null);
            JavaStackTraceConsole.this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this);
        }

        public boolean isReadOnly(int offset) {
            return false;
        }

        public StyleRange[] getStyleRanges(int offset, int length) {
            return null;
        }
    }
}

