/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.EventEquality;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.common.java.Maps;

public class EventRefSet
implements Iterable<Expression> {
    protected final Map<EventRefWrapper, EventRefWrapper> eventRefs;
    protected final EventEquality equality;

    public EventRefSet(EventEquality equality) {
        this(Maps.map(), equality);
    }

    public EventRefSet(EventRefSet set) {
        this(Maps.copy(set.eventRefs), set.equality);
    }

    private EventRefSet(Map<EventRefWrapper, EventRefWrapper> eventRefs, EventEquality equality) {
        this.eventRefs = eventRefs;
        this.equality = equality;
    }

    public boolean isEmpty() {
        return this.eventRefs.isEmpty();
    }

    public boolean contains(Expression eventRef) {
        EventRefWrapper wrapper = new EventRefWrapper(eventRef);
        return this.eventRefs.containsKey(wrapper);
    }

    public Expression get(Expression eventRef) {
        EventRefWrapper wrapper = new EventRefWrapper(eventRef);
        EventRefWrapper entry = this.eventRefs.get(wrapper);
        return entry == null ? null : entry.eventRef;
    }

    public Expression add(Expression eventRef) {
        EventRefWrapper wrapper = new EventRefWrapper(eventRef);
        EventRefWrapper prev = this.eventRefs.put(wrapper, wrapper);
        return prev == null ? null : prev.eventRef;
    }

    public Expression remove(Expression eventRef) {
        EventRefWrapper wrapper = new EventRefWrapper(eventRef);
        EventRefWrapper removed = this.eventRefs.remove(wrapper);
        return removed == null ? null : removed.eventRef;
    }

    @Override
    public Iterator<Expression> iterator() {
        return new Iterator<Expression>(){
            private final Iterator<EventRefWrapper> iter;
            {
                this.iter = EventRefSet.this.eventRefs.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Expression next() {
                return this.iter.next().eventRef;
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    private class EventRefWrapper {
        public final Expression eventRef;

        public EventRefWrapper(Expression eventRef) {
            this.eventRef = eventRef;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EventRefWrapper)) {
                return false;
            }
            EventRefWrapper other = (EventRefWrapper)obj;
            return CifEventUtils.areSameEventRefs(this.eventRef, other.eventRef, EventRefSet.this.equality);
        }

        public int hashCode() {
            Expression expr = this.eventRef;
            int hash = 0;
            while (true) {
                CompInstWrapExpression wrap;
                hash *= 2;
                if (expr instanceof TauExpression) {
                    return hash *= 17;
                }
                if (expr instanceof EventExpression) {
                    return hash ^= ((EventExpression)expr).getEvent().hashCode();
                }
                if (expr instanceof CompInstWrapExpression) {
                    wrap = (CompInstWrapExpression)expr;
                    hash ^= wrap.getInstantiation().hashCode();
                    expr = wrap.getReference();
                    continue;
                }
                if (!(expr instanceof CompParamWrapExpression)) break;
                wrap = (CompParamWrapExpression)expr;
                CifType ptype = wrap.getParameter().getType();
                ptype = CifTypeUtils.normalizeType(ptype);
                ComponentDefType cdefType = (ComponentDefType)ptype;
                ComponentDef cdef = cdefType.getDefinition();
                hash ^= cdef.hashCode();
                expr = wrap.getReference();
            }
            String msg = "Unknown event ref expr: " + this.eventRef;
            throw new RuntimeException(msg);
        }
    }
}

