/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.cif2mcrl2.options.GenerateValueActionsOption;
import org.eclipse.escet.cif.cif2mcrl2.storage.AutomatonData;
import org.eclipse.escet.cif.cif2mcrl2.storage.VariableData;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class AutomatonExtractor {
    public List<VariableData> varDatas = null;
    public List<AutomatonData> autDatas = null;

    public void findElements(Specification spec) {
        this.varDatas = Lists.list();
        this.unfoldForVariables((Group)spec);
        Set varNames = Sets.setc((int)this.varDatas.size());
        for (VariableData vd : this.varDatas) {
            varNames.add(vd.name);
        }
        Set<String> valueNames = GenerateValueActionsOption.matchNames(varNames);
        for (VariableData vd : this.varDatas) {
            vd.setValueAction(valueNames.contains(vd.name));
        }
        Map variableMap = Maps.map();
        for (VariableData vd : this.varDatas) {
            variableMap.put(vd.variable, vd);
        }
        this.autDatas = Lists.list();
        this.unfoldForAutomata((Group)spec, variableMap);
    }

    private void unfoldForVariables(Group group) {
        for (Component comp : group.getComponents()) {
            if (comp instanceof Automaton) {
                Automaton aut = (Automaton)comp;
                this.getVariableElements(aut);
                continue;
            }
            Assert.check((boolean)(comp instanceof Group));
            Group g = (Group)comp;
            this.unfoldForVariables(g);
        }
    }

    private void getVariableElements(Automaton aut) {
        for (Declaration decl : aut.getDeclarations()) {
            if (!(decl instanceof DiscVariable)) continue;
            DiscVariable dv = (DiscVariable)decl;
            CifType tp = CifTypeUtils.normalizeType((CifType)dv.getType());
            String initialValue = null;
            try {
                Comparable<Boolean> val;
                if (tp instanceof BoolType) {
                    val = (Boolean)CifEvalUtils.eval((Expression)((Expression)dv.getValue().getValues().get(0)), (boolean)true);
                    initialValue = ((Boolean)val).booleanValue() ? "true" : "false";
                } else {
                    val = (Integer)CifEvalUtils.eval((Expression)((Expression)dv.getValue().getValues().get(0)), (boolean)true);
                    initialValue = ((Integer)val).toString();
                }
            }
            catch (CifEvalException e) {
                Assert.fail((String)"Unexpected eval failure");
            }
            this.varDatas.add(new VariableData(dv, initialValue));
        }
    }

    private void unfoldForAutomata(Group group, Map<DiscVariable, VariableData> variableMap) {
        for (Component comp : group.getComponents()) {
            if (comp instanceof Automaton) {
                Automaton aut = (Automaton)comp;
                this.getAutomatonElements(aut, variableMap);
                continue;
            }
            Assert.check((boolean)(comp instanceof Group));
            Group g = (Group)comp;
            this.unfoldForAutomata(g, variableMap);
        }
    }

    private void getAutomatonElements(Automaton aut, Map<DiscVariable, VariableData> variableMap) {
        Location initialLocation = null;
        for (Location loc : aut.getLocations()) {
            if (loc.getInitials().isEmpty() || !CifValueUtils.isTriviallyTrue((List)loc.getInitials(), (boolean)true, (boolean)true)) continue;
            initialLocation = loc;
            break;
        }
        AutomatonData ad = new AutomatonData(aut, initialLocation);
        ad.addAutomatonVars(variableMap);
        this.autDatas.add(ad);
    }

    public List<AutomatonData> getAutDatas() {
        return this.autDatas;
    }

    private Map<VariableData, Integer> getVarCounts() {
        Map varCounts = Maps.map();
        for (AutomatonData ad : this.autDatas) {
            Iterator<VariableData> iterator = ad.vars.values().iterator();
            while (iterator.hasNext()) {
                VariableData vd;
                Integer c = (Integer)varCounts.get(vd = iterator.next());
                varCounts.put(vd, c == null ? 1 : c + 1);
            }
        }
        return varCounts;
    }

    public Set<VariableData> getSingleUseVariables() {
        Set vds = Sets.set();
        for (Map.Entry<VariableData, Integer> entry : this.getVarCounts().entrySet()) {
            if (entry.getValue() != 1) continue;
            vds.add(entry.getKey());
        }
        return vds;
    }

    public Set<VariableData> getSharedVariables() {
        Set vds = Sets.set();
        for (Map.Entry<VariableData, Integer> entry : this.getVarCounts().entrySet()) {
            if (entry.getValue() <= 1) continue;
            vds.add(entry.getKey());
        }
        return vds;
    }
}

