/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.views.providers.layers;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.util.ImageProvider;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class LayersLabelProvider
extends ColumnLabelProvider {
    private IDiagramWorkbenchPart diagramPart;
    private int columnIndex;

    public LayersLabelProvider(IDiagramWorkbenchPart part) {
        this.diagramPart = part;
    }

    public Image getImage(Object element) {
        Layer layer;
        Image result = null;
        if (this.columnIndex == 0 && this.diagramPart != null) {
            EObject designerElement;
            DiagramEditPart diaEditPart = this.diagramPart.getDiagramEditPart();
            Object obj = diaEditPart.getModel();
            if (obj instanceof View && (designerElement = ((View)obj).getElement()) instanceof DDiagram) {
                List activatedLayers = new DDiagramQuery((DDiagram)designerElement).getAllActivatedLayers();
                Image img = null;
                img = EqualityHelper.contains((Collection)activatedLayers, (EObject)((EObject)element)) ? DiagramUIPlugin.getPlugin().getBundledImage("/icons/layer_active.gif") : DiagramUIPlugin.getPlugin().getBundledImage("/icons/layer_inactive.gif");
                result = img;
            }
        } else if (this.columnIndex == 1 && element instanceof Layer && !StringUtil.isEmpty((String)(layer = (Layer)element).getIcon())) {
            result = ImageProvider.getImageFromPath((String)layer.getIcon());
        }
        return result;
    }

    public String getText(Object element) {
        switch (this.columnIndex) {
            case 2: {
                if (!(element instanceof Layer)) break;
                return new IdentifiedElementQuery((IdentifiedElement)((Layer)element)).getLabel();
            }
        }
        return null;
    }

    public String getToolTipText(Object element) {
        String endUserDoc;
        if (element instanceof Layer && (endUserDoc = ((Layer)element).getEndUserDocumentation()) != null && endUserDoc.trim().length() > 0) {
            return endUserDoc;
        }
        return super.getToolTipText(element);
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 200;
    }

    public int getToolTipStyle(Object object) {
        return 8;
    }

    public void update(ViewerCell cell) {
        this.columnIndex = cell.getColumnIndex();
        super.update(cell);
    }

    public void dispose() {
        super.dispose();
        this.diagramPart = null;
    }
}

