/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.annotations.validation;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.linking.impl.LinkingDiagnosticMessageProvider;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.internal.TypeAwareLinkingDiagnosticContext;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.util.FeatureCallAsTypeLiteralHelper;

public class UnresolvedFeatureCallTypeAwareMessageProvider
extends LinkingDiagnosticMessageProvider {
    public static final String TYPE_LITERAL = "key:TypeLiteral";
    public static final String FEATURE_CALL = "key:FeatureCall";
    @Inject
    private FeatureCallAsTypeLiteralHelper typeLiteralHelper;
    @Inject
    @Extension
    private FeatureLinkHelper _featureLinkHelper;

    public DiagnosticMessage getUnresolvedProxyMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context) {
        String _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = context.getLinkText();
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalNodeException) {
                IllegalNodeException e = (IllegalNodeException)_t;
                _xtrycatchfinallyexpression = e.getNode().getText();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        String linkText = _xtrycatchfinallyexpression;
        if (linkText == null) {
            return null;
        }
        EObject contextObject = context.getContext();
        boolean _isStaticMemberCallTarget = this.isStaticMemberCallTarget(contextObject);
        if (_isStaticMemberCallTarget) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(linkText);
            _builder.append(" cannot be resolved to a type.");
            return new DiagnosticMessage(_builder.toString(), Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[]{TYPE_LITERAL});
        }
        if (contextObject instanceof XAbstractFeatureCall) {
            boolean _not;
            boolean _isOperation = ((XAbstractFeatureCall)contextObject).isOperation();
            boolean bl = _not = !_isOperation;
            if (_not) {
                return this.handleUnresolvedFeatureCall(context, (XAbstractFeatureCall)contextObject, linkText);
            }
        }
        EClass referenceType = context.getReference().getEReferenceType();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(linkText);
        _builder_1.append(" cannot be resolved");
        String _typeName = this.getTypeName(referenceType, (EStructuralFeature)context.getReference());
        _builder_1.append(_typeName);
        _builder_1.append(".");
        String msg = _builder_1.toString();
        return new DiagnosticMessage(msg, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[]{linkText});
    }

    private DiagnosticMessage handleUnresolvedFeatureCall(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context, XAbstractFeatureCall featureCall, String linkText) {
        boolean _isExplicitOperationCallOrBuilderSyntax;
        LightweightTypeReference receiverType = null;
        String args = "";
        if (context instanceof TypeAwareLinkingDiagnosticContext) {
            boolean _tripleNotEquals;
            IResolvedTypes types = ((TypeAwareLinkingDiagnosticContext)context).getResolvedTypes();
            XExpression _syntacticReceiver = this._featureLinkHelper.getSyntacticReceiver(featureCall);
            boolean bl = _tripleNotEquals = _syntacticReceiver != null;
            if (_tripleNotEquals) {
                receiverType = types.getActualType(this._featureLinkHelper.getSyntacticReceiver(featureCall));
            }
            Functions.Function1 _function = it -> types.getActualType((XExpression)it);
            Functions.Function1 _function_1 = it -> {
                String _xifexpression = null;
                _xifexpression = it == null || it.isAny() ? "Object" : it.getHumanReadableName();
                return _xifexpression;
            };
            args = IterableExtensions.join((Iterable)ListExtensions.map(this._featureLinkHelper.getSyntacticArguments(featureCall), (Functions.Function1)_function), (CharSequence)", ", (Functions.Function1)_function_1);
        }
        boolean orField = !(_isExplicitOperationCallOrBuilderSyntax = featureCall.isExplicitOperationCallOrBuilderSyntax());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The method ");
        if (orField) {
            _builder.append("or field ");
            _builder.append(linkText);
        } else {
            _builder.append(linkText);
            _builder.append("(");
            _builder.append(args);
            _builder.append(")");
        }
        _builder.append(" is undefined");
        String msg = _builder.toString();
        if (receiverType != null) {
            String _msg = msg;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(" ");
            _builder_1.append("for the type ");
            String _humanReadableName = receiverType.getHumanReadableName();
            _builder_1.append(_humanReadableName, " ");
            msg = _msg + _builder_1;
        }
        if (featureCall instanceof XFeatureCall && linkText.length() > 0 && Character.isUpperCase(linkText.charAt(0)) && this.typeLiteralHelper.isPotentialTypeLiteral(featureCall, null)) {
            return new DiagnosticMessage(msg, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[]{linkText, TYPE_LITERAL});
        }
        return new DiagnosticMessage(msg, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[]{linkText, FEATURE_CALL});
    }

    protected boolean isStaticMemberCallTarget(EObject contextObject) {
        EObject _eContainer;
        XMemberFeatureCall memberFeatureCall;
        boolean _isExplicitStatic;
        boolean candidate;
        boolean bl = candidate = contextObject instanceof XFeatureCall && contextObject.eContainingFeature() == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET;
        return candidate && (_isExplicitStatic = (memberFeatureCall = (XMemberFeatureCall)(_eContainer = contextObject.eContainer())).isExplicitStatic());
    }

    protected String getTypeName(EClass c, EStructuralFeature referingFeature) {
        if (referingFeature == XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE) {
            return " to an annotation type";
        }
        if (c == TypesPackage.Literals.JVM_ENUMERATION_TYPE) {
            return " to an enum type";
        }
        boolean _isAssignableFrom = EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_TYPE, (EClass)c);
        if (_isAssignableFrom) {
            return " to a type";
        }
        if (c == TypesPackage.Literals.JVM_OPERATION) {
            return " to an operation";
        }
        return "";
    }
}

