/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class PortSideProcessor
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Port side processing", 1.0f);
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            this.process(node);
        }
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                this.process(node);
            }
        }
        monitor.done();
    }

    private void process(LNode node) {
        if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isSideFixed()) {
            for (LPort port : node.getPorts()) {
                if (port.getSide() != PortSide.UNDEFINED) continue;
                PortSideProcessor.setPortSide(port);
            }
        } else {
            for (LPort port : node.getPorts()) {
                PortSideProcessor.setPortSide(port);
            }
            node.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_SIDE);
        }
    }

    public static void setPortSide(LPort port) {
        LNode portDummy = (LNode)((Object)port.getProperty(InternalProperties.PORT_DUMMY));
        if (portDummy != null) {
            port.setSide((PortSide)portDummy.getProperty(InternalProperties.EXT_PORT_SIDE));
        } else if (port.getNetFlow() < 0) {
            port.setSide(PortSide.EAST);
        } else {
            port.setSide(PortSide.WEST);
        }
        if (!port.isAnchorFixed()) {
            KVector portSize = port.getSize();
            KVector portAnchor = port.getAnchor();
            switch (port.getSide()) {
                case NORTH: {
                    portAnchor.x = portSize.x / 2.0;
                    portAnchor.y = 0.0;
                    break;
                }
                case EAST: {
                    portAnchor.x = portSize.x;
                    portAnchor.y = portSize.y / 2.0;
                    break;
                }
                case SOUTH: {
                    portAnchor.x = portSize.x / 2.0;
                    portAnchor.y = portSize.y;
                    break;
                }
                case WEST: {
                    portAnchor.x = 0.0;
                    portAnchor.y = portSize.y / 2.0;
                }
            }
        }
    }
}

