/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.common.java.Assert;

public class CifInvariantUtils {
    private CifInvariantUtils() {
    }

    public static SupKind getSupKind(Invariant inv) {
        if (inv.getSupKind() != SupKind.NONE) {
            return inv.getSupKind();
        }
        SupKind inheritKind = CifInvariantUtils.getInheritableSupKind(inv);
        if (inheritKind != null) {
            return inheritKind;
        }
        return SupKind.NONE;
    }

    public static boolean hasExplicitSupKind(Invariant inv) {
        return inv.getSupKind() != SupKind.NONE;
    }

    public static void makeSupKindExplicit(Invariant inv) {
        if (inv.getSupKind() != SupKind.NONE) {
            return;
        }
        SupKind inheritKind = CifInvariantUtils.getInheritableSupKind(inv);
        if (inheritKind != null) {
            inv.setSupKind(inheritKind);
        }
    }

    public static void makeSupKindImplicit(Invariant inv) {
        if (inv.getSupKind() == SupKind.NONE) {
            return;
        }
        SupKind inheritKind = CifInvariantUtils.getInheritableSupKind(inv);
        if (inheritKind != inv.getSupKind()) {
            return;
        }
        inv.setSupKind(SupKind.NONE);
    }

    public static SupKind getInheritableSupKind(Invariant inv) {
        Invariant obj = inv;
        while (!(obj instanceof ComplexComponent)) {
            obj = obj.eContainer();
        }
        if (obj instanceof Group) {
            return null;
        }
        Assert.check((boolean)(obj instanceof Automaton));
        Automaton aut = (Automaton)obj;
        if (aut.getKind() == SupKind.NONE) {
            return null;
        }
        return aut.getKind();
    }
}

