/**
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.activity.teditor.serializer

import activity.SyncBar
import org.eclipse.lsat.common.graph.directed.editable.SourceReference
import org.eclipse.lsat.common.graph.directed.editable.TargetReference
import org.eclipse.lsat.activity.teditor.services.ActivityGrammarAccess
import com.google.inject.Inject
import org.eclipse.xtext.serializer.ISerializationContext

class ActivitySemanticSequencer extends AbstractActivitySemanticSequencer {
    @Inject ActivityGrammarAccess grammarAccess;

    /**
     * Make sure the right reference syntax is used for sync bars and actions
     * I.m.h.o. XText could have derived this from our syntax definition
     */
    override protected sequence_SourceReference(ISerializationContext context, SourceReference semanticObject) {
        val feeder = createSequencerFeeder(semanticObject)
        if (semanticObject.node instanceof SyncBar) {
            feeder.accept(grammarAccess.sourceReferenceAccess.nodeSyncBarIIDParserRuleCall_1_1_1_0_1, semanticObject.node)
        } else {
            feeder.accept(grammarAccess.sourceReferenceAccess.nodeActionIIDParserRuleCall_1_0_0_1, semanticObject.node)
        }
        feeder.finish()
    }

    /**
     * Make sure the right reference syntax is used for sync bars and actions
     * I.m.h.o. XText could have derived this from our syntax definition
     */
    override protected sequence_TargetReference(ISerializationContext context, TargetReference semanticObject) {
        val feeder = createSequencerFeeder(semanticObject)
        if (semanticObject.node instanceof SyncBar) {
            feeder.accept(grammarAccess.targetReferenceAccess.nodeSyncBarIIDParserRuleCall_1_1_1_0_1, semanticObject.node)
        } else {
            feeder.accept(grammarAccess.targetReferenceAccess.nodeActionIIDParserRuleCall_1_0_0_1, semanticObject.node)
        }
        feeder.finish()
    }
}
