/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.TreeIterable;

public class XMIUtil {
    public static final UUIDCreator uuidCreator = new UUIDCreator();

    public static void assignIds(@NonNull Resource resource, @NonNull IdCreator idCreator, @Nullable IdFilter idFilter) {
        String id;
        if (!(resource instanceof XMLResource)) {
            return;
        }
        XMLResource xmlResource = (XMLResource)resource;
        HashSet<@NonNull String> knownIds = new HashSet<String>(256);
        ArrayList<@NonNull EObject> idLess = new ArrayList<EObject>(100);
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            assert (eObject != null);
            id = xmlResource.getID(eObject);
            if (id != null) {
                knownIds.add(id);
                continue;
            }
            if (idFilter != null && !idFilter.createId(eObject)) continue;
            idLess.add(eObject);
        }
        for (EObject eObject : idLess) {
            id = idCreator.createId(eObject, knownIds);
            if (id == null) continue;
            String uniqueId = id;
            int i = 1;
            while (knownIds.contains(uniqueId)) {
                uniqueId = String.valueOf(id) + '_' + i;
                ++i;
            }
            xmlResource.setID(eObject, uniqueId);
            knownIds.add(uniqueId);
        }
    }

    public static void assignIds(@NonNull Resource resource, @Nullable String xmiIdPrefix) {
        if (xmiIdPrefix == null) {
            xmiIdPrefix = "_";
        }
        XMIUtil.assignIds(resource, new ShortPrefixedIdCreator(xmiIdPrefix), new ExcludedEClassIdFilter(new EClass[]{XMLTypePackage.Literals.ANY_TYPE, EcorePackage.Literals.EGENERIC_TYPE}));
    }

    public static void assignLinearIds(@NonNull Resource resource, @Nullable String xmiIdPrefix) {
        if (xmiIdPrefix == null) {
            xmiIdPrefix = "_";
        }
        XMIUtil.assignIds(resource, new LinearPrefixedIdCreator(xmiIdPrefix), new ExcludedEClassIdFilter(new EClass[]{XMLTypePackage.Literals.ANY_TYPE, EcorePackage.Literals.EGENERIC_TYPE}));
    }

    public static @NonNull Map<Object, Object> createSaveOptions() {
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>();
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("LINE_DELIMITER", "\n");
        saveOptions.put("LINE_WIDTH", 132);
        saveOptions.put("RESOURCE_ENTITY_HANDLER", new IdResourceEntityHandler());
        return saveOptions;
    }

    public static @Nullable Map<@NonNull EObject, @NonNull String> getIds(@NonNull XMLResource xmlResource) {
        HashMap<@NonNull EObject, @NonNull String> eObject2xmiId = null;
        for (EObject eObject : new TreeIterable((Resource)xmlResource)) {
            assert (eObject != null);
            String xmiId = xmlResource.getID(eObject);
            if (xmiId == null) continue;
            if (eObject2xmiId == null) {
                eObject2xmiId = new HashMap<EObject, String>();
            }
            eObject2xmiId.put(eObject, xmiId);
        }
        return eObject2xmiId;
    }

    public static void retainLineWidth(Map<Object, Object> saveOptions, Resource resource) {
        Object lineWidth;
        if (saveOptions != null && resource instanceof XMLResource && (lineWidth = ((XMLResource)resource).getDefaultSaveOptions().get("LINE_WIDTH")) != null) {
            saveOptions.put("LINE_WIDTH", lineWidth);
        }
    }

    public static void setIds(@NonNull XMLResource xmlResource, @NonNull Map<@NonNull EObject, @NonNull String> eObject2xmiId) {
        for (Map.Entry<EObject, String> entry : eObject2xmiId.entrySet()) {
            xmlResource.setID(entry.getKey(), entry.getValue());
        }
    }

    public static class ExcludedEClassIdFilter
    implements IdFilter {
        protected final @NonNull Set<@NonNull EClass> excludedClasses;

        public ExcludedEClassIdFilter(@NonNull EClass[] excludedClasses) {
            this.excludedClasses = new HashSet<EClass>();
            EClass[] eClassArray = excludedClasses;
            int n = excludedClasses.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull EClass excludedClass = eClassArray[n2];
                this.excludedClasses.add(excludedClass);
                ++n2;
            }
        }

        public ExcludedEClassIdFilter(@NonNull Set<@NonNull EClass> excludedClasses) {
            this.excludedClasses = excludedClasses;
        }

        @Override
        public boolean createId(@NonNull EObject eObject) {
            EClass eClass = eObject.eClass();
            for (EClass excludedClass : this.excludedClasses) {
                if (!excludedClass.isSuperTypeOf(eClass)) continue;
                return false;
            }
            return true;
        }
    }

    public static class HierachicalENamedElementIdCreator
    implements IdCreator {
        @Override
        public @Nullable String createId(@NonNull EObject eObject, @NonNull Set<@NonNull String> knownIds) {
            ArrayList<@NonNull String> uriFragmentPath = new ArrayList<String>();
            EObject container = eObject.eContainer();
            while (container != null) {
                String eURIFragmentSegment = ((InternalEObject)container).eURIFragmentSegment((EStructuralFeature)eObject.eContainmentFeature(), eObject);
                uriFragmentPath.add(eURIFragmentSegment);
                eObject = container;
                container = eObject.eContainer();
            }
            StringBuilder result = eObject instanceof ENamedElement ? new StringBuilder(((ENamedElement)eObject).getName()) : new StringBuilder("_" + Integer.toString(eObject.eResource().getContents().indexOf((Object)eObject)));
            ListIterator i = uriFragmentPath.listIterator(uriFragmentPath.size());
            while (i.hasPrevious()) {
                result.append('.');
                result.append((String)i.previous());
            }
            return result.toString();
        }
    }

    public static interface IdCreator {
        public @Nullable String createId(@NonNull EObject var1, @NonNull Set<@NonNull String> var2);
    }

    public static interface IdFilter {
        public boolean createId(@NonNull EObject var1);
    }

    public static class IdResourceEntityHandler
    implements XMLResource.ResourceEntityHandler {
        private Map<String, String> value2name = new HashMap<String, String>();
        private Map<String, String> name2value = new HashMap<String, String>();

        public static void reset(@Nullable Map<?, ?> options) {
            Object resourceEntityHandler;
            if (options != null && (resourceEntityHandler = options.get("RESOURCE_ENTITY_HANDLER")) instanceof XMLResource.ResourceEntityHandler) {
                ((XMLResource.ResourceEntityHandler)resourceEntityHandler).reset();
            }
        }

        public String getEntityName(String entityValue) {
            String entityName = this.value2name.get(entityValue);
            if (entityName == null) {
                entityName = "_" + this.value2name.size();
                this.handleEntity(entityName, entityValue);
            }
            return entityName;
        }

        public Map<String, String> getNameToValueMap() {
            return this.name2value;
        }

        public void handleEntity(String entityName, String entityValue) {
            this.name2value.put(entityName, entityValue);
            this.value2name.put(entityValue, entityName);
        }

        public void reset() {
            this.name2value.clear();
            this.value2name.clear();
        }
    }

    public static class LinearPrefixedIdCreator
    implements IdCreator {
        protected final @NonNull String prefix;
        private int next;

        public LinearPrefixedIdCreator(@NonNull String prefix) {
            this.prefix = prefix;
        }

        @Override
        public @Nullable String createId(@NonNull EObject eObject, @NonNull Set<@NonNull String> knownIds) {
            String id;
            while (knownIds.contains(id = String.valueOf(this.prefix) + ++this.next)) {
            }
            return id;
        }
    }

    public static class ShortPrefixedIdCreator
    implements IdCreator {
        protected final @NonNull String prefix;

        public ShortPrefixedIdCreator(@NonNull String prefix) {
            this.prefix = prefix;
        }

        @Override
        public @Nullable String createId(@NonNull EObject eObject, @NonNull Set<@NonNull String> knownIds) {
            int knownSize = knownIds.size();
            int multiplier = Math.max(10, 10 * knownSize);
            while (true) {
                int tries = 0;
                while (tries < 10) {
                    String id = String.valueOf(this.prefix) + (int)(Math.random() * (double)multiplier);
                    if (!knownIds.contains(id)) {
                        return id;
                    }
                    ++tries;
                }
                multiplier *= 10;
            }
        }
    }

    public static class StructuralENamedElementIdCreator
    implements IdCreator {
        @Override
        public @Nullable String createId(@NonNull EObject eObject, @NonNull Set<@NonNull String> knownIds) {
            StructuralENamedElementIdSwitch idSwitch = new StructuralENamedElementIdSwitch();
            idSwitch.doSwitch(eObject);
            return idSwitch.toString();
        }

        protected static class StructuralENamedElementIdSwitch
        extends EcoreSwitch<Object> {
            private StringBuilder s = null;

            protected StructuralENamedElementIdSwitch() {
            }

            public Object caseEClassifier(EClassifier object) {
                return this.hierarchicalCase((ENamedElement)object, "T-");
            }

            public Object caseEEnumLiteral(EEnumLiteral object) {
                return this.hierarchicalCase((ENamedElement)object, "L-");
            }

            public Object caseEPackage(EPackage object) {
                return this.hierarchicalCase((ENamedElement)object, "P-");
            }

            public Object caseEStructuralFeature(EStructuralFeature object) {
                return this.hierarchicalCase((ENamedElement)object, "F-");
            }

            public Object defaultCase(EObject object) {
                return null;
            }

            protected Object hierarchicalCase(ENamedElement object, String prefix) {
                EObject eContainer;
                if (this.s == null) {
                    this.s = new StringBuilder();
                    this.s.append(prefix);
                }
                if ((eContainer = object.eContainer()) != null) {
                    this.doSwitch(eContainer);
                    this.s.append("-");
                }
                this.s.append(object.getName());
                return null;
            }

            public @Nullable String toString() {
                return this.s != null ? this.s.toString() : null;
            }
        }
    }

    public static class UUIDCreator
    implements IdCreator {
        @Override
        public @Nullable String createId(@NonNull EObject eObject, @NonNull Set<@NonNull String> knownIds) {
            String uuid;
            while (knownIds.contains(uuid = EcoreUtil.generateUUID())) {
            }
            return uuid;
        }
    }
}

