/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.diagram.design;

import activity.ActivityFactory;
import activity.Move;
import activity.PeripheralAction;
import activity.SchedulingType;
import activity.SimpleAction;
import java.util.ArrayList;
import machine.ActionType;
import machine.Distance;
import machine.IResource;
import machine.Peripheral;
import machine.Profile;
import machine.Resource;
import machine.SymbolicPosition;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddPeripheralActionPage
extends WizardPage {
    private final String initialActionName;
    private final AdapterFactory adapterFactory;
    private Peripheral peripheral;
    private final IResource initialResource;
    private Text textName;
    private Button btnAction;
    private Button btnMove;
    private ComboViewer comboAction;
    private ComboViewer comboPosition;
    private ComboViewer comboMoveType;
    private ComboViewer comboProfile;
    private ComboViewer comboSchedulingType;
    private ComboViewer comboResource;
    private Label lblType;

    public AddPeripheralActionPage(IResource resource, String initialActionName, AdapterFactory adapterFactory) {
        super(AddPeripheralActionPage.class.getSimpleName());
        this.setTitle("Action details");
        this.setDescription("Provide the details for the action to add");
        this.initialActionName = initialActionName;
        this.adapterFactory = adapterFactory;
        this.initialResource = resource;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblName = new Label(container, 0);
        lblName.setAlignment(131072);
        lblName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblName.setText("Name:");
        this.textName = new Text(container, 2048);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textName.setText(this.initialActionName);
        this.btnAction = new Button(container, 16);
        this.btnAction.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnAction.setAlignment(131072);
        this.btnAction.setSelection(true);
        this.btnAction.setText("Action:");
        this.btnAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AddPeripheralActionPage.this.comboAction.getCombo().setEnabled(AddPeripheralActionPage.this.btnAction.getSelection());
                AddPeripheralActionPage.this.updatePageComplete();
            }

            public void widgetSelected(SelectionEvent e) {
                AddPeripheralActionPage.this.comboAction.getCombo().setEnabled(AddPeripheralActionPage.this.btnAction.getSelection());
                AddPeripheralActionPage.this.updatePageComplete();
            }
        });
        this.comboAction = new ComboViewer(container, 0);
        this.comboAction.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboAction.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.comboAction.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboAction.getCombo().setEnabled(this.btnAction.getSelection());
        this.comboAction.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddPeripheralActionPage.this.updatePageComplete();
            }
        });
        this.btnMove = new Button(container, 16);
        this.btnMove.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnMove.setAlignment(131072);
        this.btnMove.setText("Move" + (this.peripheral == null ? "" : (this.peripheral.getDistances().isEmpty() ? " to" : " for")) + ':');
        this.btnMove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AddPeripheralActionPage.this.comboPosition.getCombo().setEnabled(AddPeripheralActionPage.this.btnMove.getSelection());
                AddPeripheralActionPage.this.comboMoveType.getCombo().setEnabled(AddPeripheralActionPage.this.btnMove.getSelection());
                AddPeripheralActionPage.this.comboProfile.getCombo().setEnabled(AddPeripheralActionPage.this.btnMove.getSelection());
                AddPeripheralActionPage.this.updatePageComplete();
            }

            public void widgetSelected(SelectionEvent e) {
                AddPeripheralActionPage.this.comboPosition.getCombo().setEnabled(AddPeripheralActionPage.this.btnMove.getSelection());
                AddPeripheralActionPage.this.comboMoveType.getCombo().setEnabled(AddPeripheralActionPage.this.btnMove.getSelection());
                AddPeripheralActionPage.this.comboProfile.getCombo().setEnabled(AddPeripheralActionPage.this.btnMove.getSelection());
                AddPeripheralActionPage.this.updatePageComplete();
            }
        });
        this.comboPosition = new ComboViewer(container, 0);
        this.comboPosition.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboPosition.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.comboPosition.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboPosition.getCombo().setEnabled(this.btnMove.getSelection());
        this.comboPosition.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddPeripheralActionPage.this.updatePageComplete();
            }
        });
        this.lblType = new Label(container, 0);
        this.lblType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblType.setText("Move type:");
        this.comboMoveType = new ComboViewer(container, 0);
        this.comboMoveType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboMoveType.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.comboMoveType.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboMoveType.getCombo().setEnabled(this.btnMove.getSelection());
        this.comboMoveType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddPeripheralActionPage.this.updatePageComplete();
            }
        });
        this.comboMoveType.setInput((Object)MoveType.values());
        Label lblProfile = new Label(container, 0);
        lblProfile.setAlignment(131072);
        lblProfile.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblProfile.setText("Speed Profile:");
        this.comboProfile = new ComboViewer(container, 0);
        this.comboProfile.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboProfile.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.comboProfile.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboProfile.getCombo().setEnabled(this.btnMove.getSelection());
        this.comboProfile.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddPeripheralActionPage.this.updatePageComplete();
            }
        });
        Label lblSchedulingType = new Label(container, 0);
        lblSchedulingType.setAlignment(131072);
        lblSchedulingType.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblSchedulingType.setText("Scheduling type:");
        this.comboSchedulingType = new ComboViewer(container, 0);
        this.comboSchedulingType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboSchedulingType.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.comboSchedulingType.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboSchedulingType.setInput((Object)SchedulingType.VALUES);
        this.comboSchedulingType.setSelection((ISelection)new StructuredSelection((Object)SchedulingType.ASAP));
        Label resourceLabel = new Label(container, 0);
        resourceLabel.setAlignment(131072);
        resourceLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        resourceLabel.setText("Resource:");
        this.comboResource = new ComboViewer(container, 0);
        this.comboResource.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboResource.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.comboResource.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboResource.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddPeripheralActionPage.this.updatePageComplete();
            }
        });
    }

    public void setPeripheral(Peripheral peripheral) {
        if (peripheral != this.peripheral) {
            this.peripheral = peripheral;
            this.comboAction.setInput((Object)peripheral.getType().getActions());
            this.comboPosition.setInput((Object)(peripheral.getDistances().isEmpty() ? peripheral.getPositions() : peripheral.getDistances()));
            this.comboProfile.setInput((Object)peripheral.getProfiles());
            ArrayList<String> resources = new ArrayList<String>();
            if (!peripheral.getResource().getItems().isEmpty()) {
                resources.add("Select resource or resource item");
            }
            resources.add(peripheral.getResource().fqn());
            peripheral.getResource().getItems().forEach(i -> {
                boolean bl = resources.add(i.fqn());
            });
            this.comboResource.setInput(resources.stream().toArray(String[]::new));
            String select = this.initialResource == null ? (String)resources.get(0) : this.initialResource.fqn();
            this.comboResource.setSelection((ISelection)new StructuredSelection((Object)select));
            this.updatePageComplete();
        }
    }

    public PeripheralAction createPeripheralAction() {
        SimpleAction result;
        if (this.btnAction.getSelection() && !this.comboAction.getSelection().isEmpty()) {
            result = ActivityFactory.eINSTANCE.createSimpleAction();
            result.setType((ActionType)((StructuredSelection)this.comboAction.getSelection()).getFirstElement());
        } else if (this.btnMove.getSelection() && !this.comboPosition.getSelection().isEmpty() && !this.comboMoveType.getSelection().isEmpty() && !this.comboProfile.getSelection().isEmpty()) {
            MoveType selectedMoveType = (MoveType)((Object)((StructuredSelection)this.comboMoveType.getSelection()).getFirstElement());
            Move move = ActivityFactory.eINSTANCE.createMove();
            if (this.peripheral.getDistances().isEmpty()) {
                move.setTargetPosition((SymbolicPosition)((StructuredSelection)this.comboPosition.getSelection()).getFirstElement());
            } else {
                move.setDistance((Distance)((StructuredSelection)this.comboPosition.getSelection()).getFirstElement());
            }
            move.setStopAtTarget(MoveType.MoveTo == selectedMoveType);
            move.setProfile((Profile)((StructuredSelection)this.comboProfile.getSelection()).getFirstElement());
            result = move;
        } else {
            return null;
        }
        StructuredSelection sel = (StructuredSelection)this.comboSchedulingType.getSelection();
        SchedulingType selectedSchedulingType = (SchedulingType)sel.getFirstElement();
        StructuredSelection resourceSel = (StructuredSelection)this.comboResource.getSelection();
        String selectedResource = (String)resourceSel.getFirstElement();
        Resource resource = this.peripheral.getResource();
        for (IResource item : this.peripheral.getResource().getItems()) {
            if (!item.fqn().equals(selectedResource)) continue;
            resource = item;
            break;
        }
        result.setName(this.textName.getText());
        result.setSchedulingType(selectedSchedulingType);
        result.setResource((IResource)resource);
        result.setPeripheral(this.peripheral);
        return result;
    }

    private void updatePageComplete() {
        boolean resourceSet;
        boolean pageComplete = true;
        pageComplete &= !this.textName.getText().isEmpty();
        boolean actionEnabled = this.comboAction.getCombo().getItemCount() > 0;
        boolean moveEnabled = this.comboPosition.getCombo().getItemCount() > 0 && this.comboProfile.getCombo().getItemCount() > 0;
        boolean bl = resourceSet = this.comboResource.getCombo().getItemCount() == 1 || this.comboResource.getCombo().getSelectionIndex() > 0;
        if (this.btnAction.getSelection() && !actionEnabled) {
            this.btnAction.setSelection(false);
            this.btnMove.setSelection(moveEnabled);
        } else if (this.btnMove.getSelection() && !moveEnabled) {
            this.btnMove.setSelection(false);
            this.btnAction.setSelection(actionEnabled);
        }
        if (actionEnabled && this.comboAction.getSelection().isEmpty()) {
            this.comboAction.getCombo().select(0);
        }
        this.btnAction.setEnabled(actionEnabled);
        this.comboAction.getCombo().setEnabled(this.btnAction.getSelection());
        pageComplete &= !this.btnAction.getSelection() || !this.comboAction.getSelection().isEmpty();
        pageComplete &= resourceSet;
        if (moveEnabled) {
            if (this.comboPosition.getSelection().isEmpty()) {
                this.comboPosition.getCombo().select(0);
            }
            if (this.comboMoveType.getSelection().isEmpty()) {
                this.comboMoveType.getCombo().select(0);
            }
            if (this.comboProfile.getSelection().isEmpty()) {
                this.comboProfile.getCombo().select(0);
            }
        }
        this.btnMove.setEnabled(moveEnabled);
        this.comboPosition.getCombo().setEnabled(this.btnMove.getSelection());
        pageComplete &= !this.btnMove.getSelection() || !this.comboPosition.getSelection().isEmpty();
        this.comboMoveType.getCombo().setEnabled(this.btnMove.getSelection());
        pageComplete &= !this.btnMove.getSelection() || !this.comboMoveType.getSelection().isEmpty();
        this.comboProfile.getCombo().setEnabled(this.btnMove.getSelection());
        this.setPageComplete(pageComplete &= !this.btnMove.getSelection() || !this.comboProfile.getSelection().isEmpty());
    }

    private static enum MoveType {
        MoveTo("Point-to-point (stop at target position)"),
        MovePassing("On-the-fly (don't stop at target position)");

        private final String description;

        private MoveType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

