/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.print;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.PrintHelperUtil;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.util.RenderedDiagramPrinter;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Shell;

public class SiriusSWTRenderedDiagramPrinter
extends RenderedDiagramPrinter {
    public SiriusSWTRenderedDiagramPrinter(PreferencesHint preferencesHint, IMapMode mm) {
        super(preferencesHint, mm);
    }

    public void run() {
        assert (this.printer != null) : Messages.SiriusSWTRenderedDiagramPrinter_printerNotSetMsg;
        if (!this.printer.startJob(Messages.SiriusSWTRenderedDiagramPrinter_jobLabel)) {
            return;
        }
        assert (this.diagrams != null);
        Iterator it = this.diagrams.iterator();
        Shell shell = new Shell();
        try {
            while (it.hasNext()) {
                PrinterData printerData;
                Object obj = it.next();
                Assert.isTrue((boolean)(obj instanceof Diagram));
                Diagram diagram = (Diagram)obj;
                DiagramEditor openedDiagramEditor = this.getDiagramEditor(diagram);
                DiagramEditPart dgrmEP = openedDiagramEditor == null ? PrintHelperUtil.createDiagramEditPart((Diagram)diagram, (PreferencesHint)this.preferencesHint, (Shell)shell) : openedDiagramEditor.getDiagramEditPart();
                boolean loadedPreferences = PrintHelperUtil.initializePreferences((DiagramEditPart)dgrmEP, (PreferencesHint)this.preferencesHint);
                RootEditPart rep = dgrmEP.getRoot();
                if (rep instanceof DiagramRootEditPart) {
                    this.mapMode = ((DiagramRootEditPart)rep).getMapMode();
                }
                this.initialize();
                IPreferenceStore pref = null;
                assert (dgrmEP.getViewer() instanceof DiagramGraphicalViewer);
                pref = ((DiagramGraphicalViewer)dgrmEP.getViewer()).getWorkspaceViewerPreferenceStore();
                if (pref.getBoolean("print.useWorkspaceSettings") && dgrmEP.getDiagramPreferencesHint().getPreferenceStore() != null) {
                    pref = (IPreferenceStore)dgrmEP.getDiagramPreferencesHint().getPreferenceStore();
                }
                if ((printerData = this.printer.getPrinterData()) != null) {
                    boolean useLandscape;
                    boolean bl = useLandscape = printerData.orientation == 2;
                    if (pref.getBoolean("print.useLandscape") != useLandscape) {
                        pref.setValue("print.useLandscape", useLandscape);
                    }
                    if (pref.getBoolean("print.usePortrait") == useLandscape) {
                        pref.setValue("print.usePortrait", !useLandscape);
                    }
                }
                this.doPrintDiagram(dgrmEP, loadedPreferences, pref);
            }
            this.dispose();
            this.printer.endJob();
        }
        finally {
            shell.dispose();
        }
    }

    private DiagramEditor getDiagramEditor(Diagram diagram) {
        DiagramEditor result = null;
        List diagramEditors = EditorService.getInstance().getRegisteredEditorParts();
        for (Object obj : diagramEditors) {
            DiagramEditor diagramEditor;
            if (!(obj instanceof DiagramEditor) || (diagramEditor = (DiagramEditor)obj).getDiagram() != diagram) continue;
            result = diagramEditor;
            break;
        }
        return result;
    }
}

