/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.navigator.filter;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.filter.PatternFilter;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.TooltipAwareNavigatorDecoratingLabelProvider;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredCommonTree
extends Composite {
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    private static final String DISABLED_CLEAR_ICON = "org.eclipse.ui.internal.dialogs.DCLEAR_ICON";
    private static final long SOFT_MAX_EXPAND_TIME = 200L;
    private static Boolean useNativeSearchField;
    protected Text filterText;
    protected ToolBarManager filterToolBar;
    protected Control clearButtonControl;
    protected CommonViewer commonTreeViewer;
    protected Composite filterComposite;
    protected String initialText = "";
    protected Composite parent;
    protected boolean showFilterControls;
    protected Composite treeComposite;
    protected String viewerId;
    private PatternFilter patternFilter;
    private Job refreshJob;
    private boolean useNewLook;
    private String previousFilterText;
    private boolean narrowingDown;

    static {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/clear_co.png");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(CLEAR_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/dtool16/clear_co.png")) != null) {
            JFaceResources.getImageRegistry().put(DISABLED_CLEAR_ICON, descriptor);
        }
    }

    public FilteredCommonTree(String viewerId, Composite parent, int treeStyle, boolean useNewLook) {
        super(parent, 0);
        this.parent = parent;
        this.useNewLook = useNewLook;
        this.viewerId = viewerId;
        this.init(treeStyle);
    }

    protected FilteredCommonTree(String viewerId, Composite parent, boolean useNewLook) {
        super(parent, 0);
        this.parent = parent;
        this.useNewLook = useNewLook;
        this.viewerId = viewerId;
    }

    private static boolean useNativeSearchField(Composite composite) {
        if (useNativeSearchField == null) {
            useNativeSearchField = Boolean.FALSE;
            Text testText = null;
            try {
                testText = new Text(composite, 384);
                useNativeSearchField = new Boolean((testText.getStyle() & 0x100) != 0);
            }
            finally {
                if (testText != null) {
                    testText.dispose();
                }
            }
        }
        return useNativeSearchField;
    }

    protected void init(int treeStyle) {
        this.showFilterControls = PlatformUI.getPreferenceStore().getBoolean("SHOW_FILTERED_TEXTS");
        this.createControl(this.parent, treeStyle);
        this.createRefreshJob();
        this.setInitialText(WorkbenchMessages.FilteredTree_FilterMessage);
        this.setFont(this.parent.getFont());
    }

    protected void createControl(Composite aParent, int treeStyle) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        if (this.parent.getLayout() instanceof GridLayout) {
            this.setLayoutData(new GridData(4, 4, true, true));
        }
        if (this.showFilterControls) {
            if (!this.useNewLook || FilteredCommonTree.useNativeSearchField(aParent)) {
                this.filterComposite = new Composite((Composite)this, 0);
            } else {
                this.filterComposite = new Composite((Composite)this, 2048);
                this.filterComposite.setBackground(this.getDisplay().getSystemColor(25));
            }
            GridLayout filterLayout = new GridLayout(2, false);
            filterLayout.marginHeight = 0;
            filterLayout.marginWidth = 0;
            this.filterComposite.setLayout((Layout)filterLayout);
            this.filterComposite.setFont(aParent.getFont());
            this.createFilterControls(this.filterComposite);
            this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.treeComposite = new Composite((Composite)this, 0);
        GridLayout treeCompositeLayout = new GridLayout();
        treeCompositeLayout.marginHeight = 0;
        treeCompositeLayout.marginWidth = 0;
        this.treeComposite.setLayout((Layout)treeCompositeLayout);
        GridData data = new GridData(4, 4, true, true);
        this.treeComposite.setLayoutData((Object)data);
        this.createTreeControl(this.treeComposite, treeStyle);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getViewer());
    }

    protected Composite createFilterControls(Composite aParent) {
        this.createFilterText(aParent);
        if (this.useNewLook) {
            this.createClearTextNew(aParent);
        } else {
            this.createClearTextOld(aParent);
        }
        if (this.clearButtonControl != null) {
            this.clearButtonControl.setVisible(false);
        }
        if (this.filterToolBar != null) {
            this.filterToolBar.update(false);
            this.filterToolBar.getControl().setVisible(false);
        }
        return aParent;
    }

    protected Control createTreeControl(Composite aParent, int style) {
        this.commonTreeViewer = this.doCreateCommonViewer(aParent, style);
        GridData data = new GridData(4, 4, true, true);
        this.commonTreeViewer.getControl().setLayoutData((Object)data);
        this.commonTreeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilteredCommonTree.this.refreshJob.cancel();
            }
        });
        if (this.commonTreeViewer instanceof NotifyingCommonViewer) {
            this.patternFilter.setUseCache(true);
        }
        this.commonTreeViewer.addFilter((ViewerFilter)this.patternFilter);
        return this.commonTreeViewer.getControl();
    }

    protected CommonViewer doCreateCommonViewer(Composite aParent, int style) {
        return new NotifyingCommonViewer(this.viewerId, aParent, style);
    }

    private TreeItem getFirstMatchingItem(TreeItem[] items) {
        TreeItem result = null;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (this.patternFilter.isLeafMatch((Viewer)this.commonTreeViewer, item.getData()) && this.patternFilter.isElementSelectable(item.getData())) {
                result = item;
                break;
            }
            TreeItem treeItem = this.getFirstMatchingItem(item.getItems());
            if (treeItem != null) {
                result = treeItem;
                break;
            }
            ++n2;
        }
        return result;
    }

    private void createRefreshJob() {
        this.refreshJob = this.doCreateRefreshJob();
        this.refreshJob.setSystem(true);
    }

    protected WorkbenchJob doCreateRefreshJob() {
        return new WorkbenchJob(Messages.FilteredCommonTree_refreshFilterJob){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IStatus result = null;
                if (FilteredCommonTree.this.commonTreeViewer.getControl().isDisposed()) {
                    result = Status.CANCEL_STATUS;
                } else {
                    String text = FilteredCommonTree.this.getFilterString();
                    if (text == null) {
                        result = Status.OK_STATUS;
                    } else {
                        boolean initial;
                        boolean bl = initial = FilteredCommonTree.this.initialText != null && FilteredCommonTree.this.initialText.equals(text);
                        if (initial) {
                            FilteredCommonTree.this.patternFilter.setPattern(null);
                        } else {
                            FilteredCommonTree.this.patternFilter.setPattern(text);
                        }
                        Composite redrawFalseControl = FilteredCommonTree.this.treeComposite != null ? FilteredCommonTree.this.treeComposite : FilteredCommonTree.this.commonTreeViewer.getControl();
                        try {
                            redrawFalseControl.setRedraw(false);
                            if (!FilteredCommonTree.this.narrowingDown) {
                                TreeItem[] is;
                                TreeItem[] treeItemArray = is = FilteredCommonTree.this.commonTreeViewer.getTree().getItems();
                                int n = is.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TreeItem item = treeItemArray[n2];
                                    if (item.getExpanded()) {
                                        FilteredCommonTree.this.commonTreeViewer.setExpandedState(item.getData(), false);
                                    }
                                    ++n2;
                                }
                            }
                            FilteredCommonTree.this.commonTreeViewer.refresh(true);
                            if (text.length() > 0 && !initial) {
                                TreeItem[] items = FilteredCommonTree.this.getViewer().getTree().getItems();
                                int treeHeight = FilteredCommonTree.this.getViewer().getTree().getBounds().height;
                                int numVisibleItems = treeHeight / FilteredCommonTree.this.getViewer().getTree().getItemHeight();
                                long stopTime = 200L + System.currentTimeMillis();
                                boolean cancel = false;
                                if (items.length > 0 && this.recursiveExpand(items, monitor, stopTime, new int[]{numVisibleItems})) {
                                    cancel = true;
                                }
                                FilteredCommonTree.this.updateToolbar(true);
                                if (cancel) {
                                    result = Status.CANCEL_STATUS;
                                }
                            } else {
                                FilteredCommonTree.this.updateToolbar(false);
                            }
                        }
                        finally {
                            TreeItem[] items = FilteredCommonTree.this.getViewer().getTree().getItems();
                            if (items.length > 0 && FilteredCommonTree.this.getViewer().getTree().getSelectionCount() == 0) {
                                FilteredCommonTree.this.commonTreeViewer.getTree().setTopItem(items[0]);
                            }
                            redrawFalseControl.setRedraw(true);
                        }
                        if (result == null) {
                            result = Status.OK_STATUS;
                        }
                    }
                }
                return result;
            }

            private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                boolean canceled = false;
                int i = 0;
                while (!canceled && i < items.length) {
                    boolean visible;
                    TreeItem item = items[i];
                    int n = numItemsLeft[0];
                    numItemsLeft[0] = n - 1;
                    boolean bl = visible = n >= 0;
                    if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                        canceled = true;
                    } else {
                        Object itemData = item.getData();
                        if (itemData != null) {
                            if (!item.getExpanded()) {
                                FilteredCommonTree.this.commonTreeViewer.setExpandedState(itemData, true);
                            }
                            TreeItem[] children = item.getItems();
                            if (items.length > 0) {
                                canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                            }
                        }
                    }
                    ++i;
                }
                return canceled;
            }
        };
    }

    protected void updateToolbar(boolean visible) {
        if (this.clearButtonControl != null) {
            this.clearButtonControl.setVisible(visible);
        }
        if (this.filterToolBar != null) {
            this.filterToolBar.getControl().setVisible(visible);
        }
    }

    protected void createFilterText(Composite aParent) {
        this.filterText = this.doCreateFilterText(aParent);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = FilteredCommonTree.this.filterText.getText();
                e.result = filterTextString.length() == 0 || filterTextString.equals(FilteredCommonTree.this.initialText) ? FilteredCommonTree.this.initialText : MessageFormat.format(WorkbenchMessages.FilteredTree_AccessibleListenerFiltered, filterTextString, String.valueOf(this.getFilteredItemsCount()));
            }

            private int getFilteredItemsCount() {
                TreeItem[] items;
                int total = 0;
                TreeItem[] treeItemArray = items = FilteredCommonTree.this.getViewer().getTree().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    total += this.itemCount(item);
                    ++n2;
                }
                return total;
            }

            private int itemCount(TreeItem treeItem) {
                TreeItem[] children;
                int count = 1;
                TreeItem[] treeItemArray = children = treeItem.getItems();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem element = treeItemArray[n2];
                    count += this.itemCount(element);
                    ++n2;
                }
                return count;
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (!FilteredCommonTree.this.useNewLook) {
                    Display display = FilteredCommonTree.this.filterText.getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).FilteredCommonTree.this.filterText.isDisposed() && FilteredCommonTree.this.getInitialText().equals((this).FilteredCommonTree.this.filterText.getText().trim())) {
                                (this).FilteredCommonTree.this.filterText.selectAll();
                            }
                        }
                    });
                    return;
                }
            }

            public void focusLost(FocusEvent e) {
                if (!FilteredCommonTree.this.useNewLook) {
                    return;
                }
                if (FilteredCommonTree.this.filterText.getText().equals(FilteredCommonTree.this.initialText)) {
                    FilteredCommonTree.this.setFilterText("");
                    FilteredCommonTree.this.textChanged();
                }
            }
        });
        if (this.useNewLook) {
            this.filterText.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (FilteredCommonTree.this.filterText.getText().equals(FilteredCommonTree.this.initialText)) {
                        FilteredCommonTree.this.setFilterText("");
                        FilteredCommonTree.this.textChanged();
                    }
                }
            });
        }
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = FilteredCommonTree.this.getViewer().getTree().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    FilteredCommonTree.this.commonTreeViewer.getTree().setFocus();
                    return;
                }
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    if (FilteredCommonTree.this.getViewer().getTree().getItemCount() == 0) {
                        Display.getCurrent().beep();
                    } else {
                        Tree tree;
                        TreeItem item;
                        boolean textChanged;
                        boolean hasFocus = FilteredCommonTree.this.getViewer().getTree().setFocus();
                        boolean bl = textChanged = !FilteredCommonTree.this.getInitialText().equals(FilteredCommonTree.this.filterText.getText().trim());
                        if (hasFocus && textChanged && FilteredCommonTree.this.filterText.getText().trim().length() > 0 && (item = (tree = FilteredCommonTree.this.getViewer().getTree()).getSelectionCount() > 0 ? FilteredCommonTree.this.getFirstMatchingItem(tree.getSelection()) : FilteredCommonTree.this.getFirstMatchingItem(tree.getItems())) != null) {
                            tree.setSelection(new TreeItem[]{item});
                            ISelection sel = FilteredCommonTree.this.getViewer().getSelection();
                            FilteredCommonTree.this.getViewer().setSelection(sel, true);
                        }
                    }
                }
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilteredCommonTree.this.textChanged();
            }
        });
        if ((this.filterText.getStyle() & 0x100) != 0) {
            this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (e.detail == 256) {
                        FilteredCommonTree.this.clearText();
                    }
                }
            });
        }
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.verticalIndent = 2;
        gridData.horizontalIndent = 2;
        if ((this.filterText.getStyle() & 0x100) != 0) {
            gridData.horizontalSpan = 2;
        }
        this.filterText.setLayoutData((Object)gridData);
    }

    protected Text doCreateFilterText(Composite aParent) {
        if (!this.useNewLook || FilteredCommonTree.useNativeSearchField(aParent)) {
            return new Text(aParent, 2436);
        }
        return new Text(aParent, 4);
    }

    protected void textChanged() {
        this.narrowingDown = this.previousFilterText == null || this.previousFilterText.equals(WorkbenchMessages.FilteredTree_FilterMessage) || this.getFilterString() != null && this.getFilterString().startsWith(this.previousFilterText);
        this.previousFilterText = this.getFilterString();
        this.refreshJob.cancel();
        this.refreshJob.schedule(this.getRefreshJobDelay());
    }

    protected long getRefreshJobDelay() {
        return 200L;
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.filterComposite != null && (!this.useNewLook || FilteredCommonTree.useNativeSearchField(this.filterComposite))) {
            this.filterComposite.setBackground(background);
        }
        if (this.filterToolBar != null && this.filterToolBar.getControl() != null) {
            this.filterToolBar.getControl().setBackground(background);
        }
    }

    private void createClearTextOld(Composite aParent) {
        if ((this.filterText.getStyle() & 0x100) == 0) {
            this.filterToolBar = new ToolBarManager(0x800100);
            this.filterToolBar.createControl(aParent);
            Action clearTextAction = new Action("", 1){

                public void run() {
                    FilteredCommonTree.this.clearText();
                }
            };
            clearTextAction.setToolTipText(WorkbenchMessages.FilteredTree_ClearToolTip);
            clearTextAction.setImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON));
            clearTextAction.setDisabledImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(DISABLED_CLEAR_ICON));
            this.filterToolBar.add((IAction)clearTextAction);
        }
    }

    private void createClearTextNew(Composite aParent) {
        if ((this.filterText.getStyle() & 0x100) == 0) {
            final Image inactiveImage = JFaceResources.getImageRegistry().getDescriptor(DISABLED_CLEAR_ICON).createImage();
            final Image activeImage = JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON).createImage();
            final Image pressedImage = new Image((Device)this.getDisplay(), activeImage, 2);
            final Label clearButton = new Label(aParent, 0);
            clearButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            clearButton.setImage(inactiveImage);
            clearButton.setBackground(aParent.getDisplay().getSystemColor(25));
            clearButton.setToolTipText(WorkbenchMessages.FilteredTree_ClearToolTip);
            clearButton.addMouseListener((MouseListener)new MouseAdapter(){
                private MouseMoveListener fMoveListener;

                public void mouseDown(MouseEvent e) {
                    clearButton.setImage(pressedImage);
                    this.fMoveListener = new MouseMoveListener(){
                        private boolean fMouseInButton = true;

                        public void mouseMove(MouseEvent e) {
                            boolean mouseInButton = this.isMouseInButton(e);
                            if (mouseInButton != this.fMouseInButton) {
                                this.fMouseInButton = mouseInButton;
                                clearButton.setImage(mouseInButton ? pressedImage : inactiveImage);
                            }
                        }
                    };
                    clearButton.addMouseMoveListener(this.fMoveListener);
                }

                public void mouseUp(MouseEvent e) {
                    if (this.fMoveListener != null) {
                        clearButton.removeMouseMoveListener(this.fMoveListener);
                        this.fMoveListener = null;
                        boolean mouseInButton = this.isMouseInButton(e);
                        clearButton.setImage(mouseInButton ? activeImage : inactiveImage);
                        if (mouseInButton) {
                            FilteredCommonTree.this.clearText();
                            FilteredCommonTree.this.filterText.setFocus();
                        }
                    }
                }

                private boolean isMouseInButton(MouseEvent e) {
                    Point buttonSize = clearButton.getSize();
                    return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
                }
            });
            clearButton.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    clearButton.setImage(activeImage);
                }

                public void mouseExit(MouseEvent e) {
                    clearButton.setImage(inactiveImage);
                }

                public void mouseHover(MouseEvent e) {
                }
            });
            clearButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    inactiveImage.dispose();
                    activeImage.dispose();
                    pressedImage.dispose();
                }
            });
            clearButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = WorkbenchMessages.FilteredTree_AccessibleListenerClearButton;
                }
            });
            clearButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 43;
                }
            });
            this.clearButtonControl = clearButton;
        }
    }

    protected void clearText() {
        this.setFilterText("");
        this.textChanged();
    }

    protected void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            this.selectAll();
        }
    }

    public final PatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public CommonViewer getViewer() {
        return this.commonTreeViewer;
    }

    public Text getFilterControl() {
        return this.filterText;
    }

    protected String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : null;
    }

    public void setInitialText(String text) {
        this.initialText = text;
        if (this.useNewLook && this.filterText != null) {
            this.filterText.setMessage(text);
            if (this.filterText.isFocusControl()) {
                this.setFilterText(this.initialText);
                this.textChanged();
            } else {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!FilteredCommonTree.this.filterText.isDisposed() && FilteredCommonTree.this.filterText.isFocusControl()) {
                            FilteredCommonTree.this.setFilterText(FilteredCommonTree.this.initialText);
                            FilteredCommonTree.this.textChanged();
                        }
                    }
                });
            }
        } else {
            this.setFilterText(this.initialText);
            this.textChanged();
        }
    }

    protected void selectAll() {
        if (this.filterText != null) {
            this.filterText.selectAll();
        }
    }

    protected String getInitialText() {
        return this.initialText;
    }

    public static Font getBoldFont(Object element, FilteredCommonTree tree, PatternFilter filter) {
        Font result = null;
        String filterText = tree.getFilterString();
        if (filterText != null) {
            String initialText = tree.getInitialText();
            if (!filterText.equals("") && !filterText.equals(initialText)) {
                if (tree.getPatternFilter() != filter) {
                    boolean initial;
                    boolean bl = initial = initialText != null && initialText.equals(filterText);
                    if (initial) {
                        filter.setPattern(null);
                    } else {
                        filter.setPattern(filterText);
                    }
                }
                if (filter.isElementVisible((Viewer)tree.getViewer(), element) && filter.isLeafMatch((Viewer)tree.getViewer(), element)) {
                    result = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
                }
            }
        }
        return result;
    }

    class NotifyingCommonViewer
    extends CommonViewer {
        NotifyingCommonViewer(String viewerId, Composite parent, int style) {
            super(viewerId, parent, style);
        }

        protected void init() {
            ViewerFilter[] visibleFilters;
            ViewerFilter[] viewerFilterArray = visibleFilters = this.getNavigatorContentService().getFilterService().getVisibleFilters(false);
            int n = visibleFilters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter visibleFilter = viewerFilterArray[n2];
                if (visibleFilter instanceof PatternFilter) {
                    FilteredCommonTree.this.patternFilter = (PatternFilter)visibleFilter;
                    if (this.getNavigatorContentService().getFilterService().isActive("org.eclipse.sirius.ui.commonFilter.pattern") || !(this.getNavigatorContentService().getFilterService() instanceof NavigatorFilterService)) break;
                    ((NavigatorFilterService)this.getNavigatorContentService().getFilterService()).addActiveFilterIds(new String[]{"org.eclipse.sirius.ui.commonFilter.pattern"});
                    break;
                }
                ++n2;
            }
            if (FilteredCommonTree.this.patternFilter == null) {
                SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", MessageFormat.format(Messages.FilteredCommonTree_missingFilter, "org.eclipse.sirius.ui.commonFilter.pattern")));
            }
            super.init();
            this.setLabelProvider((IBaseLabelProvider)new TooltipAwareNavigatorDecoratingLabelProvider(this.getNavigatorContentService().createCommonLabelProvider()));
        }

        public void add(Object parentElementOrTreePath, Object childElement) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElement);
        }

        public void add(Object parentElementOrTreePath, Object[] childElements) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElements);
        }

        protected void inputChanged(Object input, Object oldInput) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.inputChanged(input, oldInput);
        }

        public void insert(Object parentElementOrTreePath, Object element, int position) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.insert(parentElementOrTreePath, element, position);
        }

        public void refresh() {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.refresh();
        }

        public void refresh(boolean updateLabels) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.refresh(updateLabels);
        }

        public void refresh(Object element) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.refresh(element);
        }

        public void refresh(Object element, boolean updateLabels) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.refresh(element, updateLabels);
        }

        public void remove(Object elementsOrTreePaths) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void remove(Object aParent, Object[] elements) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.remove(aParent, elements);
        }

        public void remove(Object[] elementsOrTreePaths) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void replace(Object parentElementOrTreePath, int index, Object element) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.replace(parentElementOrTreePath, index, element);
        }

        public void setChildCount(Object elementOrTreePath, int count) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.setChildCount(elementOrTreePath, count);
        }

        public void setContentProvider(IContentProvider provider) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.setContentProvider(provider);
        }

        public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
            FilteredCommonTree.this.getPatternFilter().clearCaches();
            super.setHasChildren(elementOrTreePath, hasChildren);
        }
    }
}

