/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2yed.options;

import java.util.EnumSet;
import org.eclipse.escet.cif.cif2yed.options.ModelFilter;
import org.eclipse.escet.common.app.framework.options.EnumSetOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class ModelFiltersOption
extends EnumSetOption<ModelFilter> {
    public ModelFiltersOption() {
        super("Model filters", "The kinds of features to include in the diagram. Only applies to diagrams of the model. Specify comma separated feature names. Specify \"io\" to include the I/O declarations, \"decls\" (default) to include the declarations of the components, \"loc-decls\" (default) to include the declarations of the locations, \"guards\" (default) to include the guards of the edges, and/or \"updates\" (default) to include the updates of the edges. Prefix a name with \"+\" to add it on top of the defaults, or with \"-\" to remove it from the defaults.", Character.valueOf('f'), "model-filters", "FILTERS", ModelFiltersOption.getDefaults(), true, "The kinds of features to include in the diagram. Only applies to diagrams of the model.", ModelFilter.class);
    }

    private static EnumSet<ModelFilter> getDefaults() {
        return EnumSet.of(ModelFilter.DECLS, ModelFilter.LOC_DECLS, ModelFilter.GUARDS, ModelFilter.UPDATES);
    }

    protected String getDialogText(ModelFilter filter) {
        switch (filter) {
            case IO: {
                return "The I/O declarations";
            }
            case DECLS: {
                return "The declarations of the components";
            }
            case LOC_DECLS: {
                return "The declarations of the locations";
            }
            case GUARDS: {
                return "The guards of the edges";
            }
            case UPDATES: {
                return "The updates of the edges";
            }
        }
        throw new RuntimeException("Unknown model filter: " + (Object)((Object)filter));
    }

    public static EnumSet<ModelFilter> getFilters() {
        return (EnumSet)Options.get(ModelFiltersOption.class);
    }
}

