/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.xtend.annotations;

import com.google.common.collect.BiMap;
import java.util.Map;
import org.eclipse.lsat.common.xtend.annotations.IntermediateProperty;
import org.eclipse.lsat.common.xtend.annotations.TypeReferenceUtil;
import org.eclipse.xtend.lib.macro.AbstractFieldProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class IntermediatePropertyCompilationParticipant
extends AbstractFieldProcessor {
    public void doTransform(MutableFieldDeclaration field, @Extension TransformationContext context) {
        boolean _not_1;
        boolean _not;
        boolean _tripleNotEquals;
        AnnotationReference swAnn;
        AnnotationReference _annotation = field.findAnnotation(context.findTypeGlobally(IntermediateProperty.class));
        Object[] ownerTypes = _annotation.getClassArrayValue("value");
        String oppositePropertyName = _annotation.getStringValue("opposite");
        int expectedSize = _annotation.getIntValue("expectedSize");
        TypeReference ownerCommonType = (TypeReference)IterableExtensions.head(TypeReferenceUtil.getCommonBaseTypes((Iterable)Conversions.doWrapArray((Object)ownerTypes)));
        field.markAsRead();
        boolean _isInferred = field.getType().isInferred();
        if (_isInferred) {
            context.addError((Element)field, "Type inference is not supported by @IntermediateProperty");
            return;
        }
        boolean _isPrimitive = field.getType().isPrimitive();
        if (_isPrimitive) {
            context.addError((Element)field, "Fields with primitives are not supported by @IntermediateProperty");
            return;
        }
        boolean _isStatic = field.isStatic();
        if (_isStatic && ((swAnn = field.findAnnotation(context.findTypeGlobally(SuppressWarnings.class))) == null || !ArrayExtensions.contains((Object[])swAnn.getStringArrayValue("value"), (Object)"static"))) {
            context.addWarning((Element)field, "Note that this property will be statically available");
        }
        if (!StringExtensions.isNullOrEmpty((String)oppositePropertyName) && !ArrayExtensions.contains((Object[])ownerTypes, (Object)ownerCommonType)) {
            StringConcatenation _builder = new StringConcatenation();
            TypeReference _type = field.getType();
            _builder.append((Object)_type);
            _builder.append(".");
            _builder.append(oppositePropertyName);
            _builder.append(" property type is reduced to ");
            String _name = ownerCommonType.getName();
            _builder.append(_name);
            context.addWarning((Element)field, _builder.toString());
        }
        TypeReference propertyType = field.getType();
        String propertyName = field.getSimpleName();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("_IntermediateProperty_");
        _builder_1.append(propertyName);
        final String propertyMap = _builder_1.toString();
        MutableFieldDeclaration _xifexpression = null;
        Expression _initializer = field.getInitializer();
        boolean bl = _tripleNotEquals = _initializer != null;
        if (_tripleNotEquals) {
            MutableTypeDeclaration _declaringType = field.getDeclaringType();
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("_DEFAULT");
            Object[] objectArray = ownerTypes;
            int n = ownerTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Object type = objectArray[n2];
                _builder_2.append("_");
                String _upperCase = type.getSimpleName().toUpperCase();
                _builder_2.append(_upperCase);
                ++n2;
            }
            _builder_2.append("_");
            String _upperCase_1 = propertyName.toUpperCase();
            _builder_2.append(_upperCase_1);
            Procedures.Procedure1 _function = it -> {
                it.setVisibility(Visibility.PRIVATE);
                it.setStatic(true);
                it.setFinal(true);
                it.setType(field.getType());
                it.setInitializer(field.getInitializer());
            };
            _xifexpression = _declaringType.addField(_builder_2.toString(), _function);
        }
        MutableFieldDeclaration propertyDefault = _xifexpression;
        Object[] objectArray = ownerTypes;
        int _function = ownerTypes.length;
        int _upperCase_1 = 0;
        while (_upperCase_1 < _function) {
            Object ownerType = objectArray[_upperCase_1];
            MutableTypeDeclaration _declaringType_1 = field.getDeclaringType();
            String _firstUpper = StringExtensions.toFirstUpper((String)propertyName);
            String _plus = "get" + _firstUpper;
            Procedures.Procedure1 _function_1 = arg_0 -> this.lambda$1(field, (TypeReference)ownerType, propertyType, propertyDefault, propertyMap, context, arg_0);
            _declaringType_1.addMethod(_plus, _function_1);
            MutableTypeDeclaration _declaringType_2 = field.getDeclaringType();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)propertyName);
            String _plus_1 = "set" + _firstUpper_1;
            Procedures.Procedure1 _function_2 = arg_0 -> this.lambda$2(field, (TypeReference)ownerType, propertyType, propertyDefault, propertyMap, context, arg_0);
            _declaringType_2.addMethod(_plus_1, _function_2);
            ++_upperCase_1;
        }
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)oppositePropertyName);
        boolean bl2 = _not = !_isNullOrEmpty;
        if (_not) {
            MutableTypeDeclaration _declaringType_1 = field.getDeclaringType();
            String _firstUpper = StringExtensions.toFirstUpper((String)oppositePropertyName);
            String _plus = "get" + _firstUpper;
            Procedures.Procedure1 _function_1 = it -> {
                it.setVisibility(field.getVisibility());
                it.setStatic(field.isStatic());
                it.addParameter("owner", propertyType);
                it.setReturnType(ownerCommonType);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)propertyMap);
                        _builder.append((Object)".inverse().get(owner);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                it.setBody(_client);
                context.setPrimarySourceElement((MutableElement)it, (Element)field);
            };
            _declaringType_1.addMethod(_plus, _function_1);
            MutableTypeDeclaration _declaringType_2 = field.getDeclaringType();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)oppositePropertyName);
            String _plus_1 = "set" + _firstUpper_1;
            Procedures.Procedure1 _function_2 = it -> {
                it.setVisibility(field.getVisibility());
                it.setStatic(field.isStatic());
                it.addParameter("owner", propertyType);
                it.addParameter("value", ownerCommonType);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (value == null) {");
                        _builder.newLine();
                        _builder.append((Object)"    ");
                        _builder.append((Object)propertyMap, "    ");
                        _builder.append((Object)".inverse().remove(owner);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"} else {");
                        _builder.newLine();
                        _builder.append((Object)"    ");
                        _builder.append((Object)propertyMap, "    ");
                        _builder.append((Object)".inverse().put(owner, value);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                    }
                };
                it.setBody(_client);
                context.setPrimarySourceElement((MutableElement)it, (Element)field);
            };
            _declaringType_2.addMethod(_plus_1, _function_2);
        }
        MutableTypeDeclaration _declaringType_3 = field.getDeclaringType();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)propertyName);
        String _plus_2 = "dispose" + _firstUpper_2;
        Procedures.Procedure1 _function_3 = it -> {
            it.setVisibility(Visibility.PRIVATE);
            it.setStatic(field.isStatic());
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)propertyMap);
                    _builder.append((Object)".clear();");
                    _builder.newLineIfNotEmpty();
                }
            };
            it.setBody(_client);
            context.setPrimarySourceElement((MutableElement)it, (Element)field);
        };
        _declaringType_3.addMethod(_plus_2, _function_3);
        field.markAsRead();
        field.setSimpleName(propertyMap);
        String _xifexpression_1 = null;
        _xifexpression_1 = expectedSize > 0 ? Integer.valueOf(expectedSize).toString() : "";
        final String sizeStr = _xifexpression_1;
        boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)oppositePropertyName);
        boolean bl3 = _not_1 = !_isNullOrEmpty_1;
        if (_not_1) {
            field.setType(context.newTypeReference(BiMap.class, new TypeReference[]{ownerCommonType, field.getType()}));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"com.google.common.collect.HashBiMap.create(");
                    _builder.append((Object)sizeStr);
                    _builder.append((Object)")");
                }
            };
            field.setInitializer(_client);
        } else {
            field.setType(context.newTypeReference(Map.class, new TypeReference[]{ownerCommonType, field.getType()}));
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"new java.util.WeakHashMap<>(");
                    _builder.append((Object)sizeStr);
                    _builder.append((Object)")");
                }
            };
            field.setInitializer(_client_1);
        }
    }

    private /* synthetic */ void lambda$1(MutableFieldDeclaration mutableFieldDeclaration, TypeReference typeReference, final TypeReference typeReference2, final MutableFieldDeclaration mutableFieldDeclaration2, final String string, TransformationContext transformationContext, MutableMethodDeclaration it) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        it.setVisibility(mutableFieldDeclaration.getVisibility());
        it.setStatic(mutableFieldDeclaration.isStatic());
        it.addParameter("owner", typeReference);
        it.setReturnType(typeReference2);
        StringConcatenationClient _xifexpression_1 = null;
        _xifexpression_1 = mutableFieldDeclaration2 == null ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"return ");
                _builder.append((Object)string);
                _builder.append((Object)".get(owner);");
                _builder.newLineIfNotEmpty();
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)typeReference2);
                _builder.append((Object)" value = ");
                _builder.append((Object)string);
                _builder.append((Object)".get(owner);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"return value == null ? ");
                String _simpleName = mutableFieldDeclaration2.getSimpleName();
                _builder.append((Object)_simpleName);
                _builder.append((Object)" : value;");
                _builder.newLineIfNotEmpty();
            }
        });
        it.setBody(_xifexpression_1);
        transformationContext.setPrimarySourceElement((MutableElement)it, (Element)mutableFieldDeclaration);
    }

    private /* synthetic */ void lambda$2(MutableFieldDeclaration mutableFieldDeclaration, TypeReference typeReference, TypeReference typeReference2, final MutableFieldDeclaration mutableFieldDeclaration2, final String string, TransformationContext transformationContext, MutableMethodDeclaration it) {
        it.setVisibility(mutableFieldDeclaration.getVisibility());
        it.setStatic(mutableFieldDeclaration.isStatic());
        it.addParameter("owner", typeReference);
        it.addParameter("value", typeReference2);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                if (mutableFieldDeclaration2 == null) {
                    _builder.append((Object)"if (value == null) {");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"if (value == ");
                    String _simpleName = mutableFieldDeclaration2.getSimpleName();
                    _builder.append((Object)_simpleName);
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"    ");
                _builder.append((Object)string, "    ");
                _builder.append((Object)".remove(owner);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"} else {");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)string, "    ");
                _builder.append((Object)".put(owner, value);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        it.setBody(_client);
        transformationContext.setPrimarySourceElement((MutableElement)it, (Element)mutableFieldDeclaration);
    }
}

