/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.declwrap;

import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.AlgParameter;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.parser.ast.AFormalAlgParameter;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypesTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class FormalAlgDeclWrap
extends DeclWrap<AlgParameter> {
    private final AFormalAlgParameter astDecl;

    public FormalAlgDeclWrap(CifTypeChecker tchecker, ParentScope<?> scope, AFormalAlgParameter astDecl, AlgParameter mmDecl) {
        super(tchecker, scope, mmDecl);
        this.astDecl = astDecl;
    }

    @Override
    public String getName() {
        return ((AlgParameter)this.mmDecl).getVariable().getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)((AlgParameter)this.mmDecl).getVariable());
    }

    @Override
    public void tcheckForUseImpl() {
        CifType type;
        this.checkName();
        this.tchecker.addToCycle(this);
        try {
            type = CifTypesTypeChecker.transCifType(this.astDecl.type, this.scope.getParent(), this.tchecker);
        }
        finally {
            this.tchecker.removeFromCycle(this);
        }
        if (CifTypeUtils.hasComponentLikeType((CifType)type)) {
            this.tchecker.addProblem(ErrMsg.DECL_INVALID_TYPE, type.getPosition(), "Algebraic parameter", this.getAbsName(), CifTextUtils.typeToStr((CifType)type));
            throw new SemanticException();
        }
        ((AlgParameter)this.mmDecl).getVariable().setType(type);
        this.status = CheckStatus.FULL;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
    }
}

