/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.internal.preprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.properties.Category;
import org.eclipse.sirius.properties.DialogModelOperation;
import org.eclipse.sirius.properties.GroupValidationSetDescription;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.properties.WidgetDescription;
import org.eclipse.sirius.properties.core.api.IDescriptionLinkResolver;
import org.eclipse.sirius.properties.core.api.TransformationCache;

public class PropertyValidationRulePreprocessorLinkResolver
implements IDescriptionLinkResolver {
    @Override
    public void resolve(EObject eObject, TransformationCache cache) {
        Stream groups = Stream.empty();
        if (eObject instanceof ViewExtensionDescription) {
            EList categories = ((ViewExtensionDescription)eObject).getCategories();
            groups = categories.stream().map(Category::getGroups).flatMap(Collection::stream);
        } else if (eObject instanceof DialogModelOperation) {
            groups = ((DialogModelOperation)eObject).getGroups().stream();
        }
        groups.forEach(group -> {
            Optional<GroupValidationSetDescription> validationSetOptional = Optional.ofNullable(group.getValidationSet());
            validationSetOptional.ifPresent(validationSet -> validationSet.getPropertyValidationRules().forEach(rule -> {
                ArrayList processedTargets = new ArrayList();
                rule.getTargets().forEach(originalTarget -> cache.getOutput(originalTarget).filter(WidgetDescription.class::isInstance).map(WidgetDescription.class::cast).map(target -> processedTargets.add(target)));
                rule.getTargets().clear();
                rule.getTargets().addAll(processedTargets);
            }));
        });
    }
}

