/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.ecore.resource;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsat.common.emf.ecore.resource.ResourceDiagnosticException;

class ResourceDiagnosticInfo
implements Diagnostic,
Resource.Diagnostic {
    private static final String DEFAULT_SOURCE = ResourceDiagnosticInfo.class.getPackage().getName();
    private final ResourceDiagnosticException.Severity severity;
    private final String source;
    private final int code;
    private final String message;
    private final Throwable exception;
    private URI location;
    private int line;
    private int column;
    private final Map<String, Object> details = new LinkedHashMap<String, Object>(3);

    public ResourceDiagnosticInfo(ResourceDiagnosticException.Severity severity, String source, int code, String message, Throwable exception, URI location, int line, int column) {
        this.severity = severity;
        this.source = source == null ? DEFAULT_SOURCE : source;
        this.code = code;
        this.message = message;
        this.exception = exception;
        this.location = location;
        this.line = line;
        this.column = column;
    }

    public int getSeverity() {
        return this.severity.getSeverity();
    }

    public ResourceDiagnosticException.Severity getSeverityEnum() {
        return this.severity;
    }

    public String getSource() {
        return this.source;
    }

    public int getCode() {
        return this.code;
    }

    public String getOriginalMessage() {
        return this.message;
    }

    public String getMessage() {
        return this.toString();
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getLocation() {
        return this.location == null ? null : this.location.toString();
    }

    public URI getLocationURI() {
        return this.location;
    }

    public void setLocationURI(URI location) {
        this.location = location;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void addDetail(String key, Object value) {
        if (this.details.containsKey(key)) {
            throw new IllegalArgumentException("Detail for key '" + key + "' already present.");
        }
        this.details.put(key, value);
    }

    public void getDetail(String key, Object value) {
        if (!this.details.containsKey(key)) {
            throw new IllegalArgumentException("Detail for key '" + key + "' not present.");
        }
        this.details.put(key, value);
    }

    public List<?> getData() {
        return this.exception == null ? Arrays.asList(this) : Arrays.asList(this.exception, this);
    }

    public List<Diagnostic> getChildren() {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder detailsText = new StringBuilder();
        if (this.location != null) {
            detailsText.append(this.location);
        }
        if (this.line != -1) {
            if (detailsText.length() > 0) {
                detailsText.append(" ");
            }
            detailsText.append("at line ").append(this.line);
            if (this.column != -1) {
                detailsText.append(" : ").append(this.column);
            }
        }
        for (Map.Entry<String, Object> entry : this.details.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (detailsText.length() > 0) {
                detailsText.append(", ");
            }
            detailsText.append(key).append(": ").append(value);
        }
        StringBuilder result = new StringBuilder();
        result.append(this.message == null ? "<no message>" : this.message);
        if (detailsText.length() > 0) {
            result.append(" (").append((CharSequence)detailsText).append(")");
        }
        return result.toString();
    }
}

