/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IWorkbenchPage;

public class SizeWidthAction
extends DiagramAction {
    public SizeWidthAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public void init() {
        super.init();
        this.setId("makeSameWidthAction");
        this.setText(DiagramUIActionsMessages.SameSizeAction_MakeSameSizeWidth_ActionLabelText);
        this.setToolTipText(DiagramUIActionsMessages.SameSizeAction_MakeSameSizeWidth_ActionToolTipText);
        this.setImageDescriptor(DiagramUIActionsPluginImages.DESC_MAKE_SAME_SIZE_WIDTH);
        this.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_MAKE_SAME_SIZE_WIDTH);
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected Command getCommand() {
        CompoundCommand doResizeCmd = new CompoundCommand();
        Iterator iter = this.getSelectedObjects().iterator();
        int last = this.getSelectedObjects().size() - 1;
        IGraphicalEditPart primary = (IGraphicalEditPart)this.getSelectedObjects().get(last);
        View primaryView = (View)primary.getModel();
        Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Dimension primarySize = width == -1 || height == -1 ? primary.getFigure().getSize().getCopy() : new Dimension(width.intValue(), height.intValue());
        while (iter.hasNext()) {
            IGraphicalEditPart toResize = (IGraphicalEditPart)iter.next();
            View resizeView = (View)toResize.getModel();
            Dimension size = primarySize.getCopy();
            size.height = (Integer)ViewUtil.getStructuralFeatureValue((View)resizeView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            doResizeCmd.add((Command)new ICommandProxy((ICommand)new SetBoundsCommand(toResize.getEditingDomain(), "", (IAdaptable)new EObjectAdapter((EObject)resizeView), size)));
        }
        return doResizeCmd.unwrap();
    }

    protected boolean calculateEnabled() {
        List selection = this.getSelectedObjects();
        return selection.size() >= 2;
    }
}

