/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.BinaryOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;

public class LeftShiftOperator
extends BinaryOperator {
    public LeftShiftOperator(int resultId, int leftTypeId, int rightTypeId, int start) {
        this(resultId, leftTypeId, rightTypeId, false, start);
    }

    protected LeftShiftOperator(int resultId, int leftTypeId, int rightTypeId, boolean isAssignmentOperator, int start) {
        super(resultId, leftTypeId, rightTypeId, isAssignmentOperator, start);
    }

    @Override
    protected boolean getBooleanResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        return false;
    }

    @Override
    protected double getDoubleResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        return 0.0;
    }

    @Override
    protected float getFloatResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        return 0.0f;
    }

    @Override
    protected int getIntResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        switch (this.fRightTypeId) {
            case 7: {
                return ((IJavaPrimitiveValue)leftOperand).getIntValue() << (int)((IJavaPrimitiveValue)rightOperand).getLongValue();
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                return ((IJavaPrimitiveValue)leftOperand).getIntValue() << ((IJavaPrimitiveValue)rightOperand).getIntValue();
            }
        }
        return 0;
    }

    @Override
    protected long getLongResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        switch (this.fRightTypeId) {
            case 7: {
                return ((IJavaPrimitiveValue)leftOperand).getLongValue() << (int)((IJavaPrimitiveValue)rightOperand).getLongValue();
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                return ((IJavaPrimitiveValue)leftOperand).getLongValue() << ((IJavaPrimitiveValue)rightOperand).getIntValue();
            }
        }
        return 0L;
    }

    @Override
    protected String getStringResult(IJavaValue leftOperand, IJavaValue rightOperand) {
        return null;
    }

    @Override
    protected int getInternResultType() {
        return LeftShiftOperator.getUnaryPromotionType(this.fLeftTypeId);
    }

    public String toString() {
        return InstructionsEvaluationMessages.LeftShiftOperator_______operator_1;
    }
}

