/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.texteditorbase;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager {
    protected Map<RGB, Color> cache = Maps.map();

    public void dispose() {
        Iterator<Color> e = this.cache.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
        this.cache.clear();
    }

    public Color getColor(RGB rgb) {
        Color rslt = this.cache.get(rgb);
        if (rslt == null) {
            rslt = new Color((Device)Display.getCurrent(), rgb);
            this.cache.put(rgb, rslt);
        }
        return rslt;
    }

    public IToken createColorToken(RGB rgb) {
        return new Token((Object)new TextAttribute(this.getColor(rgb)));
    }
}

