/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.properties.core.api.DefaultDescriptionPreprocessor;
import org.eclipse.sirius.properties.core.api.OverridesProvider;
import org.eclipse.sirius.properties.core.api.TransformationCache;
import org.eclipse.sirius.properties.core.internal.converter.SiriusInitialOperationAdapter;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;

public class DefaultDescriptionPreprocessorWithFiltering<SIRIUS extends EObject>
extends DefaultDescriptionPreprocessor<SIRIUS> {
    private Collection<EStructuralFeature> featuresToFilter = new ArrayList<EStructuralFeature>();
    private Collection<EStructuralFeature> featuresToCopy = new ArrayList<EStructuralFeature>();

    public DefaultDescriptionPreprocessorWithFiltering(Class<SIRIUS> descriptionClass, Collection<EStructuralFeature> featuresToFilter, Collection<EStructuralFeature> featuresToCopy) {
        super(descriptionClass);
        this.featuresToCopy.addAll(featuresToCopy);
        this.featuresToFilter.addAll(featuresToFilter);
    }

    @Override
    protected void processDescriptionFeature(EStructuralFeature feature, SIRIUS processedDescription, SIRIUS currentDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        if (!this.featuresToFilter.contains(feature)) {
            if (this.featuresToCopy.contains(feature)) {
                if (!feature.isMany()) {
                    this.processMonoValuedFeatureByCopying(feature, processedDescription, currentDescription, cache);
                } else {
                    this.processManyValuedFeatureByCopying(feature, processedDescription, currentDescription, cache, interpreter, variableManager, overridesProvider);
                }
            } else {
                super.processDescriptionFeature(feature, processedDescription, currentDescription, cache, interpreter, variableManager, overridesProvider);
            }
        }
    }

    private void processMonoValuedFeatureByCopying(EStructuralFeature monoValuedfeature, SIRIUS processedDescription, SIRIUS currentDescription, TransformationCache cache) {
        Object existingValue;
        if (!processedDescription.eIsSet(monoValuedfeature) && (existingValue = currentDescription.eGet(monoValuedfeature)) instanceof EObject) {
            EObject newValue = EcoreUtil.copy((EObject)((EObject)existingValue));
            cache.put(existingValue, newValue);
            processedDescription.eSet(monoValuedfeature, (Object)newValue);
            if (existingValue instanceof InitialOperation) {
                newValue.eAdapters().add((Object)new SiriusInitialOperationAdapter(EcoreUtil.getURI((EObject)((InitialOperation)existingValue))));
            }
        }
    }

    protected void processManyValuedFeatureByCopying(EStructuralFeature manyValuedFeature, SIRIUS processedDescription, SIRIUS currentDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        Object processedValue = processedDescription.eGet(manyValuedFeature);
        Object currentValue = currentDescription.eGet(manyValuedFeature);
        if (currentValue instanceof Iterable && processedValue instanceof Iterable) {
            ArrayList newValue = new ArrayList();
            Iterable currentIterable = (Iterable)currentValue;
            Iterable processedIterable = (Iterable)processedValue;
            StreamSupport.stream(currentIterable.spliterator(), false).filter(EObject.class::isInstance).map(EObject.class::cast).forEach(object -> {
                if (!this.isFiltered(manyValuedFeature, (EObject)processedDescription, (EObject)object, cache, interpreter, variableManager, overridesProvider)) {
                    EObject newEObject = EcoreUtil.copy((EObject)object);
                    cache.put(object, newEObject);
                    newValue.add(newEObject);
                    if (object instanceof InitialOperation) {
                        newEObject.eAdapters().add((Object)new SiriusInitialOperationAdapter(EcoreUtil.getURI((EObject)object)));
                    }
                }
            });
            processedIterable.forEach(newValue::add);
            processedDescription.eSet(manyValuedFeature, newValue);
        }
    }
}

