/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.options;

import org.eclipse.escet.cif.common.CifValidationUtils;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.java.Strings;

public class SupervisorNameOption
extends StringOption {
    public SupervisorNameOption() {
        super("Supervisor name", "The name of the resulting supervisor automaton. [DEFAULT=\"sup\"]", Character.valueOf('s'), "sup-name", "SNAME", null, true, true, "The name of the resulting supervisor automaton.", "Name:");
    }

    public static String getSupervisorName(String defaultName) {
        String name = (String)Options.get(SupervisorNameOption.class);
        if (name == null) {
            name = defaultName;
        }
        if (!CifValidationUtils.isValidIdentifier((String)name)) {
            String msg = Strings.fmt((String)"Supervisor name \"%s\" is not a valid CIF identifier.", (Object[])new Object[]{name});
            throw new InvalidOptionException(msg);
        }
        return name;
    }
}

