/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.typechecker;

import java.util.Locale;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public class SemanticProblem
implements Comparable<SemanticProblem> {
    public final String message;
    public final SemanticProblemSeverity severity;
    public final Position position;

    public SemanticProblem(String message, SemanticProblemSeverity severity, Position position) {
        Assert.notNull((Object)message);
        Assert.notNull((Object)position);
        this.message = message;
        this.severity = severity;
        this.position = position;
    }

    public boolean equals(Object obj) {
        SemanticProblem other = (SemanticProblem)obj;
        return this.severity == other.severity && PositionUtils.equalPositions((Position)this.position, (Position)other.position) && this.message.equals(other.message);
    }

    public int hashCode() {
        return this.severity.hashCode() ^ PositionUtils.hashPosition((Position)this.position) ^ this.message.hashCode();
    }

    @Override
    public int compareTo(SemanticProblem other) {
        int rslt = this.severity.compareTo(other.severity);
        if (rslt != 0) {
            return rslt;
        }
        String src1 = this.position.getSource();
        String src2 = other.position.getSource();
        if (src1 == null && src2 != null) {
            return -1;
        }
        if (src1 != null && src2 == null) {
            return 1;
        }
        if (src1 != null && src2 != null && (rslt = Strings.SORTER.compare(src1, src2)) != 0) {
            return rslt;
        }
        rslt = Strings.SORTER.compare(this.position.getLocation(), other.position.getLocation());
        if (rslt != 0) {
            return rslt;
        }
        rslt = Integer.valueOf(this.position.getStartOffset()).compareTo(other.position.getStartOffset());
        if (rslt != 0) {
            return rslt;
        }
        rslt = Integer.valueOf(this.position.getEndOffset()).compareTo(other.position.getEndOffset());
        if (rslt != 0) {
            return rslt;
        }
        return Strings.SORTER.compare(this.message, other.message);
    }

    public String toString() {
        String src = this.position.getSource();
        if (src == null) {
            src = "";
        }
        return Strings.fmt((String)"%sSemantic %s at line %d, column %d: %s", (Object[])new Object[]{src, this.severity.name().toLowerCase(Locale.US), this.position.getStartLine(), this.position.getStartColumn(), this.message});
    }
}

