/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.spec;

import com.github.javabdd.BDDDomain;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.datasynth.bdd.BddUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class SynthesisVariable {
    public final String name;
    public final String rawName;
    public int group = -1;
    public final int count;
    public final int lower;
    public final int upper;
    public BDDDomain domain;
    public BDDDomain domainNew;

    public SynthesisVariable(PositionObject obj, int count, int lower, int upper) {
        Assert.check((lower <= upper ? 1 : 0) != 0);
        Assert.check((count > 0 ? 1 : 0) != 0);
        Assert.check((count == upper - lower + 1 ? 1 : 0) != 0);
        this.name = CifTextUtils.getAbsName((PositionObject)obj);
        this.rawName = CifTextUtils.getAbsName((PositionObject)obj, (boolean)false);
        this.count = count;
        this.lower = lower;
        this.upper = upper;
    }

    public abstract int getDomainSize();

    public int getBddVarCount() {
        if (this.domain != null) {
            return this.domain.varNum();
        }
        int size = this.getDomainSize();
        int maxValue = size - 1;
        return BddUtils.getMinimumBits(maxValue);
    }

    public String toString() {
        return this.toString(0, "Variable: ");
    }

    public abstract String getKindText();

    public abstract String getTypeText();

    public String toString(int indent, String prefix) {
        return Strings.fmt((String)"%s%s%s (group: %d, domain: %d+%d, BDD variables: %d, CIF/BDD values: %d/%d)", (Object[])new Object[]{Strings.duplicate((String)" ", (int)(2 * indent)), prefix, this.toStringInternal(), this.group, this.domain.getIndex(), this.domainNew.getIndex(), this.domain.varNum(), this.count, 1 << this.domain.varNum()});
    }

    protected abstract String toStringInternal();
}

