/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.library.AbstractOperation;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class ConstrainedOperation
extends AbstractOperation {
    protected final @NonNull ExpressionInOCL expressionInOCL;

    public ConstrainedOperation(@NonNull ExpressionInOCL expressionInOCL) {
        this.expressionInOCL = expressionInOCL;
    }

    @Override
    public @Nullable Object basicEvaluate(@NonNull Executor executor, @NonNull TypedElement caller, @Nullable Object @NonNull [] boxedSourceAndArgumentValues) {
        PivotUtil.checkExpression(this.expressionInOCL);
        EvaluationEnvironment nestedEvaluationEnvironment = ((Executor.ExecutorExtension)executor).pushEvaluationEnvironment((NamedElement)this.expressionInOCL, caller);
        nestedEvaluationEnvironment.add(ClassUtil.nonNullModel(this.expressionInOCL.getOwnedContext()), boxedSourceAndArgumentValues[0]);
        List<Variable> parameters = this.expressionInOCL.getOwnedParameters();
        if (!parameters.isEmpty()) {
            int i = 0;
            while (i < parameters.size()) {
                Object value = boxedSourceAndArgumentValues[i + 1];
                nestedEvaluationEnvironment.add(ClassUtil.nonNullModel(parameters.get(i)), value);
                ++i;
            }
        }
        try {
            OCLExpression bodyExpression = this.expressionInOCL.getOwnedBody();
            assert (bodyExpression != null);
            Object object = executor.evaluate(bodyExpression);
            return object;
        }
        finally {
            executor.popEvaluationEnvironment();
        }
    }

    @Override
    public @Nullable Object dispatch(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        assert (!PivotUtil.getReferredOperation(callExp).isIsValidating());
        List<OCLExpression> arguments = callExp.getOwnedArguments();
        @Nullable Object[] boxedSourceAndArgumentValues = new Object[1 + arguments.size()];
        boxedSourceAndArgumentValues[0] = sourceValue;
        int i = 0;
        while (i < arguments.size()) {
            OCLExpression argument = arguments.get(i);
            assert (argument != null);
            boxedSourceAndArgumentValues[1 + i] = executor.evaluate(argument);
            ++i;
        }
        return this.evaluate(executor, callExp, boxedSourceAndArgumentValues);
    }

    public @NonNull String toString() {
        return String.valueOf(this.expressionInOCL.eContainer());
    }
}

