/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.equivalence;

import java.util.Collections;
import java.util.List;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.automata.OutgoingEdgeIterator;
import org.eclipse.escet.cif.eventbased.equivalence.Block;
import org.eclipse.escet.cif.eventbased.equivalence.BlockLocation;
import org.eclipse.escet.cif.eventbased.equivalence.BlockPartitioner;
import org.eclipse.escet.cif.eventbased.equivalence.CounterExample;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class LangEquivCalculation
extends BlockPartitioner {
    public LangEquivCalculation(List<Automaton> automs) {
        super(automs, true);
        Assert.check((automs.size() == 2 ? 1 : 0) != 0);
    }

    public CounterExample checkLanguageEquivalence() {
        return this.performBlockPartitioning();
    }

    @Override
    protected CounterExample constructCounterExample(Block block, Event finalEvent) {
        List<Event> path = this.getReversePath(block);
        Collections.reverse(path);
        Location[] locs = new Location[2];
        Location[] newLocs = new Location[2];
        locs[0] = ((Automaton)this.automs.get((int)0)).initial;
        locs[1] = ((Automaton)this.automs.get((int)1)).initial;
        int pathIdx = 0;
        while (pathIdx < path.size()) {
            Event evt = path.get(pathIdx);
            newLocs[0] = this.getNextLocation(locs[0], evt);
            newLocs[1] = this.getNextLocation(locs[1], evt);
            if (newLocs[0] == null || newLocs[1] == null) {
                Assert.check((newLocs[0] != null || newLocs[1] != null ? 1 : 0) != 0);
                return new CounterExample(path.subList(0, pathIdx), locs, evt);
            }
            Location[] swap = locs;
            locs = newLocs;
            newLocs = swap;
            ++pathIdx;
        }
        return new CounterExample(path, locs, finalEvent);
    }

    private List<Event> getReversePath(Block blk) {
        List reversePath = Lists.list();
        BlockLocation best = null;
        for (BlockLocation bl : blk.locs) {
            if (best != null && bl.depth >= best.depth) continue;
            best = bl;
        }
        while (best.depth != 0) {
            BlockLocation bestPrev = null;
            Edge bestIncEdge = null;
            for (Edge incEdge : best.loc.getIncoming()) {
                BlockLocation prev = (BlockLocation)this.blockLocs.get(incEdge.srcLoc);
                if (bestPrev != null && bestPrev.depth <= prev.depth) continue;
                bestPrev = prev;
                bestIncEdge = incEdge;
            }
            reversePath.add(bestIncEdge.event);
            best = bestPrev;
        }
        return reversePath;
    }

    private Location getNextLocation(Location loc, Event evt) {
        OutgoingEdgeIterator iter = loc.getOutgoing(evt);
        if (!iter.hasNext()) {
            return null;
        }
        return ((Edge)iter.next()).dstLoc;
    }
}

